/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.ErrorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayAssert
extends ArrayAssert<CharArrayAssert, char[]> {
    protected CharArrayAssert(char ... actual) {
        super(CharArrayAssert.class, actual);
    }

    public CharArrayAssert contains(char ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public CharArrayAssert containsOnly(char ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public CharArrayAssert excludes(char ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    @Override
    public CharArrayAssert isEqualTo(char[] expected) {
        if (Arrays.equals((char[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    @Override
    public CharArrayAssert isNotEqualTo(char[] array) {
        if (!Arrays.equals((char[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }
}

