/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.test.eis.ant;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.jca.test.eis.ant.AbstractTask;
import org.jboss.jca.test.eis.ant.SecurityActions;
import org.jboss.jca.test.eis.impl.EISServer;

public class Start
extends AbstractTask {
    private String handler = null;
    private String classpathRef = null;
    private Classpath classpath = null;

    public void setHandler(String v) {
        this.handler = v;
    }

    public void setClasspathref(String v) {
        this.classpathRef = v;
    }

    public Classpath createClasspath() {
        this.classpath = new Classpath(this.getProject());
        return this.classpath;
    }

    @Override
    public void execute() throws BuildException {
        ClassLoader oldCl = SecurityActions.getThreadContextClassLoader();
        try {
            AntClassLoader cl = null;
            if (this.classpathRef != null || this.classpath != null) {
                Path p = new Path(this.getProject());
                if (this.classpathRef != null) {
                    Reference reference = new Reference(this.getProject(), this.classpathRef);
                    p.setRefid(reference);
                }
                if (this.classpath != null) {
                    p.append((Path)this.classpath);
                }
                cl = this.getProject().createClassLoader(Start.class.getClassLoader(), p);
                SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            }
            EISServer eisServer = new EISServer();
            eisServer.setHost(this.getHost());
            eisServer.setPort(this.getPort());
            eisServer.setHandlerClassName(this.handler);
            eisServer.setClassLoader((ClassLoader)cl);
            eisServer.startup();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            throw new BuildException("Error during start: " + t.getMessage(), t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldCl);
        }
    }

    public static class Classpath
    extends Path {
        public Classpath(Project p) {
            super(p);
        }
    }
}

