/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.XaPool;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.PoolImpl;

public class XaPoolImpl
extends PoolImpl
implements XaPool {
    private static final long serialVersionUID = 1L;
    protected Boolean isSameRmOverride;
    protected Boolean interleaving;
    protected Boolean padXid;
    protected Boolean wrapXaResource;
    protected Boolean noTxSeparatePool;

    public XaPoolImpl(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Capacity capacity, Boolean isSameRmOverride, Boolean interleaving, Boolean padXid, Boolean wrapXaResource, Boolean noTxSeparatePool) throws ValidateException {
        super(minPoolSize, initialPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, capacity);
        this.isSameRmOverride = isSameRmOverride;
        this.interleaving = interleaving;
        this.padXid = padXid;
        this.wrapXaResource = wrapXaResource;
        this.noTxSeparatePool = noTxSeparatePool;
    }

    public Boolean isSameRmOverride() {
        return this.isSameRmOverride;
    }

    public Boolean isInterleaving() {
        return this.interleaving;
    }

    public Boolean isPadXid() {
        return this.padXid;
    }

    public Boolean isWrapXaResource() {
        return this.wrapXaResource;
    }

    public Boolean isNoTxSeparatePool() {
        return this.noTxSeparatePool;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.interleaving == null ? 0 : this.interleaving.hashCode());
        result = 31 * result + (this.isSameRmOverride == null ? 0 : this.isSameRmOverride.hashCode());
        result = 31 * result + (this.noTxSeparatePool == null ? 0 : this.noTxSeparatePool.hashCode());
        result = 31 * result + (this.padXid == null ? 0 : this.padXid.hashCode());
        result = 31 * result + (this.wrapXaResource == null ? 0 : this.wrapXaResource.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XaPoolImpl)) {
            return false;
        }
        XaPoolImpl other = (XaPoolImpl)obj;
        if (this.interleaving == null ? other.interleaving != null : !this.interleaving.equals(other.interleaving)) {
            return false;
        }
        if (this.isSameRmOverride == null ? other.isSameRmOverride != null : !this.isSameRmOverride.equals(other.isSameRmOverride)) {
            return false;
        }
        if (this.noTxSeparatePool == null ? other.noTxSeparatePool != null : !this.noTxSeparatePool.equals(other.noTxSeparatePool)) {
            return false;
        }
        if (this.padXid == null ? other.padXid != null : !this.padXid.equals(other.padXid)) {
            return false;
        }
        return !(this.wrapXaResource == null ? other.wrapXaResource != null : !this.wrapXaResource.equals(other.wrapXaResource));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<xa-pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(XaPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(XaPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append(XaPool.Tag.INITIAL_POOL_SIZE).append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append(XaPool.Tag.INITIAL_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(XaPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(XaPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(XaPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(XaPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(XaPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(XaPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(XaPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(XaPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.capacity != null) {
            sb.append("<").append(XaPool.Tag.CAPACITY).append(">");
            sb.append(this.capacity);
            sb.append("</").append(XaPool.Tag.CAPACITY).append(">");
        }
        if (this.isSameRmOverride != null) {
            sb.append("<").append(XaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
            sb.append(this.isSameRmOverride);
            sb.append("</").append(XaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
        }
        if (this.interleaving != null && Boolean.TRUE.equals(this.interleaving)) {
            sb.append("<").append(XaPool.Tag.INTERLEAVING).append("/>");
        }
        if (this.noTxSeparatePool != null && Boolean.TRUE.equals(this.noTxSeparatePool)) {
            sb.append("<").append(XaPool.Tag.NO_TX_SEPARATE_POOLS).append("/>");
        }
        if (this.padXid != null) {
            sb.append("<").append(XaPool.Tag.PAD_XID).append(">");
            sb.append(this.padXid);
            sb.append("</").append(XaPool.Tag.PAD_XID).append(">");
        }
        if (this.wrapXaResource != null) {
            sb.append("<").append(XaPool.Tag.WRAP_XA_RESOURCE).append(">");
            sb.append(this.wrapXaResource);
            sb.append("</").append(XaPool.Tag.WRAP_XA_RESOURCE).append(">");
        }
        sb.append("</xa-pool>");
        return sb.toString();
    }
}

