/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.logging.Messages;

public class TimeOutImpl
extends CommonTimeOutImpl
implements TimeOut {
    private static final long serialVersionUID = -8797718258493768716L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final Boolean setTxQuertTimeout;
    private final Long queryTimeout;
    private final Long useTryLock;

    public TimeOutImpl(Long blockingTimeoutMillis, Long idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout, Boolean setTxQuertTimeout, Long queryTimeout, Long useTryLock) throws ValidateException {
        super(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        this.setTxQuertTimeout = setTxQuertTimeout;
        this.queryTimeout = queryTimeout;
        this.useTryLock = useTryLock;
        this.validate();
    }

    public final Boolean isSetTxQueryTimeout() {
        return this.setTxQuertTimeout;
    }

    public final Long getQueryTimeout() {
        return this.queryTimeout;
    }

    public final Long getUseTryLock() {
        return this.useTryLock;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.queryTimeout == null ? 0 : this.queryTimeout.hashCode());
        result = 31 * result + (this.setTxQuertTimeout == null ? 0 : this.setTxQuertTimeout.hashCode());
        result = 31 * result + (this.useTryLock == null ? 0 : this.useTryLock.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TimeOutImpl)) {
            return false;
        }
        TimeOutImpl other = (TimeOutImpl)obj;
        if (this.queryTimeout == null ? other.queryTimeout != null : !this.queryTimeout.equals(other.queryTimeout)) {
            return false;
        }
        if (this.setTxQuertTimeout == null ? other.setTxQuertTimeout != null : !this.setTxQuertTimeout.equals(other.setTxQuertTimeout)) {
            return false;
        }
        return !(this.useTryLock == null ? other.useTryLock != null : !this.useTryLock.equals(other.useTryLock));
    }

    @Override
    public String toString() {
        return "TimeOutImpl [setTxQuertTimeout=" + this.setTxQuertTimeout + ", queryTimeout=" + this.queryTimeout + ", useTryLock=" + this.useTryLock + "]";
    }

    public void validate() throws ValidateException {
        if (this.queryTimeout != null && this.queryTimeout < 0L) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.QUERYTIMEOUT.getLocalName()));
        }
        if (this.useTryLock != null && this.useTryLock < 0L) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.USETRYLOCK.getLocalName()));
        }
    }
}

