/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.Driver;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;

public class DatasourcesImpl
implements DataSources {
    private static final long serialVersionUID = 6933310057105771370L;
    private final ArrayList<DataSource> datasource;
    private final ArrayList<XaDataSource> xaDataSource;
    private final HashMap<String, Driver> drivers;

    public DatasourcesImpl(List<DataSource> datasource, List<XaDataSource> xaDataSource, HashMap<String, Driver> drivers) throws ValidateException {
        if (datasource != null) {
            this.datasource = new ArrayList(datasource.size());
            this.datasource.addAll(datasource);
        } else {
            this.datasource = new ArrayList(0);
        }
        if (xaDataSource != null) {
            this.xaDataSource = new ArrayList(xaDataSource.size());
            this.xaDataSource.addAll(xaDataSource);
        } else {
            this.xaDataSource = new ArrayList(0);
        }
        if (drivers != null) {
            this.drivers = new HashMap(drivers.size());
            this.drivers.putAll(drivers);
        } else {
            this.drivers = new HashMap(0);
        }
        this.validate();
    }

    public final List<DataSource> getDataSource() {
        return Collections.unmodifiableList(this.datasource);
    }

    public final List<XaDataSource> getXaDataSource() {
        return Collections.unmodifiableList(this.xaDataSource);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datasource == null ? 0 : this.datasource.hashCode());
        result = 31 * result + (this.xaDataSource == null ? 0 : this.xaDataSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasourcesImpl)) {
            return false;
        }
        DatasourcesImpl other = (DatasourcesImpl)obj;
        if (this.datasource == null ? other.datasource != null : !this.datasource.equals(other.datasource)) {
            return false;
        }
        return !(this.xaDataSource == null ? other.xaDataSource != null : !this.xaDataSource.equals(other.xaDataSource));
    }

    public String toString() {
        return "DatasourcesImpl [datasource=" + this.datasource + ", xaDataSource=" + this.xaDataSource + "]";
    }

    public void validate() throws ValidateException {
        for (DataSource ds : this.datasource) {
            ds.validate();
        }
        for (XaDataSource xads : this.xaDataSource) {
            xads.validate();
        }
    }

    public Driver getDriver(String name) {
        return this.drivers.get(name);
    }

    public List<Driver> getDrivers() {
        return Collections.unmodifiableList(new ArrayList<Driver>(this.drivers.values()));
    }
}

