/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.McfDef;
import org.jboss.jca.codegenerator.Profile;
import org.jboss.jca.codegenerator.Utils;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;
import org.jboss.jca.codegenerator.code.AoImplCodeGen;
import org.jboss.jca.codegenerator.code.AoInterfaceCodeGen;
import org.jboss.jca.codegenerator.xml.BuildIvyXmlGen;
import org.jboss.jca.codegenerator.xml.BuildXmlGen;
import org.jboss.jca.codegenerator.xml.IronjacamarXmlGen;
import org.jboss.jca.codegenerator.xml.IvySettingsXmlGen;
import org.jboss.jca.codegenerator.xml.IvyXmlGen;
import org.jboss.jca.codegenerator.xml.MbeanXmlGen;
import org.jboss.jca.codegenerator.xml.PackageHtmlGen;
import org.jboss.jca.codegenerator.xml.PomXmlGen;
import org.jboss.jca.codegenerator.xml.RaXmlGen;

public class BaseProfile
implements Profile {
    @Override
    public void generate(Definition def) {
        this.generatePackageHtml(def, def.getOutputDir(), null);
        this.generateRaCode(def);
        this.generateOutboundCode(def);
        this.generateInboundCode(def);
        this.generateTestCode(def);
        if (def.getBuild().equals("ivy")) {
            this.generateAntIvyXml(def, def.getOutputDir());
        } else if (def.getBuild().equals("maven")) {
            this.generateMavenXml(def, def.getOutputDir());
        } else {
            this.generateAntXml(def, def.getOutputDir());
        }
        this.generateRaXml(def, def.getOutputDir());
        if (def.isSupportOutbound()) {
            this.generateIronjacamarXml(def, def.getOutputDir());
        }
        if (def.isGenMbean() && def.isSupportOutbound() && !def.getMcfDefs().get(0).isUseCciConnection()) {
            this.generateMBeanCode(def);
            this.generateMbeanXml(def, def.getOutputDir());
        }
    }

    void generateRaCode(Definition def) {
        if (def.isUseRa()) {
            this.generateClassCode(def, "Ra");
            this.generateClassCode(def, "RaMeta");
        }
        if (def.isGenAdminObject()) {
            for (int i = 0; i < def.getAdminObjects().size(); ++i) {
                this.generateMultiAdminObjectClassCode(def, "AoImpl", i);
                this.generateMultiAdminObjectClassCode(def, "AoInterface", i);
            }
        }
    }

    void generateOutboundCode(Definition def) {
        if (def.isSupportOutbound()) {
            if (def.getMcfDefs() == null) {
                throw new IllegalStateException("Should define at least one mcf class");
            }
            for (int num = 0; num < def.getMcfDefs().size(); ++num) {
                this.generateMultiMcfClassCode(def, "Mcf", num);
                this.generateMultiMcfClassCode(def, "Mc", num);
                this.generateMultiMcfClassCode(def, "McMeta", num);
                if (!def.getMcfDefs().get(num).isUseCciConnection()) {
                    this.generateMultiMcfClassCode(def, "CfInterface", num);
                    this.generateMultiMcfClassCode(def, "Cf", num);
                    this.generateMultiMcfClassCode(def, "ConnInterface", num);
                    this.generateMultiMcfClassCode(def, "ConnImpl", num);
                    continue;
                }
                this.generateMultiMcfClassCode(def, "CciConn", num);
                this.generateMultiMcfClassCode(def, "CciConnFactory", num);
                this.generateMultiMcfClassCode(def, "ConnMeta", num);
                this.generateMultiMcfClassCode(def, "ConnSpec", num);
            }
        }
    }

    void generateInboundCode(Definition def) {
        if (def.isSupportInbound()) {
            if (def.isDefaultPackageInbound()) {
                this.generateClassCode(def, "Ml", "inflow");
            }
            this.generateClassCode(def, "As", "inflow");
            this.generateClassCode(def, "Activation", "inflow");
            this.generatePackageHtml(def, def.getOutputDir(), "inflow");
        }
    }

    void generateMBeanCode(Definition def) {
        if (def.isSupportOutbound()) {
            this.generateClassCode(def, "MbeanInterface", "mbean");
            this.generateClassCode(def, "MbeanImpl", "mbean");
            this.generatePackageHtml(def, def.getOutputDir(), "mbean");
        }
    }

    void generateClassCode(Definition def, String className) {
        this.generateClassCode(def, className, null);
    }

    void generateClassCode(Definition def, String className, String subDir) {
        if (className == null || className.equals("")) {
            return;
        }
        try {
            String clazzName = this.getClass().getPackage().getName() + ".code." + className + "CodeGen";
            String javaFile = (String)Definition.class.getMethod("get" + className + "Class", new Class[0]).invoke((Object)def, (Object[])null) + ".java";
            FileWriter fw = null;
            fw = subDir == null ? Utils.createSrcFile(javaFile, def.getRaPackage(), def.getOutputDir()) : Utils.createSrcFile(javaFile, def.getRaPackage() + "." + subDir, def.getOutputDir());
            Class<?> clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            AbstractCodeGen codeGen = (AbstractCodeGen)clazz.newInstance();
            codeGen.generate(def, fw);
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void generateMultiMcfClassCode(Definition def, String className, int num) {
        if (className == null || className.equals("")) {
            return;
        }
        if (num < 0 || num + 1 > def.getMcfDefs().size()) {
            return;
        }
        try {
            String clazzName = this.getClass().getPackage().getName() + ".code." + className + "CodeGen";
            String javaFile = (String)McfDef.class.getMethod("get" + className + "Class", new Class[0]).invoke((Object)def.getMcfDefs().get(num), (Object[])null) + ".java";
            FileWriter fw = null;
            fw = Utils.createSrcFile(javaFile, def.getRaPackage(), def.getOutputDir());
            Class<?> clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            AbstractCodeGen codeGen = (AbstractCodeGen)clazz.newInstance();
            codeGen.setNumOfMcf(num);
            codeGen.generate(def, fw);
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void generateMultiAdminObjectClassCode(Definition def, String className, int num) {
        if (className == null || className.equals("")) {
            return;
        }
        try {
            String clazzName = this.getClass().getPackage().getName() + ".code." + className + "CodeGen";
            Class<?> clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            AbstractCodeGen codeGen = (AbstractCodeGen)clazz.newInstance();
            String javaFile = "";
            if (codeGen instanceof AoImplCodeGen) {
                ((AoImplCodeGen)codeGen).setNumOfAo(num);
                javaFile = def.getAdminObjects().get(num).getAdminObjectClass() + ".java";
            } else if (codeGen instanceof AoInterfaceCodeGen) {
                ((AoInterfaceCodeGen)codeGen).setNumOfAo(num);
                javaFile = def.getAdminObjects().get(num).getAdminObjectInterface() + ".java";
            }
            FileWriter fw = Utils.createSrcFile(javaFile, def.getRaPackage(), def.getOutputDir());
            codeGen.generate(def, fw);
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void generateAntXml(Definition def, String outputDir) {
        try {
            FileWriter antfw = Utils.createFile("build.xml", outputDir);
            BuildXmlGen bxGen = new BuildXmlGen();
            bxGen.generate(def, antfw);
            antfw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generateAntIvyXml(Definition def, String outputDir) {
        try {
            FileWriter antfw = Utils.createFile("build.xml", outputDir);
            BuildIvyXmlGen bxGen = new BuildIvyXmlGen();
            bxGen.generate(def, antfw);
            antfw.close();
            FileWriter ivyfw = Utils.createFile("ivy.xml", outputDir);
            IvyXmlGen ixGen = new IvyXmlGen();
            ixGen.generate(def, ivyfw);
            ivyfw.close();
            FileWriter ivySettingsfw = Utils.createFile("ivy.settings.xml", outputDir);
            IvySettingsXmlGen isxGen = new IvySettingsXmlGen();
            isxGen.generate(def, ivySettingsfw);
            ivySettingsfw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generateMavenXml(Definition def, String outputDir) {
        try {
            FileWriter pomfw = Utils.createFile("pom.xml", outputDir);
            PomXmlGen pxGen = new PomXmlGen();
            pxGen.generate(def, pomfw);
            pomfw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generateRaXml(Definition def, String outputDir) {
        if (!def.isUseAnnotation()) {
            try {
                outputDir = outputDir + File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "resources";
                FileWriter rafw = Utils.createFile("ra.xml", outputDir + File.separatorChar + "META-INF");
                RaXmlGen raGen = this.getRaXmlGen(def);
                raGen.generate(def, rafw);
                rafw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    RaXmlGen getRaXmlGen(Definition def) {
        return null;
    }

    void generateIronjacamarXml(Definition def, String outputDir) {
        try {
            String resourceDir = outputDir + File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "resources";
            this.writeIronjacamarXml(def, resourceDir);
            if (def.getBuild().equals("maven")) {
                String rarDir = outputDir + File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "rar";
                this.writeIronjacamarXml(def, rarDir);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void writeIronjacamarXml(Definition def, String outputDir) throws IOException {
        FileWriter ijfw = Utils.createFile("ironjacamar.xml", outputDir + File.separatorChar + "META-INF");
        IronjacamarXmlGen ijxGen = new IronjacamarXmlGen();
        ijxGen.generate(def, ijfw);
        ijfw.close();
    }

    void generateMbeanXml(Definition def, String outputDir) {
        String mbeanName = def.getDefaultValue().toLowerCase(Locale.US);
        if (def.getRaPackage() != null && !def.getRaPackage().equals("")) {
            mbeanName = def.getRaPackage().indexOf(46) >= 0 ? def.getRaPackage().substring(def.getRaPackage().lastIndexOf(46) + 1) : def.getRaPackage();
        }
        try {
            outputDir = outputDir + File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "resources";
            FileWriter mbfw = Utils.createFile(mbeanName + ".xml", outputDir);
            MbeanXmlGen mbGen = new MbeanXmlGen();
            mbGen.generate(def, mbfw);
            mbfw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generatePackageHtml(Definition def, String outputDir, String subDir) {
        try {
            FileWriter fw = null;
            fw = subDir == null ? Utils.createSrcFile("package.html", def.getRaPackage(), def.getOutputDir()) : Utils.createSrcFile("package.html", def.getRaPackage() + "." + subDir, def.getOutputDir());
            PackageHtmlGen phGen = new PackageHtmlGen();
            phGen.generate(def, fw);
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generateTestCode(Definition def) {
        if (!def.isSupportOutbound()) {
            return;
        }
        try {
            String clazzName = this.getClass().getPackage().getName() + ".code.TestCodeGen";
            String javaFile = "ConnectorTestCase.java";
            FileWriter fw = Utils.createTestFile(javaFile, def.getRaPackage(), def.getOutputDir());
            Class<?> clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            AbstractCodeGen codeGen = (AbstractCodeGen)clazz.newInstance();
            codeGen.generate(def, fw);
            fw.flush();
            fw.close();
            this.copyTestResourceFiles(def.getOutputDir(), "logging.properties");
            this.copyTestResourceFiles(def.getOutputDir(), "jndi.properties");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyTestResourceFiles(String outputDir, String filename) throws IOException {
        String testResourceDir = outputDir + "/src/test/resources";
        FileWriter fw = Utils.createFile(filename, testResourceDir);
        URL buildFile = BaseProfile.class.getResource("/" + filename + ".template");
        String buildString = Utils.readFileIntoString(buildFile);
        fw.write(buildString);
        fw.close();
    }
}

