/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.xml;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.SimpleTemplate;
import org.jboss.jca.codegenerator.Utils;
import org.jboss.jca.codegenerator.xml.AbstractXmlGen;

public class IronjacamarXmlGen
extends AbstractXmlGen {
    @Override
    public void writeXmlBody(Definition def, Writer out) throws IOException {
        out.write("<!--");
        this.writeEol(out);
        this.writeheader(def, out);
        out.write("-->");
        this.writeEol(out);
        this.writeEol(out);
        URL buildFile = IronjacamarXmlGen.class.getResource("/ironjacamar.xml.template");
        String buildString = Utils.readFileIntoString(buildFile);
        StringBuilder strRaProps = new StringBuilder();
        List<ConfigPropType> raPropsList = def.getRaConfigProps();
        this.getPropsString(strRaProps, raPropsList, 2);
        StringBuilder strMcf = new StringBuilder();
        strMcf.append("  <connection-definitions>\n");
        for (int num = 0; num < def.getMcfDefs().size(); ++num) {
            strMcf.append("    <connection-definition class-name=\"");
            strMcf.append(def.getRaPackage());
            strMcf.append(".");
            strMcf.append(def.getMcfDefs().get(num).getMcfClass());
            strMcf.append("\" enabled=\"true\" ");
            strMcf.append("jndi-name=\"java:/eis/");
            strMcf.append(def.getMcfDefs().get(num).getMcfClass());
            strMcf.append("\" use-java-context=\"true\" ");
            strMcf.append("pool-name=\"" + def.getMcfDefs().get(num).getMcfClass());
            strMcf.append("\">\n");
            StringBuilder strMcfProps = new StringBuilder();
            List<ConfigPropType> mcfPropsList = def.getMcfDefs().get(num).getMcfConfigProps();
            this.getPropsString(strMcfProps, mcfPropsList, 6);
            strMcf.append(strMcfProps.toString());
            strMcf.append("    </connection-definition>\n");
        }
        strMcf.append("  </connection-definitions>\n");
        StringBuilder strAo = new StringBuilder();
        if (def.isGenAdminObject()) {
            strAo.append("  <admin-objects>\n");
            for (int i = 0; i < def.getAdminObjects().size(); ++i) {
                strAo.append("    <admin-object class-name=\"");
                strAo.append(def.getRaPackage());
                strAo.append(".");
                strAo.append(def.getAdminObjects().get(i).getAdminObjectClass());
                strAo.append("\" jndi-name=\"java:/");
                strAo.append(def.getAdminObjects().get(i).getAdminObjectClass());
                strAo.append("\">\n");
                this.getPropsString(strAo, def.getAdminObjects().get(i).getAoConfigProps(), 6);
                strAo.append("    </admin-object>\n");
            }
            strAo.append("  </admin-objects>\n");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ra.props", strRaProps.toString());
        map.put("transaction", def.getSupportTransaction());
        map.put("mcfs", strMcf.toString());
        map.put("adminobjects", strAo.toString());
        SimpleTemplate template = new SimpleTemplate(buildString);
        template.process(map, out);
    }

    private void getPropsString(StringBuilder strProps, List<ConfigPropType> propsList, int indent) {
        for (ConfigPropType props : propsList) {
            for (int i = 0; i < indent; ++i) {
                strProps.append(" ");
            }
            strProps.append("<config-property name=\"");
            strProps.append(props.getName());
            strProps.append("\">");
            strProps.append(props.getValue());
            strProps.append("</config-property>");
            strProps.append("\n");
        }
    }
}

