/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class MbeanImplCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("public class " + this.getClassName(def) + " implements " + def.getMbeanInterfaceClass());
        this.writeLeftCurlyBracket(out, 0);
        this.writeVars(def, out, indent);
        this.writeEol(out);
        this.writeMBeanLifecycle(def, out, indent);
        this.writeEol(out);
        this.writeMethods(def, out, indent);
        this.writeEol(out);
        this.writeGetConnection(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    void writeConstructor(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.mbeanServer = null;");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.objectName = \"" + def.getDefaultValue() + ",class=HelloWorld\";");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.registered = false;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".mbean;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.management.MBeanServer;");
        this.writeEol(out);
        out.write("import javax.management.ObjectName;");
        this.writeEol(out);
        out.write("import javax.naming.InitialContext;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import " + def.getRaPackage() + "." + def.getConnInterfaceClass() + ";");
        this.writeEol(out);
        out.write("import " + def.getRaPackage() + "." + def.getCfInterfaceClass() + ";");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMbeanImplClass();
    }

    private void writeVars(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** JNDI name */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static final String JNDI_NAME = \"java:/eis/" + def.getDefaultValue() + "\";");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** MBeanServer instance */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private MBeanServer mbeanServer;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** Object Name */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private String objectName;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The actual ObjectName instance */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private ObjectName on;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** Registered */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private boolean registered;");
        this.writeEol(out);
        this.writeEol(out);
    }

    private void writeMethods(Definition def, Writer out, int indent) throws IOException {
        if (def.isDefineMethodInConnection()) {
            if (def.getMethods().size() > 0) {
                for (MethodForConnection method : def.getMethods()) {
                    MethodParam param;
                    int i;
                    this.writeIndent(out, indent);
                    out.write("/**");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" * Call " + method.getMethodName());
                    this.writeEol(out);
                    for (MethodParam param2 : method.getParams()) {
                        this.writeIndent(out, indent);
                        out.write(" * @param " + param2.getName() + " " + param2.getName());
                        this.writeEol(out);
                    }
                    if (!method.getReturnType().equals("void")) {
                        this.writeIndent(out, indent);
                        out.write(" * @return " + method.getReturnType());
                        this.writeEol(out);
                    }
                    this.writeIndent(out, indent);
                    out.write(" * @throws Exception exception");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" */");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write("public " + method.getReturnType() + " " + method.getMethodName() + "(");
                    int paramSize = method.getParams().size();
                    for (i = 0; i < paramSize; ++i) {
                        param = method.getParams().get(i);
                        out.write(param.getType());
                        out.write(" ");
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(") throws Exception");
                    this.writeLeftCurlyBracket(out, indent);
                    this.writeIndent(out, indent + 1);
                    if (!method.getReturnType().equals("void")) {
                        out.write("return ");
                    }
                    out.write("getConnection()." + method.getMethodName() + "(");
                    for (i = 0; i < paramSize; ++i) {
                        param = method.getParams().get(i);
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(");");
                    this.writeEol(out);
                    this.writeRightCurlyBracket(out, indent);
                }
            }
        } else {
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Call me");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @throws Exception exception");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("@Override");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void callMe() throws Exception");
            this.writeLeftCurlyBracket(out, indent);
            this.writeIndent(out, indent + 1);
            out.write("getConnection().callMe();");
            this.writeRightCurlyBracket(out, indent);
        }
    }

    private void writeGetConnection(Definition def, Writer out, int indent) throws IOException {
        String connInterface = def.getConnInterfaceClass();
        String cfInterface = def.getCfInterfaceClass();
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * GetConnection");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return " + connInterface);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private " + connInterface + " getConnection() throws Exception");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("InitialContext context = new InitialContext();");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write(cfInterface + " factory = (" + cfInterface + ")context.lookup(JNDI_NAME);");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write(connInterface + " conn = factory.getConnection();");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("if (conn == null)");
        this.writeLeftCurlyBracket(out, indent + 1);
        this.writeIndent(out, indent + 2);
        out.write("throw new RuntimeException(\"No connection\");");
        this.writeRightCurlyBracket(out, indent + 1);
        this.writeIndent(out, indent + 1);
        out.write("return conn;");
        this.writeRightCurlyBracket(out, indent);
    }

    private void writeMBeanLifecycle(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the MBean server");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param v The value");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setMBeanServer(MBeanServer v)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("mbeanServer = v;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Start");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception Throwable Thrown in case of an error");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void start() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("if (mbeanServer == null)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("throw new IllegalArgumentException(\"MBeanServer is null\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("on = new ObjectName(mbeanServer.getDefaultDomain() + objectName);");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("mbeanServer.registerMBean(this, on);");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("registered = true;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Stop");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception Throwable Thrown in case of an error");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void stop() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("if (registered)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("mbeanServer.unregisterMBean(on); ");
        this.writeRightCurlyBracket(out, indent);
    }
}

