/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.PropsCodeGen;

public class McfCodeGen
extends PropsCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        if (def.isUseAnnotation()) {
            if (!def.isUseCciConnection()) {
                out.write("@ConnectionDefinition(connectionFactory = " + def.getCfInterfaceClass() + ".class,");
                this.writeEol(out);
                this.writeIndent(out, indent);
                out.write("connectionFactoryImpl = " + def.getCfClass() + ".class,");
                this.writeEol(out);
                this.writeIndent(out, indent);
                out.write("connection = " + def.getConnInterfaceClass() + ".class,");
                this.writeEol(out);
                this.writeIndent(out, indent);
                out.write("connectionImpl = " + def.getConnImplClass() + ".class)");
                this.writeEol(out);
            } else {
                out.write("@ConnectionDefinition(connectionFactory = ConnectionFactory.class,");
                this.writeEol(out);
                this.writeIndent(out, indent);
                out.write("connectionFactoryImpl = " + def.getCciConnFactoryClass() + ".class,");
                this.writeEol(out);
                this.writeIndent(out, indent);
                out.write("connection = Connection.class,");
                this.writeEol(out);
                this.writeIndent(out, indent);
                out.write("connectionImpl = " + def.getCciConnClass() + ".class)");
                this.writeEol(out);
            }
        }
        out.write("public class " + this.getClassName(def) + " implements ManagedConnectionFactory");
        if (def.isImplRaAssociation()) {
            out.write(", ResourceAdapterAssociation");
        }
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(\"" + this.getClassName(def) + "\");");
        this.writeEol(out);
        this.writeEol(out);
        if (def.isImplRaAssociation()) {
            this.writeIndent(out, indent);
            out.write("/** The resource adapter */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("private ResourceAdapter ra;");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeIndent(out, indent);
        out.write("/** The logwriter */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private PrintWriter logwriter;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConfigProps(def, out, indent);
        this.writeConnectionFactory(def, out, indent);
        this.writeManagedConnection(def, out, indent);
        this.writeLogWriter(def, out, indent);
        if (def.isImplRaAssociation()) {
            this.writeResourceAdapter(def, out, indent);
        }
        this.writeHashCode(def, out, indent);
        this.writeEquals(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.io.PrintWriter;");
        this.writeEol(out);
        out.write("import java.util.Set;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        if (def.isUseCciConnection()) {
            out.write("import javax.resource.cci.Connection;");
            this.writeEol(out);
            out.write("import javax.resource.cci.ConnectionFactory;");
            this.writeEol(out);
        }
        if (def.isUseAnnotation()) {
            out.write("import javax.resource.spi.ConfigProperty;");
            this.writeEol(out);
            out.write("import javax.resource.spi.ConnectionDefinition;");
            this.writeEol(out);
        }
        out.write("import javax.resource.spi.ConnectionManager;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionRequestInfo;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ManagedConnection;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ManagedConnectionFactory;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ResourceAdapter;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ResourceAdapterAssociation;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.security.auth.Subject;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.util.logging.Logger;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getMcfClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getMcfConfigProps();
    }

    private void writeConnectionFactory(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Creates a Connection Factory instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param    cxManager    ConnectionManager to be associated with created EIS connection factory instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return   EIS-specific Connection Factory instance or javax.resource.cci.ConnectionFactory instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws   ResourceException Generic exception");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isImplRaAssociation()) {
            this.writeIfRaNull(out, indent);
        }
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call createConnectionFactory\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        if (def.isUseCciConnection()) {
            out.write("return new " + def.getCciConnFactoryClass() + "(cxManager);");
        } else {
            out.write("return new " + def.getCfClass() + "(cxManager);");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Creates a Connection Factory instance. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return   EIS-specific Connection Factory instance or javax.resource.cci.ConnectionFactory instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws   ResourceException Generic exception");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Object createConnectionFactory() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isImplRaAssociation()) {
            this.writeIfRaNull(out, indent);
        }
        this.writeIndent(out, indent + 1);
        if (def.isUseCciConnection()) {
            out.write("return new " + def.getCciConnFactoryClass() + "(new " + def.getCmClass() + "());");
        } else {
            out.write("return new " + def.getCfClass() + "(new " + def.getCmClass() + "());");
        }
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeIfRaNull(Writer out, int indent) throws IOException {
        this.writeIndent(out, indent + 1);
        out.write("if (ra == null)");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("throw new IllegalStateException(\"RA is null\");");
        this.writeEol(out);
    }

    private void writeManagedConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Creates a new physical connection to the underlying EIS resource manager.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   subject        Caller's security information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   cxRequestInfo  Additional resource adapter specific connection request information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws  ResourceException     generic exception");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return  ManagedConnection instance ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ManagedConnection createManagedConnection(Subject subject,");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("ConnectionRequestInfo cxRequestInfo) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isImplRaAssociation()) {
            this.writeIfRaNull(out, indent);
        }
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call createManagedConnection\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Returns a matched connection from the candidate set of connections. ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   connectionSet   candidate connection set");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   subject        Caller's security information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   cxRequestInfo  Additional resource adapter specific connection request information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws  ResourceException     generic exception");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return  ManagedConnection if resource adapter finds an acceptable match otherwise null ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ManagedConnection matchManagedConnections(Set connectionSet,");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        if (def.isImplRaAssociation()) {
            this.writeIfRaNull(out, indent);
        }
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call matchManagedConnections\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeLogWriter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the log writer for this ManagedConnectionFactory instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return  PrintWriter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws  ResourceException     generic exception");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public PrintWriter getLogWriter() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call getLogWriter\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return logwriter;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the log writer for this ManagedConnectionFactory instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   out PrintWriter - an out stream for error logging and tracing");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws  ResourceException     generic exception");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setLogWriter(PrintWriter out) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call setLogWriter\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("logwriter = out;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResourceAdapter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ResourceAdapter getResourceAdapter()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call getResourceAdapter\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param ra The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setResourceAdapter(ResourceAdapter ra)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call setResourceAdapter\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.ra = ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

