/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class CfCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements " + def.getCfInterfaceClass());
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("private Reference reference;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDefaultConstructor(def, out, indent);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * default constructor");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   cxManager ConnectionManager");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + this.getClassName(def) + "(ConnectionManager cxManager)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeConnection(def, out, indent);
        this.writeReference(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.io.Serializable;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.naming.NamingException;");
        this.writeEol(out);
        out.write("import javax.naming.Reference;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.Referenceable;");
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionManager;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getCfClass();
    }

    private void writeConnection(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** ");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * get connection from factory");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return " + def.getConnInterfaceClass() + " instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception ResourceException Thrown if a connection can't be obtained");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public " + def.getConnInterfaceClass() + " getConnection() throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return new " + def.getConnImplClass() + "();");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeReference(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the Reference instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Reference instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception NamingException Thrown if a reference can't be obtained");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Reference getReference() throws NamingException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the Reference instance.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param   reference  A Reference instance");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setReference(Reference reference)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("this.reference = reference;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

