/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class CmCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements ConnectionManager");
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeDefaultConstructor(def, out, indent);
        this.writeAllocateConn(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionManager;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ConnectionRequestInfo;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ManagedConnectionFactory;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getCmClass();
    }

    private void writeAllocateConn(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Allocate a connection");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param mcf The managed connection factory");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param cri The connection request information");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return Object The connection");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception ResourceException Thrown if an error occurs");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Override");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public Object allocateConnection(ManagedConnectionFactory mcf,ConnectionRequestInfo cri) throws ResourceException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("return null;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

