/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.util.concurrent.Executor;
import org.jboss.invocation.AsynchronousInterceptor;
import org.jboss.invocation.AsynchronousInterceptorContext;
import org.jboss.invocation.AsynchronousTask;
import org.wildfly.common.Assert;

public final class ExecutorAsynchronousInterceptor
implements AsynchronousInterceptor {
    private final Executor executor;
    private final boolean onlyIfBlocking;

    public ExecutorAsynchronousInterceptor(Executor executor, boolean onlyIfBlocking) {
        this.onlyIfBlocking = onlyIfBlocking;
        Assert.checkNotNullParam((String)"executor", (Object)executor);
        this.executor = executor;
    }

    @Override
    public AsynchronousInterceptor.CancellationHandle processInvocation(AsynchronousInterceptorContext context, AsynchronousInterceptor.ResultHandler resultHandler) {
        boolean ibc = context.isBlockingCaller();
        if (ibc) {
            context.setBlockingCaller(false);
        } else if (this.onlyIfBlocking) {
            return context.proceed(resultHandler);
        }
        AsynchronousTask task = new AsynchronousTask(context, resultHandler);
        this.executor.execute(task);
        return task;
    }
}

