/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import org.jboss.invocation.AsynchronousInterceptor;
import org.jboss.invocation.AsynchronousInterceptorContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.common.Assert;

public final class SynchronousInterceptor
implements AsynchronousInterceptor {
    private final Interceptor[] interceptors;

    public SynchronousInterceptor(Interceptor[] interceptors) {
        Assert.checkNotNullParam((String)"interceptors", (Object)interceptors);
        this.interceptors = interceptors;
    }

    @Override
    public AsynchronousInterceptor.CancellationHandle processInvocation(AsynchronousInterceptorContext context, AsynchronousInterceptor.ResultHandler resultHandler) {
        InterceptorContext synchContext = context.toSynchronous();
        synchContext.setInterceptors(this.interceptors);
        try {
            resultHandler.setResult(AsynchronousInterceptor.ResultSupplier.succeeded(synchContext.proceed()));
        }
        catch (Exception e) {
            resultHandler.setException(e);
        }
        return AsynchronousInterceptor.CancellationHandle.NULL;
    }
}

