/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.jboss.invocation.AbstractInterceptorContext;
import org.jboss.invocation.AsynchronousInterceptorContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InvocationMessages;

public final class InterceptorContext
extends AbstractInterceptorContext
implements Cloneable,
PrivilegedExceptionAction<Object> {
    private static final Interceptor[] EMPTY = new Interceptor[0];
    private Interceptor[] interceptors = EMPTY;
    private int interceptorPosition = 0;
    private InvocationContext invocationContext;

    public InterceptorContext() {
    }

    InterceptorContext(InterceptorContext interceptorContext) {
        super(interceptorContext, true);
        this.interceptors = interceptorContext.interceptors;
        this.interceptorPosition = interceptorContext.interceptorPosition;
    }

    InterceptorContext(AsynchronousInterceptorContext context) {
        super(context, false);
    }

    @Override
    public Object getTarget() {
        return super.getTarget();
    }

    @Override
    public void setTarget(Object target) {
        super.setTarget(target);
    }

    @Override
    public Method getMethod() {
        return super.getMethod();
    }

    @Override
    public void setMethod(Method method) {
        super.setMethod(method);
    }

    @Override
    public Constructor<?> getConstructor() {
        return super.getConstructor();
    }

    @Override
    public void setConstructor(Constructor<?> constructor) {
        super.setConstructor(constructor);
    }

    @Override
    public Object[] getParameters() {
        return super.getParameters();
    }

    @Override
    public void setParameters(Object[] parameters) {
        super.setParameters(parameters);
    }

    @Override
    public Map<String, Object> getContextData() throws IllegalStateException {
        return super.getContextData();
    }

    @Override
    public void setContextData(Map<String, Object> contextData) {
        super.setContextData(contextData);
    }

    @Override
    public Object getTimer() {
        return super.getTimer();
    }

    @Override
    public void setTimer(Object timer) {
        super.setTimer(timer);
    }

    public InvocationContext getInvocationContext() {
        if (this.invocationContext == null) {
            this.invocationContext = new Invocation();
        }
        return this.invocationContext;
    }

    @Override
    public <T> T getPrivateData(Class<T> type) {
        return super.getPrivateData(type);
    }

    @Override
    public Object getPrivateData(Object key) {
        return super.getPrivateData(key);
    }

    @Override
    public <T> T putPrivateData(Class<T> type, T value) {
        return super.putPrivateData(type, value);
    }

    @Override
    public Object putPrivateData(Object key, Object value) {
        return super.putPrivateData(key, value);
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public int getNextInterceptorIndex() {
        return this.interceptorPosition;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.setInterceptors(interceptors, 0);
    }

    public void setInterceptors(List<Interceptor> interceptorList) {
        this.setInterceptors(interceptorList.toArray(new Interceptor[interceptorList.size()]), 0);
    }

    public void setInterceptors(Interceptor[] interceptors, int nextIndex) {
        if (interceptors == null) {
            throw new IllegalArgumentException("interceptors is null");
        }
        this.interceptors = interceptors;
        this.interceptorPosition = nextIndex;
    }

    public void setInterceptors(List<Interceptor> interceptorList, int nextIndex) {
        this.setInterceptors(interceptorList.toArray(new Interceptor[interceptorList.size()]), nextIndex);
    }

    @Override
    public boolean isBlockingCaller() {
        return super.isBlockingCaller();
    }

    @Override
    public void setBlockingCaller(boolean blockingCaller) {
        super.setBlockingCaller(blockingCaller);
    }

    public Object proceed() throws Exception {
        if (this.interceptorPosition < this.interceptors.length) {
            Interceptor next = this.interceptors[this.interceptorPosition++];
            try {
                Object object = next.processInvocation(this);
                return object;
            }
            finally {
                --this.interceptorPosition;
            }
        }
        throw InvocationMessages.msg.cannotProceed();
    }

    @Override
    public Object run() throws Exception {
        return this.proceed();
    }

    public InterceptorContext clone() {
        return new InterceptorContext(this);
    }

    private class Invocation
    implements InvocationContext,
    PrivilegedExceptionAction<Object> {
        private Invocation() {
        }

        public Object getTarget() {
            return InterceptorContext.this.getTarget();
        }

        public Method getMethod() {
            return InterceptorContext.this.getMethod();
        }

        public Object[] getParameters() {
            Object[] parameters = InterceptorContext.this.getParameters();
            if (parameters == null) {
                throw new IllegalStateException("Cannot call InvocationContext.getParameters() in a lifecycle interceptor method");
            }
            return parameters;
        }

        public void setParameters(Object[] params) {
            Object[] parameters = InterceptorContext.this.getParameters();
            if (parameters == null) {
                throw new IllegalStateException("Cannot call InvocationContext.setParameters() in a lifecycle interceptor method");
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters must not be null");
            }
            Method method = InterceptorContext.this.getMethod();
            if (method != null) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (params.length != parameterTypes.length) {
                    throw new IllegalArgumentException("Number of parameters must match number of method arguments");
                }
                for (int i = 0; i < params.length; ++i) {
                    Class<?> wrappedType;
                    Object param = params[i];
                    Class<?> type = parameterTypes[i];
                    if (param == null) {
                        if (!type.isPrimitive()) continue;
                        throw new IllegalArgumentException("Null cannot be assigned to primitive parameter " + i + " (" + parameterTypes[i] + ")");
                    }
                    Class<?> clazz = wrappedType = type.isPrimitive() ? AbstractInterceptorContext.PRIMITIVES.get(type) : type;
                    if (wrappedType.isAssignableFrom(param.getClass())) continue;
                    throw new IllegalArgumentException("Parameter " + i + " (" + param + ") is not assignable to method parameter type " + parameterTypes[i]);
                }
            }
            InterceptorContext.this.setParameters(params);
        }

        public Map<String, Object> getContextData() {
            return InterceptorContext.this.getContextData();
        }

        public Object getTimer() {
            return InterceptorContext.this.getTimer();
        }

        public Object proceed() throws Exception {
            return InterceptorContext.this.proceed();
        }

        @Override
        public Object run() throws Exception {
            return InterceptorContext.this.proceed();
        }

        public Constructor<?> getConstructor() {
            return InterceptorContext.this.getConstructor();
        }
    }
}

