/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.invocation.AsynchronousInterceptor;
import org.jboss.invocation.AsynchronousInterceptorContext;

final class AsynchronousTask
extends AtomicReference<AsynchronousInterceptor.CancellationHandle>
implements Runnable,
AsynchronousInterceptor.CancellationHandle {
    static final Sentinel CANCEL_NORMAL = new Sentinel();
    static final Sentinel CANCEL_AGGRESSIVE = new Sentinel();
    private final AsynchronousInterceptorContext context;
    private final AsynchronousInterceptor.ResultHandler resultHandler;

    AsynchronousTask(AsynchronousInterceptorContext context, AsynchronousInterceptor.ResultHandler resultHandler) {
        this.context = context;
        this.resultHandler = resultHandler;
    }

    @Override
    public void run() {
        AsynchronousInterceptor.CancellationHandle oldVal = (AsynchronousInterceptor.CancellationHandle)this.get();
        if (oldVal == CANCEL_NORMAL || oldVal == CANCEL_AGGRESSIVE) {
            return;
        }
        if (oldVal != null) {
            return;
        }
        AsynchronousInterceptor.CancellationHandle newVal = this.context.proceed(this.resultHandler);
        while (!this.compareAndSet(oldVal, newVal)) {
            oldVal = (AsynchronousInterceptor.CancellationHandle)this.get();
            if (oldVal != CANCEL_NORMAL && oldVal != CANCEL_AGGRESSIVE) continue;
            newVal.cancel(oldVal == CANCEL_AGGRESSIVE);
            return;
        }
    }

    @Override
    public void cancel(boolean aggressiveCancelRequested) {
        Sentinel newVal;
        AsynchronousInterceptor.CancellationHandle oldVal = (AsynchronousInterceptor.CancellationHandle)this.get();
        if (oldVal != null) {
            if (oldVal == CANCEL_AGGRESSIVE) {
                return;
            }
            if (oldVal == CANCEL_NORMAL && aggressiveCancelRequested) {
                Sentinel newVal2 = CANCEL_AGGRESSIVE;
                while (!this.compareAndSet(oldVal, newVal2)) {
                    oldVal = (AsynchronousInterceptor.CancellationHandle)this.get();
                    if (oldVal != CANCEL_AGGRESSIVE) continue;
                    return;
                }
                return;
            }
            oldVal.cancel(aggressiveCancelRequested);
            return;
        }
        Sentinel sentinel = newVal = aggressiveCancelRequested ? CANCEL_AGGRESSIVE : CANCEL_NORMAL;
        while (!this.compareAndSet(null, newVal)) {
            oldVal = (AsynchronousInterceptor.CancellationHandle)this.get();
            if (oldVal == null) continue;
            oldVal.cancel(aggressiveCancelRequested);
            return;
        }
        this.resultHandler.setCancelled();
    }

    static final class Sentinel
    implements AsynchronousInterceptor.CancellationHandle {
        Sentinel() {
        }

        @Override
        public void cancel(boolean aggressiveCancelRequested) {
        }
    }
}

