/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;

class InvokingInterceptor
implements Interceptor,
Serializable {
    static final Interceptor INSTANCE = new InvokingInterceptor();
    static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory(INSTANCE);
    private static final long serialVersionUID = 175221411434392097L;

    InvokingInterceptor() {
    }

    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        Method method = context.getMethod();
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(context.getTarget(), context.getParameters());
        }
        catch (IllegalAccessException e) {
            IllegalAccessError n = new IllegalAccessError(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow(e.getCause());
        }
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "invoking interceptor";
    }
}

