/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.util.Collection;
import org.jboss.invocation.ChainedInterceptor;
import org.jboss.invocation.ChainedInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InvocationMessages;
import org.jboss.invocation.InvokingInterceptor;
import org.jboss.invocation.NullInterceptor;

public final class Interceptors {
    private Interceptors() {
    }

    public static Interceptor getNullInterceptor() {
        return NullInterceptor.INSTANCE;
    }

    public static InterceptorFactory getNullInterceptorFactory() {
        return NullInterceptor.FACTORY;
    }

    public static Interceptor getInvokingInterceptor() {
        return InvokingInterceptor.INSTANCE;
    }

    public static InterceptorFactory getInvokingInterceptorFactory() {
        return InvokingInterceptor.FACTORY;
    }

    public static Interceptor getChainedInterceptor(Interceptor ... instances) {
        return new ChainedInterceptor(instances);
    }

    public static Interceptor getChainedInterceptor(Collection<Interceptor> instances) {
        return new ChainedInterceptor(instances.toArray(new Interceptor[instances.size()]));
    }

    public static InterceptorFactory getChainedInterceptorFactory(InterceptorFactory ... instances) {
        return new ChainedInterceptorFactory(instances);
    }

    public static InterceptorFactory getChainedInterceptorFactory(Collection<InterceptorFactory> instances) {
        return new ChainedInterceptorFactory(instances.toArray(new InterceptorFactory[instances.size()]));
    }

    public static Exception rethrow(Throwable throwable) throws Error {
        try {
            throw throwable;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            return exception;
        }
        catch (Throwable throwable2) {
            return InvocationMessages.msg.undeclaredThrowable(throwable2);
        }
    }
}

