/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.security.ProtectionDomain;
import org.jboss.classfilewriter.ClassFile;

public abstract class AbstractClassFactory<T> {
    private final String className;
    private final Class<T> superClass;
    private final ClassLoader classLoader;
    private final ProtectionDomain protectionDomain;
    private volatile Class<? extends T> generatedClass;
    protected ClassFile classFile;

    protected AbstractClassFactory(String className, Class<T> superClass, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        this.className = className;
        this.superClass = superClass;
        this.classLoader = classLoader;
        this.protectionDomain = protectionDomain;
        this.classFile = new ClassFile(className, superClass.getName(), new String[0]);
    }

    protected AbstractClassFactory(String className, Class<T> superClass, ClassLoader classLoader) {
        this(className, superClass, classLoader, null);
    }

    protected AbstractClassFactory(String className, Class<T> superClass) {
        this(className, superClass, superClass.getClassLoader(), null);
    }

    protected abstract void generateClass();

    protected abstract void cleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends T> defineClass() {
        if (this.generatedClass == null) {
            AbstractClassFactory abstractClassFactory = this;
            synchronized (abstractClassFactory) {
                if (this.generatedClass == null) {
                    this.generateClass();
                    this.generatedClass = this.protectionDomain == null ? this.classFile.define(this.classLoader) : this.classFile.define(this.classLoader, this.protectionDomain);
                    this.cleanup();
                    this.classFile = null;
                }
            }
        }
        return this.generatedClass;
    }

    public T newInstance() throws InstantiationException, IllegalAccessException {
        return this.defineClass().newInstance();
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClass.getName();
    }

    public Class<T> getSuperClass() {
        return this.superClass;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }
}

