/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.processor;

import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.auto.service.AutoService;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jboss.gwt.circuit.ChangeSupport;
import org.jboss.gwt.circuit.Dispatcher;
import org.jboss.gwt.circuit.meta.Process;
import org.jboss.gwt.circuit.meta.Store;
import org.jboss.gwt.circuit.processor.GenerationException;
import org.jboss.gwt.circuit.processor.GenerationUtil;
import org.jboss.gwt.circuit.processor.GraphVizGenerator;
import org.jboss.gwt.circuit.processor.GraphVizInfo;
import org.jboss.gwt.circuit.processor.ProcessInfo;
import org.jboss.gwt.circuit.processor.StoreDelegateMetadata;
import org.jboss.gwt.circuit.processor.StoreGenerator;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

@SupportedOptions(value={"debug"})
@SupportedAnnotationTypes(value={"org.jboss.gwt.circuit.meta.Store"})
@AutoService(value=Processor.class)
public class StoreProcessor
extends AbstractProcessor {
    static final String GRAPH_VIZ_OUTPUT = "dependencies.gv";
    private final Map<String, GraphVizInfo> graphVizInfos = new HashMap<String, GraphVizInfo>();
    private final Map<String, Multimap<String, String>> dagValidation = new HashMap<String, Multimap<String, String>>();
    private final List<StoreDelegateMetadata> metadata = new ArrayList<StoreDelegateMetadata>();
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Store.class)) {
            TypeElement storeElement = (TypeElement)element;
            PackageElement packageElement = (PackageElement)storeElement.getEnclosingElement();
            String packageName = packageElement.getQualifiedName().toString();
            String storeDelegate = storeElement.getSimpleName().toString();
            boolean changeSupport = this.typeUtils.isAssignable(storeElement.asType(), this.elementUtils.getTypeElement(ChangeSupport.class.getName()).asType());
            String storeClassName = storeDelegate + "Adapter";
            this.debug("Discovered annotated store [%s]", storeElement.getQualifiedName());
            try {
                List<ExecutableElement> processMethods = this.findValidProcessMethods(storeElement);
                Collection<ProcessInfo> processInfos = this.createProcessInfos(storeElement, processMethods);
                this.validateProcessMethods(storeElement, processInfos);
                this.metadata.add(new StoreDelegateMetadata(packageName, storeClassName, storeDelegate, changeSupport, processInfos));
            }
            catch (GenerationException ge) {
                this.error(ge);
                return true;
            }
        }
        try {
            for (StoreDelegateMetadata storeDelegateMetadata : this.metadata) {
                this.debug("Generating code for [%s]", storeDelegateMetadata.storeClassName);
                StoreGenerator generator = new StoreGenerator();
                StringBuffer code = generator.generate(storeDelegateMetadata);
                this.writeCode(storeDelegateMetadata.packageName, storeDelegateMetadata.storeClassName, code);
                this.info("Successfully processed store [%s] -> [%s]", storeDelegateMetadata.storeDelegate, storeDelegateMetadata.storeClassName);
            }
            this.metadata.clear();
            if (roundEnv.processingOver()) {
                String graphVizFile = this.writeGraphViz();
                this.validateDAG(graphVizFile);
                this.graphVizInfos.clear();
                this.dagValidation.clear();
            }
        }
        catch (IOException ioe) {
            this.error("Error generating code: %s", ioe.getMessage());
        }
        return false;
    }

    private List<ExecutableElement> findValidProcessMethods(TypeElement storeElement) throws NoSuchElementException {
        NoType voidType = this.typeUtils.getNoType(TypeKind.VOID);
        List<ExecutableElement> allProcessMethods = GenerationUtil.getAnnotatedMethods(storeElement, this.processingEnv, Process.class.getName(), voidType, GenerationUtil.ANY_PARAMS);
        if (allProcessMethods.isEmpty()) {
            throw new GenerationException(storeElement, String.format("%s does not contain suitable methods annotated with %s.", storeElement.getQualifiedName(), Process.class.getName()));
        }
        return allProcessMethods;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<ProcessInfo> createProcessInfos(TypeElement storeElement, List<ExecutableElement> processMethods) {
        ArrayList<ProcessInfo> processInfos = new ArrayList<ProcessInfo>();
        String storeDelegate = storeElement.getSimpleName().toString();
        for (ExecutableElement methodElement : processMethods) {
            void var12_12;
            String actionType = null;
            Collection<Object> dependencies = Collections.emptyList();
            Optional processAnnotation = MoreElements.getAnnotationMirror((Element)methodElement, Process.class);
            if (processAnnotation.isPresent()) {
                Map<? extends ExecutableElement, ? extends AnnotationValue> values = this.elementUtils.getElementValuesWithDefaults((AnnotationMirror)processAnnotation.get());
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                    if ("actionType".equals(entry.getKey().getSimpleName().toString())) {
                        actionType = (String)((Set)GenerationUtil.extractValue(entry.getValue())).iterator().next();
                        continue;
                    }
                    if (!"dependencies".equals(entry.getKey().getSimpleName().toString())) continue;
                    dependencies = GenerationUtil.extractValue(entry.getValue());
                }
            }
            assert (actionType != null);
            ProcessInfo processInfo = new ProcessInfo(actionType, methodElement);
            processInfos.add(processInfo);
            for (String string : dependencies) {
                processInfo.addDependency(string + ".class");
            }
            List<? extends VariableElement> parameters = methodElement.getParameters();
            if (parameters.size() == 2) {
                this.verifyProcessParameter(storeElement, methodElement, parameters.get(0), actionType);
                this.verifyProcessParameter(storeElement, methodElement, parameters.get(1), Dispatcher.Channel.class.getCanonicalName());
            } else if (parameters.size() == 1) {
                this.verifyProcessParameter(storeElement, methodElement, parameters.get(0), Dispatcher.Channel.class.getCanonicalName());
            } else {
                throw new GenerationException(methodElement, String.format("Illegal number of arguments on method '%s' in class '%s'", methodElement.getSimpleName(), storeElement.getSimpleName()));
            }
            GraphVizInfo graphVizInfo = this.graphVizInfos.get(actionType);
            if (graphVizInfo == null) {
                String shortActionType = actionType.substring(actionType.lastIndexOf(46) + 1);
                GraphVizInfo graphVizInfo2 = new GraphVizInfo(shortActionType);
                this.graphVizInfos.put(actionType, graphVizInfo2);
            }
            var12_12.addStore(storeDelegate);
            LinkedList<String> simpleDependencies = new LinkedList<String>();
            for (String string : dependencies) {
                String simpleDependency = string.substring(string.lastIndexOf(46) + 1);
                simpleDependencies.add(simpleDependency);
                var12_12.addStore(simpleDependency);
                var12_12.addDependency(storeDelegate, simpleDependency);
            }
            HashMultimap dag = this.dagValidation.get(actionType);
            if (dag == null) {
                dag = HashMultimap.create();
                this.dagValidation.put(actionType, (Multimap<String, String>)dag);
            }
            dag.putAll((Object)storeDelegate, simpleDependencies);
        }
        return processInfos;
    }

    private void verifyProcessParameter(TypeElement storeElement, ExecutableElement methodElement, VariableElement parameter, String expected) {
        TypeElement parameterType = MoreTypes.asTypeElement((Types)this.typeUtils, (TypeMirror)parameter.asType());
        if (!parameterType.getQualifiedName().toString().equals(expected)) {
            throw new GenerationException(parameter, String.format("Illegal parameter '%s' on method '%s' in class '%s'. Expected type '%s'", parameter.getSimpleName(), methodElement.getSimpleName(), storeElement.getSimpleName(), expected));
        }
    }

    private void validateProcessMethods(TypeElement storeElement, Collection<ProcessInfo> processInfos) {
        HashMap<String, ProcessInfo> actionTypes = new HashMap<String, ProcessInfo>();
        for (ProcessInfo processInfo : processInfos) {
            ProcessInfo otherPi = (ProcessInfo)actionTypes.get(processInfo.getActionType());
            if (otherPi != null) {
                throw new GenerationException(processInfo.getMethodElement(), String.format("Ambiguous process method %s in store %s. This method uses the same action type as %s. Please make sure that the action type is unique across all process method in one store.", processInfo.getMethod(), storeElement.getSimpleName().toString(), otherPi.getMethod()));
            }
            actionTypes.put(processInfo.getActionType(), processInfo);
        }
    }

    private void validateDAG(String graphVizFile) {
        boolean cyclesFound = false;
        for (Map.Entry<String, Multimap<String, String>> entry : this.dagValidation.entrySet()) {
            String actionType = entry.getKey();
            Multimap<String, String> dependencies = entry.getValue();
            this.debug("Check cyclic dependencies for action [%s]", actionType);
            DefaultDirectedGraph dg = new DefaultDirectedGraph(DefaultEdge.class);
            for (String store : dependencies.keySet()) {
                dg.addVertex((Object)store);
            }
            for (String store : dependencies.values()) {
                dg.addVertex((Object)store);
            }
            for (String store : dependencies.keySet()) {
                Collection storeDependencies = dependencies.get((Object)store);
                for (String storeDependency : storeDependencies) {
                    dg.addEdge((Object)store, (Object)storeDependency);
                }
            }
            CycleDetector detector = new CycleDetector((DirectedGraph)dg);
            LinkedList cycles = new LinkedList(detector.findCycles());
            if (!cycles.isEmpty()) {
                cyclesFound = true;
                StringBuilder cycleInfo = new StringBuilder();
                for (String cycle : cycles) {
                    cycleInfo.append(cycle).append(" -> ");
                }
                cycleInfo.append((String)cycles.get(0));
                this.error("Cyclic dependencies detected for action [%s]: %s. Please review [%s] for more details.", actionType, cycleInfo, graphVizFile);
            }
            if (cyclesFound) continue;
            this.debug("No cyclic dependencies found for action [%s]", actionType);
        }
    }

    private void writeCode(String packageName, String className, StringBuffer code) throws IOException {
        JavaFileObject jfo = this.filer.createSourceFile(packageName + "." + className, new Element[0]);
        Writer w = jfo.openWriter();
        BufferedWriter bw = new BufferedWriter(w);
        bw.append(code);
        bw.close();
        w.close();
    }

    private String writeGraphViz() throws IOException {
        GraphVizGenerator generator = new GraphVizGenerator();
        StringBuffer code = generator.generate(this.graphVizInfos.values());
        this.debug("Generating GraphViz file to visualize store dependencies [%s]", GRAPH_VIZ_OUTPUT);
        FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", GRAPH_VIZ_OUTPUT, new Element[0]);
        Writer w = fo.openWriter();
        BufferedWriter bw = new BufferedWriter(w);
        bw.append(code);
        bw.close();
        w.close();
        this.debug("Successfully generated GraphViz file [%s]", GRAPH_VIZ_OUTPUT);
        return fo.getName();
    }

    private void debug(String msg, Object ... args) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
        }
    }

    private void info(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    private void error(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    private void error(GenerationException generationException) {
        if (generationException.getElement() != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, generationException.getMessage(), generationException.getElement());
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, generationException.getMessage());
        }
    }
}

