/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.processor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;

public class ProcessInfo {
    private final ExecutableElement methodElement;
    private final String actionType;
    private final String method;
    private final int params;
    private Set<String> dependencies;

    public ProcessInfo(String actionType, ExecutableElement method) {
        this.methodElement = method;
        this.actionType = actionType;
        this.method = method.getSimpleName().toString();
        this.params = method.getParameters().size();
        this.dependencies = new HashSet<String>();
    }

    public String getMethod() {
        return this.method;
    }

    public String getActionType() {
        return this.actionType;
    }

    public boolean isSingleArg() {
        return this.params == 1;
    }

    public void addDependency(String storeClassName) {
        this.dependencies.add(storeClassName);
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public String getDependencies() {
        StringBuilder csv = new StringBuilder();
        Iterator<String> iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            String dependency = iterator.next();
            csv.append(dependency);
            if (!iterator.hasNext()) continue;
            csv.append(", ");
        }
        return csv.toString();
    }

    ExecutableElement getMethodElement() {
        return this.methodElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessInfo)) {
            return false;
        }
        ProcessInfo that = (ProcessInfo)o;
        if (this.params != that.params) {
            return false;
        }
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (!this.actionType.equals(that.actionType)) {
            return false;
        }
        return this.dependencies.equals(that.dependencies);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.actionType.hashCode();
        result = 31 * result + this.params;
        result = 31 * result + this.dependencies.hashCode();
        return result;
    }
}

