/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class GenerationUtil {
    static final String[] ANY_PARAMS = new String[0];

    private GenerationUtil() {
    }

    static List<ExecutableElement> getAnnotatedMethods(TypeElement originalClassElement, ProcessingEnvironment processingEnvironment, String annotationName, TypeMirror requiredReturnType, String[] requiredParameterTypes) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeElement classElement = originalClassElement;
        while (true) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
            ArrayList<ExecutableElement> matches = new ArrayList<ExecutableElement>();
            for (ExecutableElement e : methods) {
                TypeMirror actualReturnType = e.getReturnType();
                if (GenerationUtil.getAnnotation(elementUtils, e, annotationName) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || !GenerationUtil.doParametersMatch(typeUtils, elementUtils, e, requiredParameterTypes) || e.getModifiers().contains((Object)Modifier.STATIC) || e.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                matches.add(e);
            }
            if (!matches.isEmpty()) {
                return matches;
            }
            TypeMirror superclass = classElement.getSuperclass();
            if (!(superclass instanceof DeclaredType)) break;
            classElement = (TypeElement)((DeclaredType)superclass).asElement();
        }
        return Collections.emptyList();
    }

    static AnnotationMirror getAnnotation(Elements elementUtils, Element annotationTarget, String annotationName) {
        for (AnnotationMirror annotationMirror : elementUtils.getAllAnnotationMirrors(annotationTarget)) {
            if (!annotationName.contentEquals(GenerationUtil.getQualifiedName(annotationMirror))) continue;
            return annotationMirror;
        }
        return null;
    }

    static Name getQualifiedName(AnnotationMirror annotation) {
        return ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName();
    }

    static boolean doParametersMatch(Types typeUtils, Elements elementUtils, ExecutableElement e, String[] requiredParameterTypes) {
        if (requiredParameterTypes == ANY_PARAMS) {
            return true;
        }
        if (e.getParameters().size() != requiredParameterTypes.length) {
            return false;
        }
        ArrayList<TypeMirror> requiredTypes = new ArrayList<TypeMirror>();
        for (String parameterType : requiredParameterTypes) {
            requiredTypes.add(elementUtils.getTypeElement(parameterType).asType());
        }
        for (int i = 0; i < requiredTypes.size(); ++i) {
            TypeMirror requiredType;
            TypeMirror actualType = e.getParameters().get(i).asType();
            if (typeUtils.isAssignable(actualType, requiredType = (TypeMirror)requiredTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    static Collection<String> extractValue(AnnotationValue value) {
        if (value.getValue() instanceof Collection) {
            List varray = (List)value.getValue();
            ArrayList<String> result = new ArrayList<String>(varray.size());
            for (Object active : varray) {
                result.addAll(GenerationUtil.extractValue((AnnotationValue)active));
            }
            return result;
        }
        return Collections.singleton(value.getValue().toString());
    }
}

