/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.processor;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jboss.gwt.circuit.processor.GenerationException;

abstract class AbstractGenerator {
    protected final Configuration config;

    protected AbstractGenerator() {
        Version version = new Version(2, 3, 23);
        this.config = new Configuration(version);
        this.config.setDefaultEncoding("UTF-8");
        this.config.setClassForTemplateLoading(this.getClass(), "templates");
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(version).build());
    }

    protected StringBuffer generate(Map<String, Object> context, String templateName) throws GenerationException {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = this.config.getTemplate(templateName);
            template.process(context, (Writer)bw);
        }
        catch (TemplateException | IOException ioe) {
            throw new GenerationException("Error generating template " + templateName + ": " + ioe.getMessage());
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException("Error generating template " + templateName + ": " + ioe.getMessage());
            }
        }
        return sw.getBuffer();
    }
}

