/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.processor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.gwt.circuit.ChangeSupport;
import org.jboss.gwt.circuit.Dispatcher;
import org.jboss.gwt.circuit.meta.Process;
import org.jboss.gwt.circuit.meta.Store;
import org.jboss.gwt.circuit.processor.AbstractErrorAbsorbingProcessor;
import org.jboss.gwt.circuit.processor.GenerationException;
import org.jboss.gwt.circuit.processor.GenerationUtil;
import org.jboss.gwt.circuit.processor.GraphVizGenerator;
import org.jboss.gwt.circuit.processor.GraphVizInfo;
import org.jboss.gwt.circuit.processor.ProcessInfo;
import org.jboss.gwt.circuit.processor.StoreDelegateMetadata;
import org.jboss.gwt.circuit.processor.StoreGenerator;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"org.jboss.gwt.circuit.meta.Store"})
public class StoreProcessor
extends AbstractErrorAbsorbingProcessor {
    static final String GRAPH_VIZ_OUTPUT = "dependencies.gv";
    private final Map<String, GraphVizInfo> graphVizInfos = new HashMap<String, GraphVizInfo>();
    private final Map<String, Multimap<String, String>> dagValidation = new HashMap<String, Multimap<String, String>>();
    private final List<StoreDelegateMetadata> metadata = new ArrayList<StoreDelegateMetadata>();

    @Override
    protected boolean processWithExceptions(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        if (roundEnv.errorRaised()) {
            return false;
        }
        if (!roundEnv.processingOver()) {
            this.collectData(roundEnv);
        } else {
            this.generateFiles();
        }
        return true;
    }

    private void collectData(RoundEnvironment roundEnv) throws Exception {
        Messager messager = this.processingEnv.getMessager();
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(Store.class)) {
            TypeElement storeElement = (TypeElement)element;
            PackageElement packageElement = (PackageElement)storeElement.getEnclosingElement();
            String packageName = packageElement.getQualifiedName().toString();
            String storeDelegate = storeElement.getSimpleName().toString();
            boolean changeSupport = typeUtils.isAssignable(storeElement.asType(), elementUtils.getTypeElement(ChangeSupport.class.getName()).asType());
            String storeClassName = GenerationUtil.storeImplementation(storeDelegate);
            messager.printMessage(Diagnostic.Kind.NOTE, String.format("Discovered annotated store [%s]", storeElement.getQualifiedName()));
            ArrayList<ExecutableElement> processMethods = new ArrayList<ExecutableElement>();
            if (this.findValidProcessMethods(messager, typeUtils, storeElement, processMethods)) {
                Collection<ProcessInfo> processInfos = this.createProcessInfos(messager, typeUtils, elementUtils, storeElement, processMethods);
                this.metadata.add(new StoreDelegateMetadata(packageName, storeClassName, storeDelegate, changeSupport, processInfos));
                continue;
            }
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not contain suitable methods annotated with %s.", storeElement.getQualifiedName(), Process.class.getName()));
            break;
        }
    }

    private boolean findValidProcessMethods(Messager messager, Types typeUtils, TypeElement storeElement, List<ExecutableElement> processMethods) {
        boolean valid = true;
        NoType voidType = typeUtils.getNoType(TypeKind.VOID);
        List<ExecutableElement> allProcessMethods = GenerationUtil.getAnnotatedMethods(storeElement, this.processingEnv, Process.class.getName(), voidType, GenerationUtil.ANY_PARAMS);
        if (allProcessMethods.isEmpty()) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("No process methods found in [%s]. Please use @%s to mark one or several methods as process methods.", storeElement.getQualifiedName(), Process.class.getName()));
            valid = false;
        }
        for (ExecutableElement processMethod : allProcessMethods) {
            processMethods.add(processMethod);
        }
        return valid;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<ProcessInfo> createProcessInfos(Messager messager, Types typeUtils, Elements elementUtils, TypeElement storeElement, List<ExecutableElement> processMethods) throws GenerationException {
        LinkedList<ProcessInfo> processInfos = new LinkedList<ProcessInfo>();
        String storeDelegate = storeElement.getSimpleName().toString();
        for (ExecutableElement methodElement : processMethods) {
            void var16_23;
            String actionType = Void.class.getCanonicalName();
            Collection<Object> dependencies = Collections.emptySet();
            AnnotationMirror processAnnotation = GenerationUtil.getAnnotation(elementUtils, methodElement, Process.class.getName());
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : processAnnotation.getElementValues().entrySet()) {
                if ("dependencies".equals(entry.getKey().getSimpleName().toString())) {
                    dependencies = GenerationUtil.extractValue(entry.getValue());
                    continue;
                }
                if (!"actionType".equals(entry.getKey().getSimpleName().toString())) continue;
                actionType = (String)((Set)GenerationUtil.extractValue(entry.getValue())).iterator().next();
            }
            TypeElement actionTypeElement = elementUtils.getTypeElement(actionType);
            ProcessInfo processInfo = new ProcessInfo(methodElement.getSimpleName().toString(), actionType);
            processInfos.add(processInfo);
            for (String string : dependencies) {
                processInfo.addDependency(string + ".class");
            }
            List<? extends VariableElement> parameters = methodElement.getParameters();
            if (parameters.size() == 1) {
                this.verifyDispatcherChannel(messager, typeUtils, storeElement, methodElement, parameters.get(0));
                continue;
            }
            if (parameters.size() > 1) {
                void var16_19;
                boolean bl = false;
                while (var16_19 < parameters.size()) {
                    if (var16_19 == parameters.size() - 1) {
                        this.verifyDispatcherChannel(messager, typeUtils, storeElement, methodElement, parameters.get((int)var16_19));
                    } else {
                        VariableElement parameter = parameters.get((int)var16_19);
                        String payloadName = parameter.getSimpleName().toString();
                        List<ExecutableElement> list = GenerationUtil.findGetter(actionTypeElement, this.processingEnv, parameter.asType(), payloadName);
                        if (list.isEmpty()) {
                            String error = String.format("No getter found for payload parameter '%s' on method '%s' in class '%s'", payloadName, methodElement.getSimpleName(), storeElement.getSimpleName());
                            messager.printMessage(Diagnostic.Kind.ERROR, error);
                        } else {
                            processInfo.addPayload(list.get(0).getSimpleName().toString());
                        }
                    }
                    ++var16_19;
                }
            } else {
                String string = String.format("No valid process method '%s' in class '%s'. Please provide at least a parameter of type '%s'", methodElement.getSimpleName(), storeElement.getSimpleName(), Dispatcher.Channel.class.getSimpleName());
                messager.printMessage(Diagnostic.Kind.ERROR, string);
                continue;
            }
            GraphVizInfo graphVizInfo = this.graphVizInfos.get(actionType);
            if (graphVizInfo == null) {
                String shortActionType = actionType.substring(actionType.lastIndexOf(46) + 1);
                GraphVizInfo graphVizInfo2 = new GraphVizInfo(shortActionType);
                this.graphVizInfos.put(actionType, graphVizInfo2);
            }
            var16_23.addStore(storeDelegate);
            LinkedList<String> simpleDependencies = new LinkedList<String>();
            for (String string : dependencies) {
                String simpleDependency = string.substring(string.lastIndexOf(46) + 1);
                simpleDependencies.add(simpleDependency);
                var16_23.addStore(simpleDependency);
                var16_23.addDependency(storeDelegate, simpleDependency);
            }
            HashMultimap dag = this.dagValidation.get(actionType);
            if (dag == null) {
                dag = HashMultimap.create();
                this.dagValidation.put(actionType, (Multimap<String, String>)dag);
            }
            dag.putAll((Object)storeDelegate, simpleDependencies);
        }
        return processInfos;
    }

    private void verifyDispatcherChannel(Messager messager, Types typeUtils, TypeElement storeElement, ExecutableElement methodElement, VariableElement param) {
        TypeElement paramType = (TypeElement)typeUtils.asElement(param.asType());
        if (!paramType.getQualifiedName().toString().equals(Dispatcher.Channel.class.getCanonicalName())) {
            String error = String.format("Illegal type for parameter '%s' on method '%s' in class '%s'. Expected type '%s'", param.getSimpleName(), methodElement.getSimpleName(), storeElement.getSimpleName(), Dispatcher.Channel.class.getCanonicalName());
            messager.printMessage(Diagnostic.Kind.ERROR, error);
        }
    }

    private void generateFiles() throws Exception {
        Messager messager = this.processingEnv.getMessager();
        for (StoreDelegateMetadata md : this.metadata) {
            try {
                messager.printMessage(Diagnostic.Kind.NOTE, String.format("Generating code for [%s]", md.storeClassName));
                StoreGenerator generator = new StoreGenerator();
                StringBuffer code = generator.generate(md);
                this.writeCode(md.packageName, md.storeClassName, code);
                messager.printMessage(Diagnostic.Kind.NOTE, String.format("Successfully generated store implementation [%s]", md.storeClassName));
            }
            catch (GenerationException ge) {
                String msg = ge.getMessage();
                messager.printMessage(Diagnostic.Kind.ERROR, msg);
            }
        }
        String graphVizFile = this.writeGraphViz();
        this.validateDAG(graphVizFile);
    }

    private String writeGraphViz() throws GenerationException, IOException {
        Messager messager = this.processingEnv.getMessager();
        GraphVizGenerator generator = new GraphVizGenerator();
        StringBuffer code = generator.generate(this.graphVizInfos.values());
        messager.printMessage(Diagnostic.Kind.NOTE, "Generating GraphViz file to visualize store dependencies [dependencies.gv]");
        FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", GRAPH_VIZ_OUTPUT, new Element[0]);
        Writer w = fo.openWriter();
        BufferedWriter bw = new BufferedWriter(w);
        bw.append(code);
        bw.close();
        w.close();
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated GraphViz file [dependencies.gv]");
        return fo.getName();
    }

    private void validateDAG(String graphVizFile) throws GenerationException {
        boolean cyclesFound = false;
        Messager messager = this.processingEnv.getMessager();
        for (Map.Entry<String, Multimap<String, String>> entry : this.dagValidation.entrySet()) {
            String payload = entry.getKey();
            Multimap<String, String> dependencies = entry.getValue();
            messager.printMessage(Diagnostic.Kind.NOTE, "Check cyclic dependencies for action [" + payload + "]");
            DefaultDirectedGraph dg = new DefaultDirectedGraph(DefaultEdge.class);
            for (String store : dependencies.keySet()) {
                dg.addVertex((Object)store);
            }
            for (String store : dependencies.values()) {
                dg.addVertex((Object)store);
            }
            for (String store : dependencies.keySet()) {
                Collection storeDependencies = dependencies.get((Object)store);
                for (String storeDependency : storeDependencies) {
                    dg.addEdge((Object)store, (Object)storeDependency);
                }
            }
            CycleDetector detector = new CycleDetector((DirectedGraph)dg);
            LinkedList cycles = new LinkedList(detector.findCycles());
            if (!cycles.isEmpty()) {
                cyclesFound = true;
                StringBuilder cycleInfo = new StringBuilder();
                for (String cycle : cycles) {
                    cycleInfo.append(cycle).append(" -> ");
                }
                cycleInfo.append((String)cycles.get(0));
                messager.printMessage(Diagnostic.Kind.ERROR, "Cyclic dependencies detected for action [" + payload + "]: " + cycleInfo);
                messager.printMessage(Diagnostic.Kind.ERROR, "Please review [" + graphVizFile + "] for more details.");
            }
            if (cyclesFound) continue;
            messager.printMessage(Diagnostic.Kind.NOTE, "No cyclic dependencies found for action [" + payload + "]");
        }
    }
}

