/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProcessInfo {
    private final String method;
    private final String actionType;
    private final List<String> payload;
    private Set<String> dependencies;

    public ProcessInfo(String method, String actionType) {
        this.method = method;
        this.actionType = actionType;
        this.payload = new ArrayList<String>();
        this.dependencies = new HashSet<String>();
    }

    public boolean isSingleArg() {
        return this.payload.isEmpty();
    }

    public String getMethod() {
        return this.method;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void addPayload(String name) {
        this.payload.add(name);
    }

    public List<String> getPayload() {
        return this.payload;
    }

    public void addDependency(String storeClassName) {
        this.dependencies.add(storeClassName);
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public String getDependencies() {
        StringBuilder csv = new StringBuilder();
        Iterator<String> iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            String dependency = iterator.next();
            csv.append(dependency);
            if (!iterator.hasNext()) continue;
            csv.append(", ");
        }
        return csv.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessInfo)) {
            return false;
        }
        ProcessInfo that = (ProcessInfo)o;
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.payload.equals(that.payload);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.payload.hashCode();
        return result;
    }
}

