/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gwt.circuit.processor;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jboss.gwt.circuit.processor.GenerationException;

abstract class AbstractGenerator {
    protected final Configuration config = new Configuration();

    protected AbstractGenerator() {
        this.config.setDefaultEncoding("UTF-8");
        this.config.setClassForTemplateLoading(this.getClass(), "templates");
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    protected StringBuffer generate(Map<String, Object> context, String templateName) throws GenerationException {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = this.config.getTemplate(templateName);
            template.process(context, (Writer)bw);
        }
        catch (TemplateException | IOException ioe) {
            throw new GenerationException(ioe);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        return sw.getBuffer();
    }
}

