/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster._shade.org.apache.commons.lang3.StringUtils;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.IProblem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.EnumDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.RecordDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.impl.AbstractJavaSource;
import org.jboss.forge.roaster.model.impl.ImportImpl;
import org.jboss.forge.roaster.model.impl.JavaDocImpl;
import org.jboss.forge.roaster.model.impl.SyntaxErrorImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.VisibilityScopedSource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jboss.forge.roaster.model.util.JDTOptions;
import org.jboss.forge.roaster.model.util.Types;
import org.jboss.forge.roaster.spi.WildcardImportResolver;

public abstract class JavaSourceImpl<O extends JavaSource<O>>
implements JavaSource<O> {
    private static List<WildcardImportResolver> resolvers;
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private final AnnotationAccessor<O, O> annotations = new AnnotationAccessor();
    protected final Document document;
    protected final CompilationUnit unit;
    protected final JavaSource<?> enclosingType;

    protected JavaSourceImpl(JavaSource<?> enclosingType, Document document, CompilationUnit unit) {
        this.enclosingType = enclosingType == null ? this : enclosingType;
        this.document = document;
        this.unit = unit;
    }

    public int getColumnNumber() {
        return this.unit.getColumnNumber(this.getStartPosition());
    }

    public int getLineNumber() {
        return this.unit.getLineNumber(this.getStartPosition());
    }

    public int getEndPosition() {
        int startPosition = this.getStartPosition();
        return startPosition == -1 ? -1 : startPosition + this.getDeclaration().getLength();
    }

    public int getStartPosition() {
        return this.getDeclaration().getStartPosition();
    }

    public boolean hasJavaDoc() {
        return this.getJDTJavaDoc() != null;
    }

    public JavaDocSource<O> getJavaDoc() {
        Javadoc javadoc = this.getJDTJavaDoc();
        if (javadoc == null) {
            javadoc = this.getDeclaration().getAST().newJavadoc();
            this.setJDTJavaDoc(javadoc);
        }
        return new JavaDocImpl<JavaSourceImpl>(this, javadoc);
    }

    public O removeJavaDoc() {
        this.setJDTJavaDoc(null);
        return (O)this;
    }

    protected abstract Javadoc getJDTJavaDoc();

    protected abstract void setJDTJavaDoc(Javadoc var1);

    public AnnotationSource<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, O>)this, this.getDeclaration());
    }

    public List<AnnotationSource<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<O, O>)this, this.getDeclaration());
    }

    public AnnotationSource<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, O>)this, this.getDeclaration(), clazz.getName());
    }

    public AnnotationSource<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, O>)this, this.getDeclaration(), className);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.getDeclaration(), type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.getDeclaration(), type);
    }

    public O removeAnnotation(Annotation<O> annotation) {
        return (O)this.annotations.removeAnnotation(this, this.getDeclaration(), annotation);
    }

    public void removeAllAnnotations() {
        this.annotations.removeAllAnnotations(this.getDeclaration());
    }

    public AnnotationSource<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, O>)this, this.getDeclaration(), (Class<java.lang.annotation.Annotation>)type);
    }

    public AnnotationSource<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, O>)this, this.getDeclaration(), type);
    }

    public Import addImport(Class<?> type) {
        return this.addImport(type.getCanonicalName());
    }

    public <T extends JavaType<?>> Import addImport(T type) {
        String qualifiedName = type.getQualifiedName();
        return this.addImport(qualifiedName);
    }

    public Import addImport(Import imprt) {
        return (Import)this.addImport(imprt.getQualifiedName()).setStatic(imprt.isStatic());
    }

    public Import addImport(String className) {
        String strippedClassName = Types.stripArray((String)className);
        if (Types.isGeneric((String)className)) {
            for (String genericPart : Types.splitGenerics((String)className)) {
                if (!Types.isQualified((String)genericPart)) continue;
                this.addImport(genericPart);
            }
        }
        if (!Types.isQualified((String)(strippedClassName = Types.stripGenerics((String)strippedClassName))) || Types.isJavaLang((String)strippedClassName)) {
            return null;
        }
        if (!this.hasImport(strippedClassName) && this.validImport(strippedClassName)) {
            Import imprt = new ImportImpl(this).setName(strippedClassName);
            this.unit.imports().add(imprt.getInternal());
            return imprt;
        }
        if (this.hasImport(strippedClassName)) {
            return this.getImport(strippedClassName);
        }
        return null;
    }

    public Import getImport(String className) {
        String strippedClassName = Types.stripArray((String)Types.stripGenerics((String)className));
        for (Import imprt : this.getImports()) {
            String qualifiedName = imprt.getQualifiedName();
            if (imprt.isWildcard()) {
                qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 2);
            }
            if (!qualifiedName.equals(strippedClassName)) continue;
            return imprt;
        }
        return null;
    }

    public Import addImport(Type<?> type) {
        Import imprt = this.requiresImport(type.getQualifiedName()) ? this.addImport(type.getQualifiedName()) : this.getImport(type.getQualifiedName());
        for (Type arg : type.getTypeArguments()) {
            if (arg.isWildcard() || !arg.isQualified()) continue;
            this.addImport(arg);
        }
        return imprt;
    }

    public Import getImport(Class<?> type) {
        return this.getImport(type.getName());
    }

    public <T extends JavaType<?>> Import getImport(T type) {
        return this.getImport(type.getQualifiedName());
    }

    public Import getImport(Import imprt) {
        return this.getImport(imprt.getQualifiedName());
    }

    public List<Import> getImports() {
        ArrayList<ImportImpl> results = new ArrayList<ImportImpl>();
        for (ImportDeclaration i : this.unit.imports()) {
            results.add(new ImportImpl(this, i));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasImport(Class<?> type) {
        return this.hasImport(type.getName());
    }

    public <T extends JavaType<T>> boolean hasImport(T type) {
        return this.hasImport(type.getQualifiedName());
    }

    public boolean hasImport(Import imprt) {
        return this.hasImport(imprt.getQualifiedName());
    }

    public boolean hasImport(String type) {
        String resultType = type;
        if (Types.isArray((String)type)) {
            resultType = Types.stripArray((String)type);
        }
        if (Types.isGeneric((String)type)) {
            resultType = Types.stripGenerics((String)type);
        }
        return this.getImport(resultType) != null;
    }

    public boolean requiresImport(Class<?> type) {
        return this.requiresImport(type.getName());
    }

    public boolean requiresImport(String type) {
        boolean requiresImport = false;
        String resultType = type;
        if (Types.isArray((String)resultType)) {
            resultType = Types.stripArray((String)resultType);
        }
        if (Types.isGeneric((String)resultType)) {
            for (String genericPart : Types.splitGenerics((String)resultType)) {
                requiresImport |= this.requiresImport(genericPart);
            }
            resultType = Types.stripGenerics((String)resultType);
        }
        return requiresImport |= this.validImport(resultType) && !this.hasImport(resultType) && !Types.isJavaLang((String)resultType) && !Objects.equals(this.getPackage(), Types.getPackage((String)resultType));
    }

    public String resolveType(String type) {
        String result = type;
        if (Types.isArray((String)result)) {
            result = Types.stripArray((String)result);
        }
        if (Types.isGeneric((String)result)) {
            result = Types.stripGenerics((String)result);
        }
        if (Types.isPrimitive((String)result)) {
            return result;
        }
        if (Types.isQualified((String)result)) {
            return result;
        }
        if (Types.isJavaLang((String)result)) {
            return "java.lang." + result;
        }
        List<Import> imports = this.getImports();
        for (Import imprt : imports) {
            if (!imprt.getSimpleName().equals(result)) continue;
            return imprt.getQualifiedName();
        }
        if (!imports.isEmpty()) {
            List wildcardImports = imports.stream().filter(Import::isWildcard).collect(Collectors.toList());
            if (wildcardImports.size() == 1) {
                return ((Import)wildcardImports.get(0)).getPackage() + "." + result;
            }
            for (Import imprt : imports) {
                if (!imprt.isWildcard()) continue;
                for (WildcardImportResolver r : this.getImportResolvers()) {
                    result = r.resolve((JavaType)this, result);
                    if (!Types.isQualified((String)result)) continue;
                    return result;
                }
            }
        }
        if (this.getPackage() != null) {
            return this.getPackage() + "." + result;
        }
        return result;
    }

    private List<WildcardImportResolver> getImportResolvers() {
        if (resolvers == null) {
            resolvers = new ArrayList<WildcardImportResolver>();
            for (WildcardImportResolver r : ServiceLoader.load(WildcardImportResolver.class, this.getClass().getClassLoader())) {
                resolvers.add(r);
            }
        }
        if (resolvers.isEmpty()) {
            throw new IllegalStateException("No instances of [" + WildcardImportResolver.class.getName() + "] were found on the classpath.");
        }
        return resolvers;
    }

    private boolean validImport(String type) {
        String className = Types.toSimpleName((String)type);
        if (className.equals(this.getName())) {
            return false;
        }
        for (Import imprt : this.getImports()) {
            String importClassName = imprt.getSimpleName();
            if (imprt.isWildcard() || !importClassName.equals(className)) continue;
            return false;
        }
        return !StringUtils.isEmpty(type) && !Types.isPrimitive((String)type) && !StringUtils.isEmpty(Types.getPackage((String)type));
    }

    public O removeImport(String name) {
        for (Import i : this.getImports()) {
            if (!i.getQualifiedName().equals(name)) continue;
            this.removeImport(i);
            break;
        }
        return (O)this;
    }

    public O removeImport(Class<?> clazz) {
        return this.removeImport((JavaType)clazz.getName());
    }

    public <T extends JavaType<?>> O removeImport(T type) {
        return this.removeImport((T)type.getQualifiedName());
    }

    public O removeImport(Import imprt) {
        Object internal = imprt.getInternal();
        if (this.unit.imports().contains(internal)) {
            this.unit.imports().remove(internal);
        }
        return (O)this;
    }

    public String getCanonicalName() {
        Object result = this.getName();
        for (JavaSourceImpl enclosingTypeLocal = this; enclosingTypeLocal != enclosingTypeLocal.getEnclosingType(); enclosingTypeLocal = enclosingTypeLocal.getEnclosingType()) {
            result = enclosingTypeLocal.getName() + "." + (String)result;
        }
        if (!StringUtils.isEmpty(this.getPackage())) {
            result = this.getPackage() + "." + (String)result;
        }
        return result;
    }

    protected abstract O updateTypeNames(String var1);

    public String getQualifiedName() {
        Object result = this.getName();
        for (JavaSourceImpl enclosingTypeLocal = this; enclosingTypeLocal != enclosingTypeLocal.getEnclosingType(); enclosingTypeLocal = enclosingTypeLocal.getEnclosingType()) {
            result = enclosingTypeLocal.getName() + "$" + (String)result;
        }
        if (!StringUtils.isEmpty(this.getPackage())) {
            result = this.getPackage() + "." + (String)result;
        }
        return result;
    }

    public String getPackage() {
        PackageDeclaration pkg = this.unit.getPackage();
        if (pkg != null) {
            return pkg.getName().getFullyQualifiedName();
        }
        return null;
    }

    public O setPackage(String name) {
        if (this.unit.getPackage() == null) {
            this.unit.setPackage(this.unit.getAST().newPackageDeclaration());
        }
        this.unit.getPackage().setName(this.unit.getAST().newName(name));
        return (O)this;
    }

    public O setDefaultPackage() {
        this.unit.setPackage(null);
        return (O)this;
    }

    public boolean isDefaultPackage() {
        return this.unit.getPackage() == null;
    }

    public String toString() {
        return Formatter.format(this.toUnformattedString());
    }

    public String toUnformattedString() {
        Document documentLocal = new Document(this.document.get());
        try {
            Map<String, String> options = JDTOptions.getJDTOptions();
            TextEdit edit = this.unit.rewrite(documentLocal, options);
            edit.apply(documentLocal);
        }
        catch (Exception e) {
            throw new ParserException("Could not modify source: " + this.unit.toString(), (Throwable)e);
        }
        return documentLocal.get();
    }

    public O setPackagePrivate() {
        this.modifiers.clearVisibility(this.getDeclaration());
        return (O)this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier(this.getDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public O setPublic() {
        this.modifiers.clearVisibility(this.getDeclaration());
        this.modifiers.addModifier(this.getDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return (O)this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier(this.getDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public O setPrivate() {
        this.modifiers.clearVisibility(this.getDeclaration());
        this.modifiers.addModifier(this.getDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return (O)this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier(this.getDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public O setProtected() {
        this.modifiers.clearVisibility(this.getDeclaration());
        this.modifiers.addModifier(this.getDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return (O)this;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public O setVisibility(Visibility scope) {
        return (O)((JavaSource)Visibility.set((VisibilityScopedSource)this, (Visibility)scope));
    }

    public boolean isClass() {
        ASTNode declaration = this.getDeclaration();
        return declaration instanceof TypeDeclaration && !((TypeDeclaration)declaration).isInterface();
    }

    public boolean isEnum() {
        ASTNode declaration = this.getDeclaration();
        return declaration instanceof EnumDeclaration;
    }

    public boolean isInterface() {
        ASTNode declaration = this.getDeclaration();
        return declaration instanceof TypeDeclaration && ((TypeDeclaration)declaration).isInterface();
    }

    public boolean isAnnotation() {
        return this.getDeclaration() instanceof AnnotationTypeDeclaration;
    }

    public boolean isRecord() {
        return this.getDeclaration() instanceof RecordDeclaration;
    }

    public JavaSource<?> getEnclosingType() {
        return this.enclosingType;
    }

    public int hashCode() {
        if (this.enclosingType == this) {
            return Objects.hash(this.document, this.unit);
        }
        return Objects.hash(this.document, this.enclosingType, this.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJavaSource other = (AbstractJavaSource)obj;
        if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
            return false;
        }
        if (this.enclosingType == null ? other.enclosingType != null : !this.enclosingType.equals((Object)other.enclosingType)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public Object getInternal() {
        return this.unit;
    }

    public O getOrigin() {
        return (O)this;
    }

    public List<SyntaxError> getSyntaxErrors() {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        IProblem[] problems = this.unit.getProblems();
        if (problems != null) {
            for (IProblem problem : problems) {
                result.add(new SyntaxErrorImpl((JavaType<?>)this, problem));
            }
        }
        return result;
    }

    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    protected abstract ASTNode getDeclaration();
}

