/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.apache.commons.lang3.StringUtils;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Name;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.ValuePair;
import org.jboss.forge.roaster.model.impl.Strings;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.impl.ValuePairImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Types;

public class AnnotationImpl<O extends JavaSource<O>, T>
implements AnnotationSource<O> {
    private static final String MISSING = "MISSING";
    private static final String DEFAULT_VALUE = "value";
    private AST ast;
    private org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation annotation;
    private AnnotationTargetSource<O, T> parent;

    public AnnotationImpl(AnnotationTargetSource<O, T> parent) {
        this(parent, AnnotationType.MARKER);
    }

    public AnnotationImpl(AnnotationTargetSource<O, T> parent, Object internal) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
        this.annotation = (org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation)Objects.requireNonNull(internal);
    }

    public AnnotationImpl(AnnotationTargetSource<O, T> parent, AnnotationType type) {
        this(parent, AnnotationImpl.createAnnotation(parent, type));
    }

    private static org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation createAnnotation(AnnotationTargetSource<?, ?> parent, AnnotationType type) {
        AST ast = ((ASTNode)parent.getInternal()).getAST();
        switch (type) {
            case MARKER: {
                return ast.newMarkerAnnotation();
            }
            case SINGLE: {
                return ast.newSingleMemberAnnotation();
            }
            case NORMAL: {
                return ast.newNormalAnnotation();
            }
        }
        throw new IllegalArgumentException("Unknown annotation type: " + type);
    }

    public String getName() {
        Name name = this.annotation.getTypeName();
        if (name.getFullyQualifiedName().equals(MISSING)) {
            return MISSING;
        }
        if (name.isSimpleName()) {
            return name.getFullyQualifiedName();
        }
        return Types.toSimpleName((String)name.getFullyQualifiedName());
    }

    public String getQualifiedName() {
        Name name = this.annotation.getTypeName();
        if (name.getFullyQualifiedName().equals(MISSING)) {
            return MISSING;
        }
        if (name.isSimpleName()) {
            return ((JavaSource)this.parent.getOrigin()).resolveType(name.getFullyQualifiedName());
        }
        return name.getFullyQualifiedName();
    }

    public String getLiteralValue() {
        if (this.isSingleValue()) {
            Expression value = ((SingleMemberAnnotation)this.annotation).getValue();
            if (value instanceof TypeLiteral) {
                return this.resolveTypeLiteralName((TypeLiteral)value);
            }
            return value.toString();
        }
        if (this.isNormal()) {
            for (ValuePair pair : this.getValues()) {
                if (!DEFAULT_VALUE.equals(pair.getName())) continue;
                return pair.getLiteralValue();
            }
        }
        return null;
    }

    public String getLiteralValue(String name) {
        if (DEFAULT_VALUE.equals(name) && this.isSingleValue()) {
            return this.getLiteralValue();
        }
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().getFullyQualifiedName().equals(name)) continue;
                Expression value = pair.getValue();
                if (value instanceof TypeLiteral) {
                    return this.resolveTypeLiteralName((TypeLiteral)value);
                }
                return value.toString();
            }
        }
        return null;
    }

    public List<ValuePair> getValues() {
        ArrayList<ValuePairImpl> result = new ArrayList<ValuePairImpl>();
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                if (!(v instanceof MemberValuePair)) continue;
                MemberValuePair pair = (MemberValuePair)v;
                ValuePairImpl temp = new ValuePairImpl(pair.getName().getFullyQualifiedName(), pair.getValue().toString());
                result.add(temp);
            }
        } else if (this.isSingleValue()) {
            result.add(new ValuePairImpl(DEFAULT_VALUE, this.getLiteralValue()));
        }
        return Collections.unmodifiableList(result);
    }

    public String getStringValue() throws IllegalStateException {
        return Strings.unquote(this.getLiteralValue());
    }

    public String getStringValue(String name) {
        return Strings.unquote(this.getLiteralValue(name));
    }

    public boolean isMarker() {
        return this.annotation.isMarkerAnnotation();
    }

    public boolean isNormal() {
        return this.annotation.isNormalAnnotation();
    }

    public boolean isSingleValue() {
        return this.annotation.isSingleMemberAnnotation();
    }

    public AnnotationSource<O> removeAllValues() {
        this.convertTo(AnnotationType.MARKER);
        return this;
    }

    public AnnotationSource<O> removeValue(String name) {
        if (this.annotation.isNormalAnnotation()) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)this.annotation;
            ArrayList<MemberValuePair> toRemove = new ArrayList<MemberValuePair>();
            for (Object annotationValue : normalAnnotation.values()) {
                MemberValuePair pair;
                if (!(annotationValue instanceof MemberValuePair) || !(pair = (MemberValuePair)annotationValue).getName().toString().equals(name)) continue;
                toRemove.add(pair);
            }
            normalAnnotation.values().removeAll(toRemove);
            if (this.getLiteralValue() != null && this.getValues().size() == 1) {
                this.convertTo(AnnotationType.SINGLE);
            } else if (this.getValues().size() == 0) {
                this.convertTo(AnnotationType.MARKER);
            }
        } else if (this.annotation.isSingleMemberAnnotation()) {
            this.removeAllValues();
        }
        return this;
    }

    public AnnotationSource<O> setName(String className) {
        this.annotation.setTypeName(this.ast.newName(className));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AnnotationSource<O> setLiteralValue(String value) {
        Objects.requireNonNull(value);
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue()) {
            String stub = "@" + this.getName() + "(" + value + ") public class Stub { }";
            JavaClass temp = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
            Object internal = ((Annotation)temp.getAnnotations().get(0)).getInternal();
            if (internal instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)this.annotation;
                Expression expression = ((SingleMemberAnnotation)internal).getValue();
                singleMemberAnnotation.setValue((Expression)ASTNode.copySubtree(this.ast, expression));
                return this;
            } else {
                if (!(internal instanceof NormalAnnotation)) throw new IllegalArgumentException("Type " + internal.getClass().getName() + " cannot be handled in this method");
                NormalAnnotation internalNormalAnnotation = (NormalAnnotation)internal;
                this.convertTo(AnnotationType.NORMAL);
                NormalAnnotation normalAnnotation = (NormalAnnotation)this.annotation;
                for (MemberValuePair pair : internalNormalAnnotation.values()) {
                    normalAnnotation.values().add(ASTNode.copySubtree(this.annotation.getAST(), pair));
                }
            }
            return this;
        } else {
            this.setLiteralValue(DEFAULT_VALUE, value);
        }
        return this;
    }

    public AnnotationSource<O> setLiteralValue(String name, String value) {
        Objects.requireNonNull(value);
        if (!this.isNormal() && !DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.NORMAL);
        } else if (!this.isSingleValue() && !this.isNormal() && DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            return this.setLiteralValue(value);
        }
        NormalAnnotation normalAnnotation = (NormalAnnotation)this.annotation;
        String stub = "@" + this.getName() + "(" + name + "=" + value + " ) public class Stub { }";
        JavaClass temp = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
        NormalAnnotation anno = (NormalAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
        MemberValuePair pair = (MemberValuePair)anno.values().get(0);
        List values = normalAnnotation.values();
        ListIterator<MemberValuePair> iter = values.listIterator();
        while (iter.hasNext()) {
            if (!((MemberValuePair)iter.next()).getName().getIdentifier().equals(name)) continue;
            iter.remove();
            break;
        }
        iter.add((MemberValuePair)ASTNode.copySubtree(this.annotation.getAST(), pair));
        return this;
    }

    public AnnotationSource<O> setStringValue(String value) {
        return this.setLiteralValue(Strings.enquote(value));
    }

    public AnnotationSource<O> setStringValue(String name, String value) {
        return this.setLiteralValue(name, Strings.enquote(value));
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type) {
        String literalValue = this.getLiteralValue();
        return this.convertLiteralToEnum(type, literalValue);
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type, String name) {
        String literalValue = this.getLiteralValue(name);
        return this.convertLiteralToEnum(type, literalValue);
    }

    private <E extends Enum<E>> E convertLiteralToEnum(Class<E> type, String literalValue) {
        Enum[] constants;
        for (Enum inst : constants = (Enum[])type.getEnumConstants()) {
            String[] tokens = literalValue.split("\\.");
            if (tokens.length > 1) {
                literalValue = tokens[tokens.length - 1];
            }
            if (!inst.name().equals(literalValue)) continue;
            return (E)inst;
        }
        return null;
    }

    public AnnotationSource<O> setEnumValue(String name, Enum<?> value) {
        return this.setEnumArrayValue(name, value);
    }

    public AnnotationSource<O> setEnumValue(Enum<?> ... values) {
        return this.setEnumArrayValue(values);
    }

    public AnnotationSource<O> setEnumArrayValue(Enum<?> ... values) {
        return this.setEnumArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setEnumArrayValue(String name, Enum<?> ... values) {
        ArrayList<String> literals = new ArrayList<String>();
        for (Enum<?> value : Objects.requireNonNull(values)) {
            Import imprt = this.getOrigin().addImport(Objects.requireNonNull(value).getDeclaringClass());
            if (imprt == null) {
                literals.add(value.getDeclaringClass().getCanonicalName() + "." + value.name());
                continue;
            }
            literals.add(value.getDeclaringClass().getSimpleName() + "." + value.name());
        }
        return this.setArrayLiteralValue(name, literals);
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public Object getInternal() {
        return this.annotation;
    }

    public String toString() {
        return this.annotation.toString();
    }

    protected void replace(org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation oldNode, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation newNode) {
        List modifiers;
        ASTNode parentNode = oldNode.getParent();
        if (parentNode instanceof BodyDeclaration) {
            modifiers = ((BodyDeclaration)parentNode).modifiers();
        } else if (parentNode instanceof SingleVariableDeclaration) {
            modifiers = ((SingleVariableDeclaration)parentNode).modifiers();
        } else {
            throw new IllegalStateException("Cannot handle annotations attached to " + parentNode);
        }
        int annotationIndex = modifiers.indexOf(this.annotation);
        if (annotationIndex >= 0) {
            modifiers.set(annotationIndex, newNode);
        }
    }

    private void convertTo(AnnotationType type) {
        if (this.isMarker() && type != AnnotationType.MARKER || this.isSingleValue() && type != AnnotationType.SINGLE || this.isNormal() && type != AnnotationType.NORMAL) {
            String value = this.getLiteralValue();
            AnnotationImpl<O, T> newAnnotation = new AnnotationImpl<O, T>(this.parent, type);
            if (this.getOrigin().getImport(this.getQualifiedName()) != null) {
                newAnnotation.setName(this.getName());
            } else {
                newAnnotation.setName(this.getQualifiedName());
            }
            this.replace(this.annotation, newAnnotation.annotation);
            this.annotation = newAnnotation.annotation;
            if (AnnotationType.MARKER != type && value != null) {
                this.setLiteralValue(value);
            }
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.annotation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationImpl)) {
            return false;
        }
        AnnotationImpl other = (AnnotationImpl)obj;
        return this.annotation.equals(other.annotation);
    }

    public AnnotationSource<O> setAnnotationValue() {
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue()) {
            Nested result = new Nested(this);
            ((SingleMemberAnnotation)this.annotation).setValue((Expression)result.getInternal());
            return result;
        }
        return this.setAnnotationValue(DEFAULT_VALUE);
    }

    public AnnotationSource<O> setAnnotationValue(String name) {
        if (!this.isNormal() && DEFAULT_VALUE.equals(name)) {
            return this.setAnnotationValue();
        }
        if (!this.isNormal()) {
            this.convertTo(AnnotationType.NORMAL);
        }
        Nested result = new Nested(this);
        String stub = "@" + this.getName() + "(" + name + "= 0 ) public class Stub { }";
        JavaClass temp = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
        NormalAnnotation anno = (NormalAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
        MemberValuePair pair = (MemberValuePair)anno.values().get(0);
        List values = ((NormalAnnotation)this.annotation).values();
        ListIterator<MemberValuePair> iter = values.listIterator();
        while (iter.hasNext()) {
            if (!((MemberValuePair)iter.next()).getName().getIdentifier().equals(name)) continue;
            iter.remove();
            break;
        }
        MemberValuePair mvpCopy = (MemberValuePair)ASTNode.copySubtree(this.annotation.getAST(), pair);
        mvpCopy.setValue((Expression)result.getInternal());
        iter.add(mvpCopy);
        return result;
    }

    public AnnotationSource<O> addAnnotationValue() {
        boolean bl;
        Expression expr;
        if (this.isNormal()) {
            return this.addAnnotationValue(DEFAULT_VALUE);
        }
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if ((expr = ((SingleMemberAnnotation)this.annotation).getValue()) instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
            ArrayInitializer arrayInit = this.ast.newArrayInitializer();
            bl = arrayInit.expressions().add(ASTNode.copySubtree(this.ast, expr));
            ((SingleMemberAnnotation)this.annotation).setValue(arrayInit);
            expr = arrayInit;
        }
        if (expr instanceof ArrayInitializer) {
            org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation arrayElement = AnnotationImpl.createAnnotation(this.parent, AnnotationType.MARKER);
            if (((ArrayInitializer)expr).expressions().isEmpty()) {
                ((SingleMemberAnnotation)this.annotation).setValue(arrayElement);
            } else {
                bl = ((ArrayInitializer)expr).expressions().add(arrayElement);
            }
            return new Nested(this, arrayElement);
        }
        return this.setAnnotationValue();
    }

    public AnnotationSource<O> addAnnotationValue(String name) {
        if (!this.isNormal()) {
            if (DEFAULT_VALUE.equals(name)) {
                return this.addAnnotationValue();
            }
            this.convertTo(AnnotationType.NORMAL);
        }
        MemberValuePair memberValuePair = null;
        for (Object value : ((NormalAnnotation)this.annotation).values()) {
            if (!(value instanceof MemberValuePair) || !Objects.equals(name, ((MemberValuePair)value).getName().getIdentifier())) continue;
            memberValuePair = (MemberValuePair)value;
            break;
        }
        if (memberValuePair != null) {
            boolean bl;
            Expression expr = memberValuePair.getValue();
            if (expr instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                ArrayInitializer arrayInit = this.ast.newArrayInitializer();
                bl = arrayInit.expressions().add(ASTNode.copySubtree(this.ast, expr));
                memberValuePair.setValue(arrayInit);
                expr = arrayInit;
            }
            if (expr instanceof ArrayInitializer) {
                org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation arrayElement = AnnotationImpl.createAnnotation(this.parent, AnnotationType.MARKER);
                if (((ArrayInitializer)expr).expressions().isEmpty()) {
                    memberValuePair.setValue(arrayElement);
                } else {
                    bl = ((ArrayInitializer)expr).expressions().add(arrayElement);
                }
                return new Nested(this, arrayElement);
            }
        }
        return this.setAnnotationValue(name);
    }

    public AnnotationSource<O> addAnnotationValue(Class<? extends java.lang.annotation.Annotation> type) {
        String typeToUse = this.getOrigin().addImport(type) != null ? type.getCanonicalName() : type.getSimpleName();
        return this.addAnnotationValue().setName(typeToUse);
    }

    public AnnotationSource<O> addAnnotationValue(String name, Class<? extends java.lang.annotation.Annotation> type) {
        String typeToUse = this.getOrigin().addImport(type) != null ? type.getCanonicalName() : type.getSimpleName();
        return this.addAnnotationValue(name).setName(typeToUse);
    }

    public AnnotationSource<O> removeAnnotationValue(Annotation<O> element) {
        Objects.requireNonNull(element, "Cannot remove null element");
        if (this.isSingleValue()) {
            ArrayInitializer arrayInit;
            if (element.getInternal().equals(((SingleMemberAnnotation)this.annotation).getValue())) {
                this.convertTo(AnnotationType.MARKER);
            } else if (((SingleMemberAnnotation)this.annotation).getValue() instanceof ArrayInitializer && (arrayInit = (ArrayInitializer)((SingleMemberAnnotation)this.annotation).getValue()).expressions().remove(element.getInternal())) {
                if (arrayInit.expressions().isEmpty()) {
                    this.convertTo(AnnotationType.MARKER);
                } else if (arrayInit.expressions().size() == 1) {
                    ((SingleMemberAnnotation)this.annotation).setValue((Expression)ASTNode.copySubtree(this.ast, (ASTNode)arrayInit.expressions().get(0)));
                }
            }
            return this;
        }
        return this.removeAnnotationValue(DEFAULT_VALUE, element);
    }

    public AnnotationSource<O> removeAnnotationValue(String name, Annotation<O> element) {
        Objects.requireNonNull(element, "Cannot remove null element");
        if (this.isSingleValue() && Objects.equals(name, DEFAULT_VALUE)) {
            return this.removeAnnotationValue(element);
        }
        if (this.isNormal()) {
            HashSet<String> identifiers = new HashSet<String>();
            Iterator values = ((NormalAnnotation)this.annotation).values().iterator();
            while (values.hasNext()) {
                Object value = values.next();
                if (!(value instanceof MemberValuePair)) continue;
                String identifier = ((MemberValuePair)value).getName().getIdentifier();
                identifiers.add(identifier);
                if (!Objects.equals(name, identifier)) continue;
                Expression expr = ((MemberValuePair)value).getValue();
                if (element.getInternal().equals(expr)) {
                    values.remove();
                    identifiers.remove(identifier);
                    continue;
                }
                if (!(expr instanceof ArrayInitializer)) continue;
                ArrayInitializer arrayInit = (ArrayInitializer)expr;
                arrayInit.expressions().remove(element.getInternal());
                if (arrayInit.expressions().isEmpty()) {
                    values.remove();
                    identifiers.remove(identifier);
                    continue;
                }
                if (arrayInit.expressions().size() != 1) continue;
                ((MemberValuePair)value).setValue((Expression)ASTNode.copySubtree(this.ast, (ASTNode)arrayInit.expressions().get(0)));
            }
            if (identifiers.isEmpty()) {
                this.convertTo(AnnotationType.MARKER);
            } else if (identifiers.equals(Collections.singleton(DEFAULT_VALUE))) {
                this.convertTo(AnnotationType.SINGLE);
            }
        }
        return this;
    }

    public AnnotationSource<O> getAnnotationValue() {
        if (this.isSingleValue()) {
            SingleMemberAnnotation single = (SingleMemberAnnotation)this.annotation;
            Expression value = single.getValue();
            if (value instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                return new Nested(this, value);
            }
            if (value instanceof ArrayInitializer && ((ArrayInitializer)value).expressions().size() == 1 && (value = (Expression)((ArrayInitializer)value).expressions().get(0)) instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                return new Nested(this, value);
            }
        }
        if (this.isNormal()) {
            return this.getAnnotationValue(DEFAULT_VALUE);
        }
        return null;
    }

    public AnnotationSource<O> getAnnotationValue(String name) {
        if (this.isNormal()) {
            NormalAnnotation normal = (NormalAnnotation)this.annotation;
            List values = normal.values();
            for (MemberValuePair memberValuePair : values) {
                if (!Objects.equals(name, memberValuePair.getName().getIdentifier())) continue;
                Expression value = memberValuePair.getValue();
                if (value instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                    return new Nested(this, value);
                }
                if (!(value instanceof ArrayInitializer) || ((ArrayInitializer)value).expressions().size() != 1 || !((value = (Expression)((ArrayInitializer)value).expressions().get(0)) instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation)) continue;
                return new Nested(this, value);
            }
        }
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            return this.getAnnotationValue();
        }
        return null;
    }

    public AnnotationSource<O>[] getAnnotationArrayValue() {
        return this.getAnnotationArrayValue(DEFAULT_VALUE);
    }

    public AnnotationSource<O>[] getAnnotationArrayValue(String name) {
        Object expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList<Nested> results = new ArrayList<Nested>();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression arrayElement : arrayElements) {
                results.add(new Nested(this, arrayElement));
            }
            return results.toArray(new AnnotationSource[results.size()]);
        }
        AnnotationSource<O> annotationValue = this.getAnnotationValue(name);
        if (annotationValue != null) {
            return new AnnotationSource[]{annotationValue};
        }
        return null;
    }

    public <E extends Enum<E>> E[] getEnumArrayValue(Class<E> type) {
        return this.getEnumArrayValue(type, DEFAULT_VALUE);
    }

    public <E extends Enum<E>> E[] getEnumArrayValue(Class<E> type, String name) {
        E instance;
        E expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList<E> results = new ArrayList<E>();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression arrayElement : arrayElements) {
                results.add(this.convertLiteralToEnum(type, arrayElement.toString()));
            }
            return results.toArray((Enum[])Array.newInstance(type, results.size()));
        }
        if (expr != null && type.isInstance(instance = this.convertLiteralToEnum(type, ((ASTNode)expr).toString()))) {
            Enum[] result = (Enum[])Array.newInstance(type, 1);
            result[0] = instance;
            return result;
        }
        return null;
    }

    public Class<?> getClassValue() {
        return this.getClassValue(DEFAULT_VALUE);
    }

    public Class<?> getClassValue(String name) {
        TypeLiteral typeLiteral = (TypeLiteral)this.getElementValueExpression(name);
        return this.resolveTypeLiteral(typeLiteral);
    }

    public Class<?>[] getClassArrayValue() {
        return this.getClassArrayValue(DEFAULT_VALUE);
    }

    public Class<?>[] getClassArrayValue(String name) {
        Object expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList result = new ArrayList();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression expression : arrayElements) {
                Class<?> type = this.resolveTypeLiteral((TypeLiteral)expression);
                result.add(type);
            }
            return result.toArray(new Class[result.size()]);
        }
        if (expr instanceof TypeLiteral) {
            return new Class[]{this.resolveTypeLiteral((TypeLiteral)expr)};
        }
        return null;
    }

    public String[] getStringArrayValue() {
        return this.getStringArrayValue(DEFAULT_VALUE);
    }

    public String[] getStringArrayValue(String name) {
        ArrayList<String> result = new ArrayList<String>();
        String literalValue = this.getLiteralValue(name);
        if (literalValue.startsWith("{") && literalValue.endsWith("}")) {
            literalValue = literalValue.substring(1, literalValue.length() - 1);
        }
        if (!StringUtils.isEmpty(literalValue)) {
            for (String value : literalValue.split(",")) {
                result.add(Strings.unquote(value));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public AnnotationSource<O> setClassValue(String name, Class<?> value) {
        this.getOrigin().addImport(value);
        return this.setLiteralValue(name, Types.toResolvedType((String)value.getCanonicalName(), this.getOrigin()) + ".class");
    }

    public AnnotationSource<O> setClassValue(Class<?> value) {
        return this.setClassValue(DEFAULT_VALUE, value);
    }

    public AnnotationSource<O> setClassArrayValue(Class<?> ... values) {
        return this.setClassArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setStringArrayValue(String[] values) {
        return this.setStringArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setStringArrayValue(String name, String[] values) {
        ArrayList<String> literals = new ArrayList<String>();
        for (String value : Objects.requireNonNull(values)) {
            literals.add(Strings.enquote(Objects.requireNonNull(value)));
        }
        return this.setArrayLiteralValue(name, literals);
    }

    public AnnotationSource<O> setClassArrayValue(String name, Class<?> ... values) {
        ArrayList<String> literals = new ArrayList<String>();
        for (Class<?> value : Objects.requireNonNull(values)) {
            this.getOrigin().addImport(value);
            literals.add(Types.toResolvedType((String)value.getCanonicalName(), this.getOrigin()) + ".class");
        }
        return this.setArrayLiteralValue(name, literals);
    }

    private AnnotationSource<O> setArrayLiteralValue(String name, List<String> literals) {
        String value = literals.size() == 1 ? literals.get(0) : String.format("{%s}", String.join((CharSequence)",", literals));
        return this.setLiteralValue(name, value);
    }

    private <E extends Expression> E getElementValueExpression(String name) {
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            return (E)((SingleMemberAnnotation)this.annotation).getValue();
        }
        if (this.isNormal()) {
            for (Object annotationValue : ((NormalAnnotation)this.annotation).values()) {
                MemberValuePair pair;
                if (!(annotationValue instanceof MemberValuePair) || !(pair = (MemberValuePair)annotationValue).getName().getFullyQualifiedName().equals(name)) continue;
                return (E)pair.getValue();
            }
        }
        return null;
    }

    private String resolveTypeLiteralName(TypeLiteral typeLiteral) {
        TypeImpl<O> type = new TypeImpl<O>(this.getOrigin(), typeLiteral.getType());
        if (Types.isPrimitive((String)type.getName())) {
            return type.getName();
        }
        return type.getQualifiedName();
    }

    private Class<?> resolveTypeLiteral(TypeLiteral typeLiteral) {
        TypeImpl<O> type = new TypeImpl<O>(this.getOrigin(), typeLiteral.getType());
        if (Types.isPrimitive((String)type.getName())) {
            return Types.toPrimitive((String)type.getName());
        }
        try {
            return Class.forName(type.getQualifiedName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean isTypeElementDefined(String name) {
        return this.getValues().stream().map(ValuePair::getName).anyMatch(Predicate.isEqual(name));
    }

    private static enum AnnotationType {
        MARKER,
        SINGLE,
        NORMAL;

    }

    private class Nested
    extends AnnotationImpl<O, T> {
        Nested(AnnotationImpl<O, T> owner) {
            super(owner.parent);
        }

        Nested(AnnotationImpl<O, T> owner, Object internal) {
            super(owner.parent, internal);
        }

        @Override
        protected void replace(org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation oldNode, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation newNode) {
            if (oldNode.getParent() instanceof SingleMemberAnnotation) {
                ((SingleMemberAnnotation)oldNode.getParent()).setValue(newNode);
            } else if (oldNode.getParent() instanceof MemberValuePair) {
                ((MemberValuePair)oldNode.getParent()).setValue(newNode);
            } else if (oldNode.getParent() instanceof ArrayInitializer) {
                List expressions = ((ArrayInitializer)oldNode.getParent()).expressions();
                expressions.set(expressions.indexOf(oldNode), newNode);
            }
        }
    }
}

