/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Name;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.PrimitiveType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.impl.AnnotationImpl;
import org.jboss.forge.roaster.model.impl.Strings;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.source.AnnotationElementSource;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;
import org.jboss.forge.roaster.model.util.Types;

public class AnnotationElementImpl
implements AnnotationElementSource {
    private final AnnotationAccessor<JavaAnnotationSource, AnnotationElementSource> annotations = new AnnotationAccessor();
    private final JavaAnnotationSource parent;
    private final AST ast;
    private final AnnotationTypeMemberDeclaration member;

    public AnnotationElementImpl(JavaAnnotationSource parent) {
        this(parent, ((ASTNode)parent.getInternal()).getAST().newAnnotationTypeMemberDeclaration());
    }

    public AnnotationElementImpl(JavaAnnotationSource parent, String declaration) {
        this(parent, AnnotationElementImpl.parseElement(parent, declaration));
    }

    public AnnotationElementImpl(JavaAnnotationSource parent, Object internal) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
        this.member = (AnnotationTypeMemberDeclaration)internal;
    }

    private static AnnotationTypeMemberDeclaration parseElement(JavaAnnotationSource parent, String declaration) {
        if (!((String)declaration).trim().endsWith(";")) {
            declaration = (String)declaration + ";";
        }
        String stub = "public @interface Stub { " + (String)declaration + " }";
        JavaAnnotationSource temp = (JavaAnnotationSource)Roaster.parse((String)stub);
        List fields = temp.getAnnotationElements();
        AnnotationTypeMemberDeclaration newField = (AnnotationTypeMemberDeclaration)((AnnotationElementSource)fields.get(0)).getInternal();
        return (AnnotationTypeMemberDeclaration)ASTNode.copySubtree(((ASTNode)parent.getInternal()).getAST(), newField);
    }

    public JavaAnnotationSource getOrigin() {
        return (JavaAnnotationSource)this.parent.getOrigin();
    }

    public Object getInternal() {
        return this.member;
    }

    public AnnotationSource<JavaAnnotationSource> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, this.member);
    }

    public AnnotationSource<JavaAnnotationSource> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, clazz.getSimpleName());
    }

    public AnnotationSource<JavaAnnotationSource> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, className);
    }

    public List<AnnotationSource<JavaAnnotationSource>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, this.member);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.member, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.member, type);
    }

    public AnnotationSource<JavaAnnotationSource> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, type);
    }

    public AnnotationSource<JavaAnnotationSource> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<JavaAnnotationSource, AnnotationElementSource>)this, (ASTNode)this.member, type);
    }

    public AnnotationElementSource removeAnnotation(Annotation<JavaAnnotationSource> annotation) {
        return this.annotations.removeAnnotation(this, this.member, annotation);
    }

    public void removeAllAnnotations() {
        this.annotations.removeAllAnnotations(this.member);
    }

    public String toString() {
        return this.member.toString();
    }

    public String getName() {
        return this.member.getName().toString();
    }

    public AnnotationElementSource setName(String name) {
        this.member.setName(this.ast.newSimpleName(name));
        return this;
    }

    public Type<JavaAnnotationSource> getType() {
        return new TypeImpl<JavaAnnotationSource>(this.parent, this.member.getStructuralProperty(AnnotationTypeMemberDeclaration.TYPE_PROPERTY));
    }

    public AnnotationElementSource setType(Class<?> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.setType(clazz.getSimpleName());
    }

    public AnnotationElementSource setType(JavaType<?> source) {
        return this.setType(source.getQualifiedName());
    }

    public AnnotationElementSource setType(String typeName) {
        String simpleName = Types.toSimpleName((String)typeName);
        JavaAnnotationSource origin = this.getOrigin();
        if (!Objects.equals(typeName, simpleName) && origin.requiresImport(typeName)) {
            origin.addImport(typeName);
        }
        PrimitiveType.Code primitive = PrimitiveType.toCode(typeName);
        org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type type = null;
        if (primitive != null) {
            type = this.ast.newPrimitiveType(primitive);
        } else if (!origin.requiresImport(typeName)) {
            if (Types.isArray((String)typeName)) {
                String arrayType = Types.stripArray((String)typeName);
                int arrayDimension = Types.getArrayDimension((String)typeName);
                type = Types.isPrimitive((String)arrayType) ? this.ast.newArrayType(this.ast.newPrimitiveType(PrimitiveType.toCode(arrayType)), arrayDimension) : this.ast.newArrayType(this.ast.newSimpleType(this.ast.newSimpleName(arrayType)), arrayDimension);
            } else {
                type = this.ast.newSimpleType(this.ast.newSimpleName(simpleName));
            }
        } else {
            String[] className = Types.tokenizeClassName((String)typeName);
            Name name = this.ast.newName(className);
            type = this.ast.newSimpleType(name);
        }
        this.member.setType(type);
        return this;
    }

    public AnnotationElementSource.DefaultValue getDefaultValue() {
        return new DefaultValueImpl();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.member == null ? 0 : this.member.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationElementImpl other = (AnnotationElementImpl)obj;
        return !(this.member == null ? other.member != null : !this.member.equals(other.member));
    }

    private class DefaultValueImpl
    implements AnnotationElementSource.DefaultValue {
        private DefaultValueImpl() {
        }

        public String getString() {
            return Strings.unquote(this.getLiteral());
        }

        public String getLiteral() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            return expr == null ? null : expr.toString();
        }

        public <E extends Enum<E>> E getEnum(Class<E> type) {
            return this.convertLiteralToEnum(type, this.getLiteral());
        }

        public AnnotationSource<JavaAnnotationSource> getAnnotation() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation) {
                return new AnnotationValue(AnnotationElementImpl.this.parent, expr);
            }
            return null;
        }

        public AnnotationElementSource.DefaultValue setLiteral(String value) {
            if (value == null) {
                AnnotationElementImpl.this.member.setDefault(null);
            } else {
                String stub = "public @interface Stub { String stub() default " + value + "; }";
                JavaAnnotationSource temp = (JavaAnnotationSource)Roaster.parse((String)stub);
                AnnotationTypeMemberDeclaration internal = (AnnotationTypeMemberDeclaration)((AnnotationElementSource)temp.getAnnotationElements().get(0)).getInternal();
                AnnotationElementImpl.this.member.setDefault((Expression)ASTNode.copySubtree(AnnotationElementImpl.this.ast, internal.getDefault()));
            }
            return this;
        }

        public AnnotationElementSource.DefaultValue setString(String value) {
            Objects.requireNonNull(value, "null not accepted");
            return this.setLiteral(Strings.enquote(value));
        }

        public <T extends Enum<T>> AnnotationElementSource.DefaultValue setEnum(T values) {
            return this.setEnumArray(new Enum[]{values});
        }

        public <T extends Enum<T>> AnnotationElementSource.DefaultValue setEnumArray(T ... values) {
            Objects.requireNonNull(values, "null array not accepted");
            ArrayList<CallSite> literals = new ArrayList<CallSite>();
            for (T value : values) {
                Objects.requireNonNull(value, "null value not accepted");
                AnnotationElementImpl.this.getOrigin().addImport(((Enum)value).getDeclaringClass());
                literals.add((CallSite)((Object)(((Enum)value).getDeclaringClass().getSimpleName() + "." + ((Enum)value).name())));
            }
            return this.setLiteral(literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", String.join((CharSequence)",", literals)));
        }

        public AnnotationSource<JavaAnnotationSource> setAnnotation() {
            AnnotationValue result = new AnnotationValue(AnnotationElementImpl.this.parent);
            AnnotationElementImpl.this.member.setDefault((Expression)result.getInternal());
            return result;
        }

        public <E extends Enum<E>> E[] getEnumArray(Class<E> type) {
            E instance;
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof ArrayInitializer) {
                ArrayList<E> results = new ArrayList<E>();
                List arrayElements = ((ArrayInitializer)expr).expressions();
                for (Expression arrayElement : arrayElements) {
                    results.add(this.convertLiteralToEnum(type, arrayElement.toString()));
                }
                Enum[] result = (Enum[])Array.newInstance(type, results.size());
                return results.toArray(result);
            }
            if (expr != null && type.isInstance(instance = this.convertLiteralToEnum(type, expr.toString()))) {
                Enum[] result = (Enum[])Array.newInstance(type, 1);
                result[0] = instance;
                return result;
            }
            return null;
        }

        public AnnotationElementSource.DefaultValue setSingleClass(Class<?> value) {
            return this.setClassArray(value);
        }

        public AnnotationElementSource.DefaultValue setClassArray(Class<?> ... values) {
            Objects.requireNonNull(values, "null array not accepted");
            ArrayList<CallSite> literals = new ArrayList<CallSite>();
            for (Class<?> value : values) {
                Objects.requireNonNull(value, "null value not accepted");
                if (!value.isPrimitive()) {
                    AnnotationElementImpl.this.getOrigin().addImport(value);
                }
                literals.add((CallSite)((Object)(value.getSimpleName() + ".class")));
            }
            return this.setLiteral(literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", String.join((CharSequence)",", literals)));
        }

        private <E extends Enum<E>> E convertLiteralToEnum(Class<E> type, String literalValue) {
            for (Enum inst : (Enum[])type.getEnumConstants()) {
                String[] tokens = literalValue.split("\\.");
                if (tokens.length > 1) {
                    literalValue = tokens[tokens.length - 1];
                }
                if (!inst.name().equals(literalValue)) continue;
                return (E)inst;
            }
            return null;
        }

        public Class<?> getSingleClass() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof TypeLiteral) {
                return this.resolveTypeLiteral((TypeLiteral)expr);
            }
            return null;
        }

        public Class<?>[] getClassArray() {
            Expression expr = AnnotationElementImpl.this.member.getDefault();
            if (expr instanceof ArrayInitializer) {
                ArrayList result = new ArrayList();
                List arrayElements = ((ArrayInitializer)expr).expressions();
                for (Expression arrayElement : arrayElements) {
                    result.add(this.resolveTypeLiteral((TypeLiteral)arrayElement));
                }
                return result.toArray(new Class[result.size()]);
            }
            if (expr instanceof TypeLiteral) {
                return new Class[]{this.resolveTypeLiteral((TypeLiteral)expr)};
            }
            return null;
        }

        private Class<?> resolveTypeLiteral(TypeLiteral typeLiteral) {
            TypeImpl<JavaAnnotationSource> type = new TypeImpl<JavaAnnotationSource>(AnnotationElementImpl.this.getOrigin(), typeLiteral.getType());
            if (type.isPrimitive()) {
                Class[] primitiveTypes;
                for (Class c : primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                    if (!c.getSimpleName().equals(type.getName())) continue;
                    return c;
                }
                return null;
            }
            String classname = type.getQualifiedName();
            try {
                return Class.forName(AnnotationElementImpl.this.getOrigin().resolveType(classname));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    private class AnnotationValue
    extends AnnotationImpl<JavaAnnotationSource, JavaAnnotationSource> {
        AnnotationValue(JavaAnnotationSource parent) {
            super(parent);
        }

        AnnotationValue(JavaAnnotationSource parent, Object internal) {
            super(parent, internal);
        }

        @Override
        protected void replace(org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation oldNode, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Annotation newNode) {
            AnnotationElementImpl.this.member.setDefault(newNode);
        }
    }
}

