/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.weaving;

import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleRevision;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.BundleLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.weaving.DynamicImportList;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.BundleInfo;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.StorageUtil;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.ManifestElement;
import org.jboss.forge.roaster._shade.org.osgi.framework.AdminPermission;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleException;
import org.jboss.forge.roaster._shade.org.osgi.framework.PackagePermission;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceRegistration;
import org.jboss.forge.roaster._shade.org.osgi.framework.hooks.weaving.WeavingException;
import org.jboss.forge.roaster._shade.org.osgi.framework.hooks.weaving.WeavingHook;
import org.jboss.forge.roaster._shade.org.osgi.framework.hooks.weaving.WovenClass;
import org.jboss.forge.roaster._shade.org.osgi.framework.hooks.weaving.WovenClassListener;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleWiring;

public final class WovenClassImpl
implements WovenClass,
HookContext<WeavingHook> {
    private static final byte FLAG_HOOKCALLED = 1;
    private static final byte FLAG_HOOKSCOMPLETE = 2;
    private static final byte FLAG_WEAVINGCOMPLETE = 4;
    private final String className;
    private final BundleEntry entry;
    private final List<String> dynamicImports;
    private final ClasspathEntry classpathEntry;
    private final BundleLoader loader;
    final ServiceRegistry registry;
    private final Map<ServiceRegistration<?>, Boolean> deniedHooks;
    private byte[] validBytes;
    private byte[] resultBytes;
    private byte hookFlags = 0;
    private Throwable error;
    private ServiceRegistration<?> errorHook;
    private Class<?> clazz;
    private int state;
    final EquinoxContainer container;

    public WovenClassImpl(String className, byte[] bytes, BundleEntry entry, ClasspathEntry classpathEntry, BundleLoader loader, EquinoxContainer container, Map<ServiceRegistration<?>, Boolean> deniedHooks) {
        this.className = className;
        this.resultBytes = bytes;
        this.validBytes = bytes;
        this.entry = entry;
        this.dynamicImports = new DynamicImportList(this);
        this.classpathEntry = classpathEntry;
        this.loader = loader;
        this.registry = container.getServiceRegistry();
        this.container = container;
        this.deniedHooks = deniedHooks;
        this.setState(1);
    }

    @Override
    public byte[] getBytes() {
        if ((this.hookFlags & 2) == 0) {
            this.checkPermission();
            return this.validBytes;
        }
        byte[] current = this.validBytes;
        byte[] results = new byte[current.length];
        System.arraycopy(current, 0, results, 0, current.length);
        return results;
    }

    @Override
    public void setBytes(byte[] newBytes) {
        this.checkPermission();
        if (newBytes == null) {
            throw new NullPointerException("newBytes cannot be null.");
        }
        if ((this.hookFlags & 2) != 0) {
            throw new IllegalStateException("Weaving has completed already.");
        }
        this.validBytes = newBytes;
        this.resultBytes = newBytes;
    }

    void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this.loader.getWiring().getBundle(), "weave"));
        }
    }

    @Override
    public List<String> getDynamicImports() {
        if ((this.hookFlags & 2) == 0) {
            return this.dynamicImports;
        }
        return Collections.unmodifiableList(this.dynamicImports);
    }

    @Override
    public boolean isWeavingComplete() {
        return (this.hookFlags & 4) != 0;
    }

    private void setHooksComplete() {
        byte[] original = this.validBytes;
        this.validBytes = new byte[original.length];
        System.arraycopy(original, 0, this.validBytes, 0, original.length);
        this.hookFlags = (byte)(this.hookFlags | 2);
    }

    void setWeavingCompleted(Class<?> clazz) {
        this.clazz = clazz;
        this.hookFlags = (byte)(this.hookFlags | 4);
        if ((this.hookFlags & 1) == 0) {
            return;
        }
        if (this.error != null) {
            return;
        }
        this.setState(clazz == null ? 16 : 4);
        this.notifyWovenClassListeners();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.classpathEntry.getDomain();
    }

    @Override
    public Class<?> getDefinedClass() {
        return this.clazz;
    }

    @Override
    public BundleWiring getBundleWiring() {
        return this.loader.getWiring();
    }

    @Override
    public void call(WeavingHook hook, ServiceRegistration<WeavingHook> hookRegistration) throws Exception {
        if (this.error != null) {
            return;
        }
        if (this.skipRegistration(hookRegistration)) {
            return;
        }
        if ((this.hookFlags & 1) == 0) {
            this.hookFlags = (byte)(this.hookFlags | 1);
            if (!this.validBytes(this.validBytes)) {
                this.validBytes = StorageUtil.getBytes(this.entry.getInputStream(), (int)this.entry.getSize(), 8192);
            }
        }
        try {
            hook.weave(this);
        }
        catch (WeavingException e) {
            this.error = e;
            this.errorHook = hookRegistration;
        }
        catch (Throwable t) {
            this.error = t;
            this.errorHook = hookRegistration;
            this.deniedHooks.put(hookRegistration, Boolean.TRUE);
        }
    }

    @Override
    public boolean skipRegistration(ServiceRegistration<?> hookRegistration) {
        return this.deniedHooks.containsKey(hookRegistration);
    }

    private boolean validBytes(byte[] checkBytes) {
        if (checkBytes == null || checkBytes.length < 4) {
            return false;
        }
        if ((checkBytes[0] & 0xCA) != 202) {
            return false;
        }
        if ((checkBytes[1] & 0xFE) != 254) {
            return false;
        }
        if ((checkBytes[2] & 0xBA) != 186) {
            return false;
        }
        return (checkBytes[3] & 0xBE) == 190;
    }

    private void notifyWovenClassListeners() {
        HookContext<WovenClassListener> context = (hook, hookRegistration) -> {
            try {
                hook.modified(this);
            }
            catch (Exception e) {
                this.container.getEventPublisher().publishFrameworkEvent(2, hookRegistration.getReference().getBundle(), e);
            }
        };
        if (System.getSecurityManager() == null) {
            this.registry.notifyHooksPrivileged(WovenClassListener.class, "modified", context);
        } else {
            try {
                AccessController.doPrivileged(() -> {
                    this.registry.notifyHooksPrivileged(WovenClassListener.class, "modified", context);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw (RuntimeException)e.getException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    byte[] callHooks() throws Throwable {
        block14: {
            sm = System.getSecurityManager();
            wovenBytes = null;
            newImports = null;
            rejected = false;
            try {
                if (sm == null) {
                    this.registry.notifyHooksPrivileged(WeavingHook.class, "weave", this);
                }
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction<Void>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$2(), ()Ljava/lang/Void;)((WovenClassImpl)this));
                }
                catch (PrivilegedActionException e) {
                    throw (RuntimeException)e.getException();
                }
            }
            finally {
                if ((this.hookFlags & 1) == 0) break block14;
                ** for (classLoaderHook : this.container.getConfiguration().getHookRegistry().getClassLoaderHooks())
            }
lbl-1000:
            // 1 sources

            {
                rejected |= classLoaderHook.rejectTransformation(this.className, this.resultBytes, this.classpathEntry, this.entry, this.loader.getModuleClassLoader().getClasspathManager());
                continue;
            }
lbl20:
            // 1 sources

            if (!rejected) {
                wovenBytes = this.resultBytes;
                newImports = this.dynamicImports;
            }
            this.setHooksComplete();
            this.setState(this.error == null ? 2 : 8);
            if (!rejected) {
                this.notifyWovenClassListeners();
            }
        }
        if (this.error != null) {
            throw this.error;
        }
        if (newImports != null) {
            for (String newImport : newImports) {
                try {
                    importElements = ManifestElement.parseHeader("Import-Package", newImport);
                    this.addImpliedImportPackagePermissions(importElements);
                    this.loader.addDynamicImportPackage(importElements);
                }
                catch (BundleException v0) {}
            }
        }
        return wovenBytes;
    }

    private void addImpliedImportPackagePermissions(ManifestElement[] importElements) {
        ProtectionDomain wovenDomain = ((BundleInfo.Generation)((ModuleRevision)this.getBundleWiring().getRevision()).getRevisionInfo()).getDomain();
        if (wovenDomain != null) {
            ManifestElement[] manifestElementArray = importElements;
            int n = importElements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement clause = manifestElementArray[n2];
                String[] stringArray = clause.getValueComponents();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String pkg = stringArray[n4];
                    ((BundlePermissions)wovenDomain.getPermissions()).addWovenPermission(new PackagePermission(pkg, "import"));
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public String toString() {
        return this.className;
    }

    public ServiceRegistration<?> getErrorHook() {
        return this.errorHook;
    }

    @Override
    public int getState() {
        return this.state;
    }

    private void setState(int value) {
        this.state = value;
    }

    private /* synthetic */ Void lambda$2() throws Exception {
        this.registry.notifyHooksPrivileged(WeavingHook.class, "weave", this);
        return null;
    }
}

