/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.signedcontent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFile;

public final class BundleToJarInputStream
extends InputStream {
    private final BundleFile bundlefile;
    private final Iterator<String> entryPaths;
    private final JarOutputStream jarOutput;
    private final ByteArrayOutputStream nextEntryOutput = new ByteArrayOutputStream();
    private ByteArrayInputStream nextEntryInput = null;

    public BundleToJarInputStream(BundleFile bundleFile) throws IOException {
        this.bundlefile = bundleFile;
        ArrayList<String> entries = new ArrayList<String>();
        int signatureFileCnt = 0;
        Enumeration<String> ePaths = bundleFile.getEntryPaths("", true);
        while (ePaths.hasMoreElements()) {
            String entry = ePaths.nextElement();
            if (entry.equals("META-INF/MANIFEST.MF")) {
                entries.add(0, entry);
                ++signatureFileCnt;
                continue;
            }
            if (this.isSignatureFile(entry)) {
                entries.add(signatureFileCnt++, entry);
                continue;
            }
            entries.add(entry);
        }
        this.entryPaths = entries.iterator();
        this.jarOutput = new JarOutputStream(this.nextEntryOutput);
    }

    private boolean isSignatureFile(String entry) {
        if ((entry = entry.toUpperCase()).startsWith("META-INF/") && entry.indexOf(47, "META-INF/".length()) == -1) {
            return entry.endsWith(".SF") || entry.endsWith(".DSA") || entry.endsWith(".RSA") || entry.endsWith(".EC");
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.nextEntryInput != null) {
            int result = this.nextEntryInput.read();
            if (result != -1) {
                return result;
            }
            this.nextEntryInput = null;
            return this.read();
        }
        if (this.entryPaths.hasNext()) {
            this.readNext(this.entryPaths.next());
            if (!this.entryPaths.hasNext()) {
                this.jarOutput.close();
            }
        } else {
            this.jarOutput.close();
            return -1;
        }
        return this.read();
    }

    private void readNext(String path) throws IOException {
        BundleEntry found = this.bundlefile.getEntry(path);
        if (found == null) {
            throw new IOException("No entry found: " + path);
        }
        this.nextEntryOutput.reset();
        JarEntry entry = new JarEntry(path);
        this.jarOutput.putNextEntry(entry);
        if (!entry.isDirectory()) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream source = found.getInputStream();){
                int length;
                byte[] buf = new byte[8192];
                while ((length = source.read(buf)) > 0) {
                    this.jarOutput.write(buf, 0, length);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.jarOutput.closeEntry();
        this.jarOutput.flush();
        this.nextEntryInput = new ByteArrayInputStream(this.nextEntryOutput.toByteArray());
    }
}

