/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.permadmin;

import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.permadmin.PermissionsHash;
import org.jboss.forge.roaster._shade.org.osgi.service.permissionadmin.PermissionInfo;

public final class PermissionInfoCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3140511562980923957L;
    private static final Class<?>[] twoStringClassArray = new Class[]{String.class, String.class};
    private static final Class<?>[] oneStringClassArray = new Class[]{String.class};
    private static final Class<?>[] noArgClassArray = new Class[0];
    private static final Class<?>[][] permClassArrayArgs = new Class[][]{noArgClassArray, oneStringClassArray, twoStringClassArray};
    private static final String ALL_PERMISSION_NAME = AllPermission.class.getName();
    static final String FILE_PERMISSION_NAME = FilePermission.class.getName();
    static final String ALL_FILES = "<<ALL FILES>>";
    private final Map<Class<? extends Permission>, PermissionCollection> cachedPermissionCollections = new HashMap<Class<? extends Permission>, PermissionCollection>();
    private final Map<BundlePermissions, PermissionCollection> cachedRelativeFilePermissionCollections;
    private final boolean hasAllPermission;
    private final PermissionInfo[] permInfos;

    public PermissionInfoCollection(PermissionInfo[] permInfos) {
        this.permInfos = permInfos;
        boolean tempAllPermissions = false;
        boolean allAbsolutePaths = true;
        PermissionInfo[] permissionInfoArray = permInfos;
        int n = permInfos.length;
        int n2 = 0;
        while (n2 < n) {
            PermissionInfo info = permissionInfoArray[n2];
            if (ALL_PERMISSION_NAME.equals(info.getType())) {
                tempAllPermissions = true;
            } else if (FILE_PERMISSION_NAME.equals(info.getType()) && !new File(info.getActions()).isAbsolute()) {
                allAbsolutePaths = false;
            }
            ++n2;
        }
        this.hasAllPermission = tempAllPermissions;
        this.cachedRelativeFilePermissionCollections = allAbsolutePaths ? null : new HashMap();
        this.setReadOnly();
    }

    @Override
    public void add(Permission arg0) {
        throw new SecurityException();
    }

    @Override
    public Enumeration<Permission> elements() {
        return BundlePermissions.EMPTY_ENUMERATION;
    }

    @Override
    public boolean implies(Permission perm) {
        return this.implies(null, perm);
    }

    boolean implies(BundlePermissions bundlePermissions, Permission perm) {
        if (this.hasAllPermission) {
            return true;
        }
        Class<?> permClass = perm.getClass();
        PermissionCollection collection = this.getCachedCollection(bundlePermissions, permClass);
        if (collection == null) {
            collection = perm.newPermissionCollection();
            if (collection == null) {
                collection = new PermissionsHash();
            }
            try {
                PermissionCollection targetCollection = collection;
                AccessController.doPrivileged(() -> {
                    this.addPermissions(bundlePermissions, targetCollection, permClass);
                    return null;
                });
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                throw new SecurityException("Exception creating permissions: " + permClass + ": " + e.getMessage(), e);
            }
            collection = this.cacheCollection(bundlePermissions, permClass, collection);
        }
        return collection.implies(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PermissionCollection getCachedCollection(BundlePermissions bundlePermissions, Class<? extends Permission> permClass) {
        Map<Class<? extends Permission>, PermissionCollection> map = this.cachedPermissionCollections;
        synchronized (map) {
            if (bundlePermissions != null && this.cachedRelativeFilePermissionCollections != null && FILE_PERMISSION_NAME.equals(permClass.getName())) {
                return this.cachedRelativeFilePermissionCollections.get(bundlePermissions);
            }
            return this.cachedPermissionCollections.get(permClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection cacheCollection(BundlePermissions bundlePermissions, Class<? extends Permission> permClass, PermissionCollection collection) {
        Map<Class<? extends Permission>, PermissionCollection> map = this.cachedPermissionCollections;
        synchronized (map) {
            PermissionCollection exists;
            boolean relativeFiles = bundlePermissions != null && this.cachedRelativeFilePermissionCollections != null && FILE_PERMISSION_NAME.equals(permClass.getName());
            PermissionCollection permissionCollection = exists = relativeFiles ? this.cachedRelativeFilePermissionCollections.get(bundlePermissions) : this.cachedPermissionCollections.get(permClass);
            if (exists != null) {
                collection = exists;
            } else if (relativeFiles) {
                this.cachedRelativeFilePermissionCollections.put(bundlePermissions, collection);
            } else {
                this.cachedPermissionCollections.put(permClass, collection);
            }
            return collection;
        }
    }

    PermissionInfo[] getPermissionInfos() {
        return this.permInfos;
    }

    void addPermissions(BundlePermissions bundlePermissions, PermissionCollection collection, Class<? extends Permission> permClass) throws Exception {
        String permClassName = permClass.getName();
        Constructor<? extends Permission> constructor = null;
        int numArgs = -1;
        int i = permClassArrayArgs.length - 1;
        while (i >= 0) {
            try {
                constructor = permClass.getConstructor(permClassArrayArgs[i]);
                numArgs = i;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                --i;
            }
        }
        if (constructor == null) {
            throw new NoSuchMethodException(String.valueOf(permClass.getName()) + ".<init>()");
        }
        PermissionInfo[] permissionInfoArray = this.permInfos;
        int n = this.permInfos.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Object[] args;
                block11: {
                    File target;
                    File file;
                    PermissionInfo permInfo = permissionInfoArray[n2];
                    if (!permInfo.getType().equals(permClassName)) break block10;
                    args = new String[numArgs];
                    if (numArgs > 0) {
                        args[0] = permInfo.getName();
                    }
                    if (numArgs > 1) {
                        args[1] = permInfo.getActions();
                    }
                    if (!permInfo.getType().equals(FILE_PERMISSION_NAME) || args[0].equals(ALL_FILES) || (file = new File((String)args[0])).isAbsolute()) break block11;
                    File file2 = target = bundlePermissions == null ? null : bundlePermissions.getBundle().getDataFile(permInfo.getName());
                    if (target == null) break block10;
                    args[0] = target.getPath();
                }
                collection.add(constructor.newInstance(args));
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearPermissionCache() {
        Map<Class<? extends Permission>, PermissionCollection> map = this.cachedPermissionCollections;
        synchronized (map) {
            this.cachedPermissionCollections.clear();
            if (this.cachedRelativeFilePermissionCollections != null) {
                this.cachedRelativeFilePermissionCollections.clear();
            }
        }
    }
}

