/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.SynchronousLogListener;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceReference;
import org.jboss.forge.roaster._shade.org.osgi.service.log.LogEntry;

public class EventAdminLogListener
implements SynchronousLogListener {
    public static final String TOPIC = "org/jboss/forge/roaster/_shade/org/osgi/service/log/LogEntry";
    public static final char TOPIC_SEPARATOR = '/';
    public static final String LOG_ERROR = "LOG_ERROR";
    public static final String LOG_WARNING = "LOG_WARNING";
    public static final String LOG_INFO = "LOG_INFO";
    public static final String LOG_DEBUG = "LOG_DEBUG";
    public static final String LOG_OTHER = "LOG_OTHER";
    public static final String TIMESTAMP = "timestamp";
    public static final String MESSAGE = "message";
    public static final String LOG_LEVEL = "log.level";
    public static final String LOG_ENTRY = "log.entry";
    public static final String SERVICE = "service";
    public static final String SERVICE_ID = "service.id";
    public static final String SERVICE_OBJECTCLASS = "service.objectClass";
    public static final String SERVICE_PID = "service.pid";
    public static final String BUNDLE = "bundle";
    public static final String BUNDLE_ID = "bundle.id";
    public static final String BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    public static final String EVENT = "event";
    public static final String EXCEPTION = "exception";
    public static final String EXCEPTION_CLASS = "exception.class";
    public static final String EXCEPTION_MESSAGE = "exception.message";
    final Object eventAdmin;
    final Method postEvent;
    private final Constructor<?> event;

    public EventAdminLogListener(Object eventAdmin) throws ClassNotFoundException, NoSuchMethodException {
        this.eventAdmin = eventAdmin;
        Class<?> eventAdminClass = eventAdmin.getClass();
        ClassLoader cl = eventAdminClass.getClassLoader();
        Class<?> eventClass = cl.loadClass("org.jboss.forge.roaster._shade.org.osgi.service.event.Event");
        this.postEvent = eventAdminClass.getMethod("postEvent", eventClass);
        this.event = eventClass.getConstructor(String.class, Dictionary.class);
    }

    @Override
    public void logged(LogEntry entry) {
        try {
            AccessController.doPrivileged(() -> {
                Object convertedEvent = this.convertEvent(entry);
                this.postEvent.invoke(this.eventAdmin, convertedEvent);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)cause).getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            throw new RuntimeException(cause);
        }
    }

    Object convertEvent(LogEntry entry) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ServiceReference<?> ref;
        String topic = TOPIC;
        int level = entry.getLevel();
        switch (level) {
            case 1: {
                topic = String.valueOf(topic) + "/LOG_ERROR";
                break;
            }
            case 2: {
                topic = String.valueOf(topic) + "/LOG_WARNING";
                break;
            }
            case 3: {
                topic = String.valueOf(topic) + "/LOG_INFO";
                break;
            }
            case 4: {
                topic = String.valueOf(topic) + "/LOG_DEBUG";
                break;
            }
            default: {
                topic = String.valueOf(topic) + "/LOG_OTHER";
            }
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Bundle bundle = entry.getBundle();
        if (bundle == null) {
            throw new RuntimeException("LogEntry.getBundle() returns null");
        }
        EventAdminLogListener.putBundleProperties(properties, bundle);
        Throwable t = entry.getException();
        if (t != null) {
            EventAdminLogListener.putExceptionProperties(properties, t);
        }
        if ((ref = entry.getServiceReference()) != null) {
            EventAdminLogListener.putServiceReferenceProperties(properties, ref);
        }
        properties.put(LOG_ENTRY, entry);
        properties.put(LOG_LEVEL, entry.getLevel());
        if (entry.getMessage() != null) {
            properties.put(MESSAGE, entry.getMessage());
        }
        properties.put(TIMESTAMP, entry.getTime());
        return this.event.newInstance(topic, properties);
    }

    public static void putServiceReferenceProperties(Hashtable<String, Object> properties, ServiceReference<?> ref) {
        Object o2;
        properties.put(SERVICE, ref);
        properties.put(SERVICE_ID, ref.getProperty(SERVICE_ID));
        Object o = ref.getProperty(SERVICE_PID);
        if (o != null && o instanceof String) {
            properties.put(SERVICE_PID, o);
        }
        if ((o2 = ref.getProperty("objectClass")) != null && o2 instanceof String[]) {
            properties.put(SERVICE_OBJECTCLASS, o2);
        }
    }

    public static void putBundleProperties(Hashtable<String, Object> properties, Bundle bundle) {
        properties.put(BUNDLE_ID, bundle.getBundleId());
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            properties.put(BUNDLE_SYMBOLICNAME, symbolicName);
        }
        properties.put(BUNDLE, bundle);
    }

    public static void putExceptionProperties(Hashtable<String, Object> properties, Throwable t) {
        properties.put(EXCEPTION, t);
        properties.put(EXCEPTION_CLASS, t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            properties.put(EXCEPTION_MESSAGE, t.getMessage());
        }
    }
}

