/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleWiring;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.BundleLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleCapability;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleWire;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.FrameworkWiring;

public class GlobalPolicy
implements IBuddyPolicy {
    private FrameworkWiring frameworkWiring;

    public GlobalPolicy(FrameworkWiring frameworkWiring) {
        this.frameworkWiring = frameworkWiring;
    }

    @Override
    public Class<?> loadClass(String name) {
        return this.getExportingBundles(BundleLoader.getPackageName(name)).stream().findFirst().map(b -> {
            try {
                return b.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }).orElse(null);
    }

    @Override
    public URL loadResource(String name) {
        return this.getExportingBundles(BundleLoader.getResourcePackageName(name)).stream().findFirst().map(b -> b.getResource(name)).orElse(null);
    }

    @Override
    public Enumeration<URL> loadResources(String name) {
        Enumeration<URL> results = null;
        Collection<Bundle> exporters = this.getExportingBundles(name);
        for (Bundle exporter : exporters) {
            try {
                results = BundleLoader.compoundEnumerations(results, exporter.getResources(name));
            }
            catch (IOException iOException) {}
        }
        return results;
    }

    private Collection<Bundle> getExportingBundles(String pkgName) {
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        String filter = "(osgi.wiring.package=" + pkgName + ")";
        Map<String, String> directives = Collections.singletonMap("filter", filter);
        Map<String, Boolean> attributes = Collections.singletonMap("org.jboss.forge.roaster._shade.org.eclipse.osgi.container.synthetic", Boolean.TRUE);
        Collection<BundleCapability> packages = this.frameworkWiring.findProviders(ModuleContainer.createRequirement("osgi.wiring.package", directives, attributes));
        for (BundleCapability pkg : packages) {
            if ((pkg.getRevision().getTypes() & 1) != 0) {
                ModuleWiring wiring = (ModuleWiring)pkg.getRevision().getWiring();
                for (BundleWire bundleWire : wiring.getRequiredModuleWires("osgi.wiring.host")) {
                    result.add(bundleWire.getProvider().getBundle());
                }
                continue;
            }
            result.add(pkg.getRevision().getBundle());
        }
        return result;
    }
}

