/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleWire;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleWiring;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.BundleLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;

public class DependentPolicy
implements IBuddyPolicy {
    BundleLoader buddyRequester;
    int lastDependentOfAdded = -1;
    List<ModuleWiring> allDependents = null;

    public DependentPolicy(BundleLoader requester) {
        this.buddyRequester = requester;
        this.allDependents = new ArrayList<ModuleWiring>();
        this.basicAddImmediateDependents(requester.getWiring());
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    @Override
    public Class<?> loadClass(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Class<?> result = null;
        int i = 0;
        while (i < this.allDependents.size() && result == null) {
            block5: {
                ModuleWiring searchWiring = this.allDependents.get(i);
                BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
                if (searchLoader != null) {
                    try {
                        result = searchLoader.findClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (result != null) break block5;
                        this.addDependent(i, searchWiring);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private synchronized void addDependent(int i, ModuleWiring searchedWiring) {
        if (i > this.lastDependentOfAdded) {
            this.lastDependentOfAdded = i;
            this.basicAddImmediateDependents(searchedWiring);
        }
    }

    @Override
    public URL loadResource(String name) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        int i = 0;
        while (i < this.allDependents.size() && result == null) {
            ModuleWiring searchWiring = this.allDependents.get(i);
            BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
            if (searchLoader != null && (result = searchLoader.findResource(name)) == null) {
                this.addDependent(i, searchWiring);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Enumeration<URL> loadResources(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration<URL> results = null;
        int i = 0;
        while (i < this.allDependents.size()) {
            ModuleWiring searchWiring = this.allDependents.get(i);
            BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
            if (searchLoader != null) {
                try {
                    results = BundleLoader.compoundEnumerations(results, searchLoader.findResources(name));
                    this.addDependent(i, searchWiring);
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return results;
    }

    private void basicAddImmediateDependents(ModuleWiring wiring) {
        List<ModuleWire> providedWires = wiring.getProvidedModuleWires(null);
        if (providedWires != null) {
            for (ModuleWire wire : providedWires) {
                ModuleWiring dependent;
                String namespace = wire.getRequirement().getNamespace();
                if (!"osgi.wiring.package".equals(namespace) && !"osgi.wiring.bundle".equals(namespace) || this.allDependents.contains(dependent = wire.getRequirerWiring())) continue;
                this.allDependents.add(dependent);
            }
        }
    }
}

