/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.container.InternalUtils;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.debug.Debug;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.debug.FrameworkDebugOptions;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.AliasMapper;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.location.EquinoxLocations;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.location.LocationHelper;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.EquinoxLogServices;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.messages.Msg;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.service.datalocation.Location;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.service.debug.DebugOptions;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.ManifestElement;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;
import org.jboss.forge.roaster._shade.org.osgi.framework.Version;

public class EquinoxConfiguration
implements EnvironmentInfo {
    private static final String CONFIG_FILE = "config.ini";
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_OS_LINUX = "Linux";
    private static final String INTERNAL_OS_MACOSX = "Mac OS";
    private static final String INTERNAL_OS_AIX = "AIX";
    private static final String INTERNAL_OS_HPUX = "HP-UX";
    private static final String INTERNAL_OS_QNX = "QNX";
    private static final String INTERNAL_OS_OS400 = "OS/400";
    private static final String INTERNAL_OS_OS390 = "OS/390";
    private static final String INTERNAL_OS_ZOS = "z/OS";
    private static final String INTERNAL_OS_FREEBSD = "FreeBSD";
    private static final String INTERNAL_ARCH_I386 = "i386";
    private static final String INTERNAL_AMD64 = "amd64";
    public static final String VARIABLE_DELIM_STRING = "$";
    public static final char VARIABLE_DELIM_CHAR = '$';
    private final ConfigValues configValues;
    private final Debug debug;
    private final DebugOptions debugOptions;
    private final HookRegistry hookRegistry;
    private final AliasMapper aliasMapper = new AliasMapper();
    private final EquinoxLocations equinoxLocations;
    private volatile String[] allArgs;
    private volatile String[] frameworkArgs;
    private volatile String[] appArgs;
    private final boolean inDevelopmentMode;
    private final File devLocation;
    private final Object devMonitor = new Object();
    private String[] devDefaultClasspath;
    private Dictionary<String, String> devProperties = null;
    private long devLastModified = 0L;
    public final boolean contextBootDelegation;
    public final boolean compatibilityBootDelegation;
    public final boolean compatibilityLazyTriggerOnFailLoad;
    public final List<String> LIB_EXTENSIONS;
    public final List<String> ECLIPSE_LIB_VARIANTS;
    public final boolean COPY_NATIVES;
    public final List<String> ECLIPSE_NL_JAR_VARIANTS;
    public final boolean DEFINE_PACKAGE_ATTRIBUTES;
    public final boolean BUNDLE_SET_TCCL;
    public final int BSN_VERSION;
    public static final int BSN_VERSION_SINGLE = 1;
    public static final int BSN_VERSION_MULTIPLE = 2;
    public static final int BSN_VERSION_MANAGED = 3;
    public final boolean throwErrorOnFailedStart;
    public final boolean CLASS_CERTIFICATE;
    public final boolean PARALLEL_CAPABLE;
    private final Map<Throwable, Integer> exceptions = new LinkedHashMap<Throwable, Integer>(0);
    public static final String PROP_JVM_OS_ARCH = "os.arch";
    public static final String PROP_JVM_OS_NAME = "os.name";
    public static final String PROP_JVM_OS_VERSION = "os.version";
    public static final String PROP_JVM_SPEC_VERSION = "java.specification.version";
    public static final String PROP_JVM_SPEC_NAME = "java.specification.name";
    public static final String PROP_SETPERMS_CMD = "osgi.filepermissions.command";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEBUG_VERBOSE = "osgi.debug.verbose";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_USE_SYSTEM_PROPERTIES = "osgi.framework.useSystemProperties";
    public static final String PROP_FRAMEWORK = "osgi.framework";
    public static final String ECLIPSE_FRAMEWORK_VENDOR = "Eclipse";
    public static final String PROP_OSGI_JAVA_PROFILE = "osgi.java.profile";
    public static final String PROP_OSGI_JAVA_PROFILE_NAME = "osgi.java.profile.name";
    public static final String PROP_OSGI_JAVA_PROFILE_BOOTDELEGATION = "osgi.java.profile.bootdelegation";
    public static final String PROP_OSGI_BOOTDELEGATION_IGNORE = "ignore";
    public static final String PROP_OSGI_BOOTDELEGATION_OVERRIDE = "override";
    public static final String PROP_OSGI_BOOTDELEGATION_NONE = "none";
    public static final String PROP_CONTEXT_BOOTDELEGATION = "osgi.context.bootdelegation";
    public static final String PROP_COMPATIBILITY_BOOTDELEGATION = "osgi.compatibility.bootdelegation";
    public static final String PROP_DS_DELAYED_KEEPINSTANCES = "ds.delayed.keepInstances";
    public static final String PROP_COMPATIBILITY_ERROR_FAILED_START = "osgi.compatibility.errorOnFailedStart";
    public static final String PROP_COMPATIBILITY_START_LAZY = "osgi.compatibility.eagerStart.LazyActivation";
    public static final String PROP_COMPATIBILITY_START_LAZY_ON_FAIL_CLASSLOAD = "osgi.compatibility.trigger.lazyActivation.onFailedClassLoad";
    public static final String PROP_OSGI_OS = "osgi.os";
    public static final String PROP_OSGI_WS = "osgi.ws";
    public static final String PROP_OSGI_ARCH = "osgi.arch";
    public static final String PROP_OSGI_NL = "osgi.nl";
    public static final String PROP_OSGI_NL_USER = "osgi.nl.user";
    public static final String PROP_ROOT_LOCALE = "equinox.root.locale";
    public static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    public static final String PARENT_CLASSLOADER_FWK = "fwk";
    public static final String PROP_CONTEXTCLASSLOADER_PARENT = "osgi.contextClassLoaderParent";
    public static final String CONTEXTCLASSLOADER_PARENT_APP = "app";
    public static final String CONTEXTCLASSLOADER_PARENT_EXT = "ext";
    public static final String CONTEXTCLASSLOADER_PARENT_BOOT = "boot";
    public static final String CONTEXTCLASSLOADER_PARENT_FWK = "fwk";
    public static final String PROP_FRAMEWORK_LIBRARY_EXTENSIONS = "osgi.framework.library.extensions";
    public static final String PROP_COPY_NATIVES = "osgi.classloader.copy.natives";
    public static final String PROP_DEFINE_PACKAGES = "osgi.classloader.define.packages";
    public static final String PROP_BUNDLE_SETTCCL = "eclipse.bundle.setTCCL";
    public static final String PROP_EQUINOX_SECURITY = "eclipse.security";
    public static final String PROP_FILE_LIMIT = "osgi.bundlefile.limit";
    public static final String PROP_CLASS_CERTIFICATE_SUPPORT = "osgi.support.class.certificate";
    public static final String PROP_CLASS_LOADER_TYPE = "osgi.classloader.type";
    public static final String CLASS_LOADER_TYPE_PARALLEL = "parallel";
    public static final String PROP_FORCED_RESTART = "osgi.forcedRestart";
    public static final String PROP_IGNORE_USER_CONFIGURATION = "eclipse.ignoreUserConfiguration";
    public static final String PROPERTY_STRICT_BUNDLE_ENTRY_PATH = "osgi.strictBundleEntryPath";
    public static final String PROP_CHECK_CONFIGURATION = "osgi.checkConfiguration";
    private final boolean inCheckConfigurationMode;
    public static final String DEFAULT_STATE_SAVE_DELAY_INTERVAL = "30000";
    public static final String PROP_STATE_SAVE_DELAY_INTERVAL = "eclipse.stateSaveDelayInterval";
    public static final String PROP_MODULE_LOCK_TIMEOUT = "osgi.module.lock.timeout";
    public static final String PROP_MODULE_AUTO_START_ON_RESOLVE = "osgi.module.auto.start.on.resolve";
    public static final String PROP_ALLOW_RESTRICTED_PROVIDES = "osgi.equinox.allow.restricted.provides";
    public static final String PROP_LOG_HISTORY_MAX = "equinox.log.history.max";
    public static final String PROP_LOG_CAPTURE_ENTRY_LOCATION = "equinox.log.capture.entry.location";
    @Deprecated
    public static final String PROP_RESOLVER_THREAD_COUNT = "equinox.resolver.thead.count";
    public static final String PROP_EQUINOX_RESOLVER_THREAD_COUNT = "equinox.resolver.thread.count";
    public static final String PROP_EQUINOX_START_LEVEL_THREAD_COUNT = "equinox.start.level.thread.count";
    public static final String PROP_EQUINOX_START_LEVEL_RESTRICT_PARALLEL = "equinox.start.level.restrict.parallel";
    public static final String PROP_RESOLVER_REVISION_BATCH_SIZE = "equinox.resolver.revision.batch.size";
    public static final String PROP_RESOLVER_BATCH_TIMEOUT = "equinox.resolver.batch.timeout";
    public static final String PROP_SYSTEM_PROVIDE_HEADER = "equinox.system.provide.header";
    public static final String SYSTEM_PROVIDE_HEADER_ORIGINAL = "original";
    public static final String SYSTEM_PROVIDE_HEADER_SYSTEM = "system";
    public static final String SYSTEM_PROVIDE_HEADER_SYSTEM_EXTRA = "system.extra";
    public static final String PROP_DEFAULT_SUFFIX = ".default";
    public static final Collection<String> PROP_WITH_ECLIPSE_STARTER_DEFAULTS = Collections.unmodifiableList(Arrays.asList("osgi.compatibility.bootdelegation", "ds.delayed.keepInstances"));
    public static final String PROP_INIT_UUID = "equinox.init.uuid";
    public static final String PROP_ACTIVE_THREAD_TYPE = "osgi.framework.activeThreadType";
    public static final String ACTIVE_THREAD_TYPE_NORMAL = "normal";
    public static final String PROP_GOSH_ARGS = "gosh.args";
    public static final String PROP_SECURE_UUID = "equinox.uuid.secure";
    public static final String SIGNED_BUNDLE_SUPPORT = "osgi.support.signature.verify";
    public static final String SIGNED_CONTENT_SUPPORT = "osgi.signedcontent.support";
    public static final int SIGNED_CONTENT_VERIFY_CERTIFICATE = 1;
    public static final int SIGNED_CONTENT_VERIFY_TRUST = 2;
    public static final int SIGNED_CONTENT_VERIFY_RUNTIME = 4;
    public static final int SIGNED_CONTENT_VERIFY_ALL = 7;
    private static final String SIGNED_CONTENT_SUPPORT_CERTIFICATE = "certificate";
    private static final String SIGNED_CONTENT_SUPPORT_TRUST = "trust";
    private static final String SIGNED_CONTENT_SUPPORT_RUNTIME = "runtime";
    private static final String SIGNED_CONTENT_SUPPORT_ALL = "all";
    private static final String SIGNED_CONTENT_SUPPORT_TRUE = "true";
    public final int supportSignedBundles;
    public final boolean runtimeVerifySignedBundles;

    EquinoxConfiguration(Map<String, ?> initialConfiguration, HookRegistry hookRegistry) {
        this.hookRegistry = hookRegistry;
        this.configValues = new ConfigValues(initialConfiguration, this.exceptions);
        this.initializeProperties();
        AtomicBoolean debugLocations = new AtomicBoolean();
        this.equinoxLocations = new EquinoxLocations(this.configValues, this.hookRegistry.getContainer(), debugLocations, this.exceptions);
        this.configValues.loadConfigIni(this.getConfigIni(this.equinoxLocations, false));
        this.configValues.loadConfigIni(this.getConfigIni(this.equinoxLocations, true));
        this.configValues.finalizeValues();
        this.debugOptions = new FrameworkDebugOptions(this);
        this.debug = new Debug(this.debugOptions);
        debugLocations.set(this.debug.DEBUG_LOCATION);
        String osgiDev = this.getConfiguration(PROP_DEV);
        File f = null;
        boolean devMode = false;
        if (osgiDev != null) {
            try {
                devMode = true;
                URL location = new URL(osgiDev);
                if ("file".equals(location.getProtocol())) {
                    f = LocationHelper.decodePath(new File(location.getPath()));
                    this.devLastModified = f.lastModified();
                }
                try {
                    this.loadDevProperties(LocationHelper.getStream(location));
                    devMode = true;
                }
                catch (IOException e) {
                    this.exceptions.put(e, 4);
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.devDefaultClasspath = EquinoxConfiguration.getArrayFromList(osgiDev);
            }
        }
        this.inDevelopmentMode = devMode;
        this.devLocation = f;
        this.contextBootDelegation = SIGNED_CONTENT_SUPPORT_TRUE.equals(this.getConfiguration(PROP_CONTEXT_BOOTDELEGATION, SIGNED_CONTENT_SUPPORT_TRUE));
        this.compatibilityBootDelegation = SIGNED_CONTENT_SUPPORT_TRUE.equals(this.getConfiguration(PROP_COMPATIBILITY_BOOTDELEGATION));
        this.compatibilityLazyTriggerOnFailLoad = SIGNED_CONTENT_SUPPORT_TRUE.equals(this.getConfiguration(PROP_COMPATIBILITY_START_LAZY_ON_FAIL_CLASSLOAD));
        this.COPY_NATIVES = Boolean.valueOf(this.getConfiguration(PROP_COPY_NATIVES));
        String[] libExtensions = ManifestElement.getArrayFromList(this.getConfiguration(PROP_FRAMEWORK_LIBRARY_EXTENSIONS, this.getConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.library.extensions", EquinoxConfiguration.getOSLibraryExtDefaults())), ",");
        int i = 0;
        while (i < libExtensions.length) {
            if (libExtensions[i].length() > 0 && libExtensions[i].charAt(0) != '.') {
                libExtensions[i] = String.valueOf('.') + libExtensions[i];
            }
            ++i;
        }
        this.LIB_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(libExtensions));
        this.ECLIPSE_LIB_VARIANTS = EquinoxConfiguration.buildEclipseLibraryVariants(this.getWS(), this.getOS(), this.getOSArch(), this.getNL());
        this.ECLIPSE_NL_JAR_VARIANTS = EquinoxConfiguration.buildNLJarVariants(this.getNL());
        this.DEFINE_PACKAGE_ATTRIBUTES = !"noattributes".equals(this.getConfiguration(PROP_DEFINE_PACKAGES));
        String bsnVersion = this.getConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.bsnversion");
        this.BSN_VERSION = "single".equals(bsnVersion) ? 1 : ("multiple".equals(bsnVersion) ? 2 : 3);
        this.BUNDLE_SET_TCCL = SIGNED_CONTENT_SUPPORT_TRUE.equals(this.getConfiguration(PROP_BUNDLE_SETTCCL, SIGNED_CONTENT_SUPPORT_TRUE));
        this.throwErrorOnFailedStart = SIGNED_CONTENT_SUPPORT_TRUE.equals(this.getConfiguration(PROP_COMPATIBILITY_ERROR_FAILED_START, SIGNED_CONTENT_SUPPORT_TRUE));
        this.PARALLEL_CAPABLE = CLASS_LOADER_TYPE_PARALLEL.equals(this.getConfiguration(PROP_CLASS_LOADER_TYPE));
        this.inCheckConfigurationMode = Boolean.valueOf(this.getConfiguration(PROP_CHECK_CONFIGURATION, Boolean.toString(devMode)));
        if (this.inCheckConfigurationMode && this.getConfiguration(PROP_CHECK_CONFIGURATION) == null) {
            this.setConfiguration(PROP_CHECK_CONFIGURATION, SIGNED_CONTENT_SUPPORT_TRUE);
        }
        this.supportSignedBundles = EquinoxConfiguration.getSupportSignedBundles(this);
        this.CLASS_CERTIFICATE = (this.supportSignedBundles & 1) != 0 && Boolean.valueOf(this.getConfiguration(PROP_CLASS_CERTIFICATE_SUPPORT, SIGNED_CONTENT_SUPPORT_TRUE)) != false;
        this.runtimeVerifySignedBundles = (this.supportSignedBundles & 4) != 0;
    }

    private static int getSupportSignedBundles(EquinoxConfiguration config) {
        String[] supportOptions;
        int supportSignedBundles = 0;
        String[] stringArray = supportOptions = ManifestElement.getArrayFromList(config.getConfiguration(SIGNED_CONTENT_SUPPORT, config.getConfiguration(SIGNED_BUNDLE_SUPPORT)), ",");
        int n = supportOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String supportOption = stringArray[n2];
            if (SIGNED_CONTENT_SUPPORT_CERTIFICATE.equals(supportOption)) {
                supportSignedBundles |= 1;
            } else if (SIGNED_CONTENT_SUPPORT_TRUST.equals(supportOption)) {
                supportSignedBundles |= 3;
            } else if (SIGNED_CONTENT_SUPPORT_RUNTIME.equals(supportOption)) {
                supportSignedBundles |= 5;
            } else if (SIGNED_CONTENT_SUPPORT_TRUE.equals(supportOption) || SIGNED_CONTENT_SUPPORT_ALL.equals(supportOption)) {
                supportSignedBundles |= 7;
            }
            ++n2;
        }
        return supportSignedBundles;
    }

    private URL getConfigIni(EquinoxLocations locations, boolean parent) {
        if (Boolean.TRUE.toString().equals(this.getConfiguration(PROP_IGNORE_USER_CONFIGURATION))) {
            return null;
        }
        Location configArea = locations.getConfigurationLocation();
        if (configArea != null && parent) {
            configArea = configArea.getParentLocation();
        }
        if (configArea == null) {
            return null;
        }
        try {
            return new URL(String.valueOf(configArea.getURL().toExternalForm()) + CONFIG_FILE);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Map<String, Object> getInitialConfig() {
        return this.configValues.getInitialConfig();
    }

    private static List<String> buildEclipseLibraryVariants(String ws, String os, String arch, String nl) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + ws + "/");
        result.add("os/" + os + "/" + arch + "/");
        result.add("os/" + os + "/");
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return Collections.unmodifiableList(result);
    }

    private static List<String> buildNLJarVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result;
    }

    private static String getOSLibraryExtDefaults() {
        String os = EquinoxContainer.secureAction.getProperty(PROP_JVM_OS_NAME);
        return os == null || !os.startsWith(INTERNAL_OS_MACOSX) ? null : "dylib,jnilib";
    }

    public boolean inCheckConfigurationMode() {
        return this.inCheckConfigurationMode;
    }

    @Override
    public boolean inDevelopmentMode() {
        return this.inDevelopmentMode;
    }

    @Override
    public boolean inDebugMode() {
        return this.debugOptions.isDebugEnabled();
    }

    @Override
    public String[] getCommandLineArgs() {
        return this.allArgs;
    }

    @Override
    public String[] getFrameworkArgs() {
        return this.frameworkArgs;
    }

    @Override
    public String[] getNonFrameworkArgs() {
        return this.appArgs;
    }

    @Override
    public String getOSArch() {
        return this.getConfiguration(PROP_OSGI_ARCH);
    }

    @Override
    public String getNL() {
        return this.getConfiguration(PROP_OSGI_NL);
    }

    @Override
    public String getOS() {
        return this.getConfiguration(PROP_OSGI_OS);
    }

    @Override
    public String getWS() {
        return this.getConfiguration(PROP_OSGI_WS);
    }

    public void setAllArgs(String[] allArgs) {
        this.allArgs = allArgs;
    }

    public void setAppArgs(String[] appArgs) {
        this.appArgs = appArgs;
    }

    public void setFrameworkArgs(String[] frameworkArgs) {
        this.frameworkArgs = frameworkArgs;
    }

    public static String guessWS(String osName) {
        if (osName.equals("win32")) {
            return "win32";
        }
        if (osName.equals("linux")) {
            return "gtk";
        }
        if (osName.equals("freebsd")) {
            return "gtk";
        }
        if (osName.equals("macosx")) {
            return "cocoa";
        }
        if (osName.equals("hpux")) {
            return "motif";
        }
        if (osName.equals("aix")) {
            return "motif";
        }
        if (osName.equals("solaris")) {
            return "gtk";
        }
        if (osName.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    public static String guessOS(String osName) {
        if (osName.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_SUNOS)) {
            return "solaris";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_LINUX)) {
            return "linux";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_QNX)) {
            return "qnx";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_AIX)) {
            return "aix";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_HPUX)) {
            return "hpux";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_OS400)) {
            return "os/400";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_OS390)) {
            return "os/390";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_ZOS)) {
            return "z/os";
        }
        if (osName.equalsIgnoreCase(INTERNAL_OS_FREEBSD)) {
            return "freebsd";
        }
        if (osName.regionMatches(true, 0, INTERNAL_OS_MACOSX, 0, INTERNAL_OS_MACOSX.length())) {
            return "macosx";
        }
        return "unknown";
    }

    public String getConfiguration(String key) {
        return this.configValues.getConfiguration(key);
    }

    public String getConfiguration(String key, String defaultValue) {
        return this.configValues.getConfiguration(key, defaultValue);
    }

    public String setConfiguration(String key, String value) {
        return this.configValues.setConfiguration(key, value);
    }

    public String clearConfiguration(String key) {
        return this.configValues.clearConfiguration(key);
    }

    public Map<String, String> getConfiguration() {
        return this.configValues.getConfiguration();
    }

    public Debug getDebug() {
        return this.debug;
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public HookRegistry getHookRegistry() {
        return this.hookRegistry;
    }

    @Override
    public String getProperty(String key) {
        return this.configValues.getProperty(key);
    }

    @Override
    public String setProperty(String key, String value) {
        return this.configValues.setProperty(key, value);
    }

    public AliasMapper getAliasMapper() {
        return this.aliasMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevProperties() {
        if (this.devLocation == null) {
            return;
        }
        Object object = this.devMonitor;
        synchronized (object) {
            if (this.devLocation.lastModified() == this.devLastModified) {
                return;
            }
            try {
                this.loadDevProperties(new FileInputStream(this.devLocation));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
            this.devLastModified = this.devLocation.lastModified();
        }
    }

    private static String[] getDevClassPath(String id, Dictionary<String, String> properties, String[] defaultClasspath) {
        String entry;
        String[] result = null;
        if (id != null && properties != null && (entry = properties.get(id)) != null) {
            result = EquinoxConfiguration.getArrayFromList(entry);
        }
        if (result == null) {
            result = defaultClasspath;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDevClassPath(String id, Dictionary<String, String> properties) {
        if (properties == null) {
            Object object = this.devMonitor;
            synchronized (object) {
                this.updateDevProperties();
                return EquinoxConfiguration.getDevClassPath(id, this.devProperties, this.devDefaultClasspath);
            }
        }
        return EquinoxConfiguration.getDevClassPath(id, properties, EquinoxConfiguration.getArrayFromList(properties.get("*")));
    }

    public String[] getDevClassPath(String id) {
        return this.getDevClassPath(id, null);
    }

    private static String[] getArrayFromList(String prop) {
        return ManifestElement.getArrayFromList(prop, ",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDevProperties(InputStream input) {
        Properties props;
        block18: {
            props = new Properties();
            try {
                try {
                    props.load(input);
                }
                catch (IOException e) {
                    this.exceptions.put(e, 4);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        Properties result = props;
        Object object = this.devMonitor;
        synchronized (object) {
            this.devProperties = result;
            if (this.devProperties != null) {
                this.devDefaultClasspath = EquinoxConfiguration.getArrayFromList(this.devProperties.get("*"));
            }
        }
    }

    private void initializeProperties() {
        String archValue;
        String wsValue;
        if (this.getConfiguration(PROP_FRAMEWORK) == null || this.getConfiguration("osgi.install.area") == null) {
            URL url;
            ProtectionDomain pd = EquinoxConfiguration.class.getProtectionDomain();
            CodeSource cs = pd == null ? null : pd.getCodeSource();
            URL uRL = url = cs == null ? null : cs.getLocation();
            if (url == null) {
                IOException cause = null;
                URL java6Profile = EquinoxConfiguration.class.getResource("/JavaSE-1.6.profile");
                if (java6Profile != null && "jar".equals(java6Profile.getProtocol())) {
                    try {
                        url = ((JarURLConnection)java6Profile.openConnection()).getJarFileURL();
                    }
                    catch (IOException e) {
                        cause = e;
                    }
                }
                if (url == null) {
                    throw new IllegalArgumentException(NLS.bind(Msg.ECLIPSE_STARTUP_PROPS_NOT_SET, "osgi.framework, osgi.install.area"), cause);
                }
            }
            if (this.getConfiguration(PROP_FRAMEWORK) == null) {
                String externalForm = EquinoxConfiguration.getFrameworkPath(url.toExternalForm(), false);
                this.setConfiguration(PROP_FRAMEWORK, externalForm);
            }
            if (this.getConfiguration("osgi.install.area") == null) {
                String installArea = "file".equals(url.getProtocol()) ? EquinoxConfiguration.getFrameworkPath(url.getPath(), true) : System.getProperty("user.dir");
                this.setConfiguration("osgi.install.area", installArea);
            }
        }
        this.setConfiguration(PROP_FRAMEWORK, LocationHelper.decode(this.getConfiguration(PROP_FRAMEWORK), true));
        this.setConfiguration("osgi.install.area", LocationHelper.decode(this.getConfiguration("osgi.install.area"), true));
        this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.vendor", ECLIPSE_FRAMEWORK_VENDOR);
        String value = this.getConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.processor");
        if (value == null && (value = EquinoxContainer.secureAction.getProperty(PROP_JVM_OS_ARCH)) != null) {
            this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.processor", this.aliasMapper.getCanonicalProcessor(value));
        }
        if ((value = this.getConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.os.name")) == null && (value = EquinoxContainer.secureAction.getProperty(PROP_JVM_OS_NAME)) != null) {
            this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.os.name", this.aliasMapper.getCanonicalOSName(value));
        }
        if ((value = this.getConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.os.version")) == null && (value = EquinoxContainer.secureAction.getProperty(PROP_JVM_OS_VERSION)) != null) {
            int space = value.indexOf(32);
            if (space > 0) {
                value = value.substring(0, space);
            }
            int major = 0;
            int minor = 0;
            int micro = 0;
            String qualifier = "";
            try {
                StringTokenizer st = new StringTokenizer(value, ".", true);
                major = EquinoxConfiguration.parseVersionInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    minor = EquinoxConfiguration.parseVersionInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        micro = EquinoxConfiguration.parseVersionInt(st.nextToken());
                        if (st.hasMoreTokens()) {
                            st.nextToken();
                            qualifier = st.nextToken();
                        }
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            try {
                value = new Version(major, minor, micro, qualifier).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                value = new Version(major, minor, micro).toString();
            }
            this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.os.version", value);
        }
        if ((value = this.getConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.language")) == null) {
            this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.language", Locale.getDefault().getLanguage());
        }
        this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.supports.framework.fragment", SIGNED_CONTENT_SUPPORT_TRUE);
        this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.supports.framework.requirebundle", SIGNED_CONTENT_SUPPORT_TRUE);
        this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.supports.framework.extension", SIGNED_CONTENT_SUPPORT_TRUE);
        String nlValue = this.getConfiguration(PROP_OSGI_NL);
        if (nlValue != null) {
            Locale userLocale = EquinoxConfiguration.toLocale(nlValue, Locale.getDefault());
            Locale.setDefault(userLocale);
            this.setConfiguration(PROP_OSGI_NL_USER, nlValue);
        }
        nlValue = Locale.getDefault().toString();
        this.setConfiguration(PROP_OSGI_NL, nlValue);
        String osValue = this.getConfiguration(PROP_OSGI_OS);
        if (osValue == null) {
            osValue = EquinoxConfiguration.guessOS(EquinoxContainer.secureAction.getProperty(PROP_JVM_OS_NAME));
            this.setConfiguration(PROP_OSGI_OS, osValue);
        }
        if ((wsValue = this.getConfiguration(PROP_OSGI_WS)) == null) {
            wsValue = EquinoxConfiguration.guessWS(osValue);
            this.setConfiguration(PROP_OSGI_WS, wsValue);
        }
        if ((archValue = this.getConfiguration(PROP_OSGI_ARCH)) == null) {
            String name = EquinoxContainer.secureAction.getProperty(PROP_JVM_OS_ARCH);
            archValue = name.equalsIgnoreCase(INTERNAL_ARCH_I386) ? "x86" : (name.equalsIgnoreCase(INTERNAL_AMD64) ? "x86_64" : name);
            this.setConfiguration(PROP_OSGI_ARCH, archValue);
        }
        String uuid = InternalUtils.newUUID(this);
        this.setConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.uuid", uuid);
    }

    private static String getFrameworkPath(String path, boolean parent) {
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        if (path.endsWith("org.eclipse.osgi/bin/")) {
            path = path.substring(0, path.length() - "bin/".length());
        }
        if (parent) {
            int lastSlash = path.lastIndexOf(47);
            return lastSlash == -1 ? "/" : path.substring(0, lastSlash);
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseVersionInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException v0) {
            sb = new StringBuilder(value.length());
            chars = value.toCharArray();
            i = 0;
            ** while (i < chars.length)
        }
lbl-1000:
        // 1 sources

        {
            if (!Character.isDigit(chars[i])) break;
            sb.append(chars[i]);
            ++i;
            continue;
        }
lbl13:
        // 2 sources

        if (sb.length() > 0) {
            return Integer.parseInt(sb.toString());
        }
        return 0;
    }

    public String substituteVars(String path) {
        return this.substituteVars(path, false);
    }

    public String substituteVars(String path, boolean preserveDelimiters) {
        return this.configValues.substituteVars(path, preserveDelimiters);
    }

    public static Locale toLocale(String str, Locale defaultLocale) {
        if (str == null) {
            System.err.println("Given locale String is null - Default Locale will be used instead.");
            return defaultLocale;
        }
        String language = "";
        String country = "";
        String variant = "";
        String[] localeParts = str.split("_");
        if (localeParts.length == 0 || localeParts.length > 3 || localeParts.length == 1 && localeParts[0].length() == 0) {
            System.err.println(NLS.bind(Msg.error_badNL, str));
            return defaultLocale;
        }
        if (localeParts[0].length() > 0 && !localeParts[0].matches("[a-zA-Z]{2,8}")) {
            System.err.println(NLS.bind(Msg.error_badNL, str));
            return defaultLocale;
        }
        language = localeParts[0];
        if (localeParts.length > 1) {
            if (localeParts[1].length() > 0 && !localeParts[1].matches("[a-zA-Z]{2}|[0-9]{3}")) {
                if (language.length() > 0) {
                    System.err.println(NLS.bind(Msg.error_badNL_language, str));
                    return new Locale(language);
                }
                System.err.println(NLS.bind(Msg.error_badNL, str));
                return defaultLocale;
            }
            country = localeParts[1];
        }
        if (localeParts.length == 3) {
            if (localeParts[2].length() == 0) {
                System.err.println(NLS.bind(Msg.error_badNL_language_country, str));
                return new Locale(language, country);
            }
            variant = localeParts[2];
        }
        return new Locale(language, country, variant);
    }

    public EquinoxLocations getEquinoxLocations() {
        return this.equinoxLocations;
    }

    void logMessages(EquinoxLogServices logServices) {
        for (Map.Entry<Throwable, Integer> exception : this.exceptions.entrySet()) {
            logServices.log("org.jboss.forge.roaster._shade.org.eclipse.osgi", exception.getValue(), exception.getKey().getMessage(), exception.getKey());
        }
        this.exceptions.clear();
    }

    public static final class ConfigValues {
        private static final String NULL_CONFIG = new String("org.jboss.forge.roaster._shade.org.eclipse.equinox.configuration.null.value");
        private static final Collection<String> populateInitConfig = Arrays.asList("osgi.arch", "osgi.os", "osgi.ws", "osgi.nl", "org.jboss.forge.roaster._shade.org.osgi.framework.os.name", "org.jboss.forge.roaster._shade.org.osgi.framework.os.version", "org.jboss.forge.roaster._shade.org.osgi.framework.processor", "org.jboss.forge.roaster._shade.org.osgi.framework.language");
        private final boolean useSystemProperties;
        private final Map<String, Object> initialConfig;
        private final Properties localConfig;
        private final Map<Throwable, Integer> exceptions;

        public ConfigValues(Map<String, ?> initialConfiguration, Map<Throwable, Integer> exceptions) {
            this.exceptions = exceptions;
            this.initialConfig = initialConfiguration == null ? new HashMap<String, Object>(0) : new HashMap(initialConfiguration);
            Object useSystemPropsValue = this.initialConfig.get(EquinoxConfiguration.PROP_USE_SYSTEM_PROPERTIES);
            this.useSystemProperties = useSystemPropsValue == null ? false : Boolean.parseBoolean(useSystemPropsValue.toString());
            Properties tempConfiguration = this.useSystemProperties ? EquinoxContainer.secureAction.getProperties() : new Properties();
            for (Map.Entry<String, Object> initialEntry : this.initialConfig.entrySet()) {
                if (initialEntry.getValue() == null) {
                    if (this.useSystemProperties) {
                        tempConfiguration.remove(initialEntry.getKey());
                        continue;
                    }
                    tempConfiguration.put(initialEntry.getKey(), NULL_CONFIG);
                    continue;
                }
                tempConfiguration.put(initialEntry.getKey(), initialEntry.getValue());
            }
            this.localConfig = this.useSystemProperties ? null : tempConfiguration;
        }

        void loadConfigIni(URL configIni) {
            if (configIni != null) {
                this.mergeConfiguration(this.loadProperties(configIni));
            }
        }

        void finalizeValues() {
            for (String initialKey : populateInitConfig) {
                String value = this.getConfiguration(initialKey);
                if (value == null) continue;
                this.initialConfig.put(initialKey, value);
            }
            for (String keyWithEclipseStarterDefault : PROP_WITH_ECLIPSE_STARTER_DEFAULTS) {
                String defaultValue;
                String currentValue = this.getConfiguration(keyWithEclipseStarterDefault);
                if (currentValue != null || (defaultValue = this.getConfiguration(String.valueOf(keyWithEclipseStarterDefault) + EquinoxConfiguration.PROP_DEFAULT_SUFFIX)) == null) continue;
                this.setConfiguration(keyWithEclipseStarterDefault, defaultValue);
            }
            if ("onFirstInit".equals(this.getConfiguration("org.jboss.forge.roaster._shade.org.osgi.framework.storage.clean"))) {
                this.setConfiguration(EquinoxConfiguration.PROP_CLEAN, EquinoxConfiguration.SIGNED_CONTENT_SUPPORT_TRUE);
            }
            if (this.getConfiguration(EquinoxConfiguration.PROP_STATE_SAVE_DELAY_INTERVAL) == null) {
                this.setConfiguration(EquinoxConfiguration.PROP_STATE_SAVE_DELAY_INTERVAL, EquinoxConfiguration.DEFAULT_STATE_SAVE_DELAY_INTERVAL);
            }
            try {
                Long.parseLong(this.getConfiguration(EquinoxConfiguration.PROP_STATE_SAVE_DELAY_INTERVAL));
            }
            catch (NumberFormatException e) {
                this.exceptions.put(e, 4);
                this.setConfiguration(EquinoxConfiguration.PROP_STATE_SAVE_DELAY_INTERVAL, EquinoxConfiguration.DEFAULT_STATE_SAVE_DELAY_INTERVAL);
            }
            if (this.getConfiguration(EquinoxConfiguration.PROP_GOSH_ARGS) == null) {
                String consoleProp = this.getConfiguration("osgi.console");
                String string = consoleProp = consoleProp == null ? null : consoleProp.trim();
                if (consoleProp == null || consoleProp.length() > 0) {
                    this.setConfiguration(EquinoxConfiguration.PROP_GOSH_ARGS, "--nointeractive");
                } else {
                    this.setConfiguration(EquinoxConfiguration.PROP_GOSH_ARGS, "--noshutdown");
                }
            }
        }

        private void mergeConfiguration(Properties source) {
            Enumeration<Object> e = source.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = source.getProperty(key);
                if (this.getConfiguration(key) == null) {
                    this.setProperty(key, value);
                    this.initialConfig.put(key, value);
                    continue;
                }
                this.initialConfig.put(key, this.getConfiguration(key));
            }
        }

        private Properties loadProperties(URL location) {
            Properties result = new Properties();
            if (location == null) {
                return result;
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream in = LocationHelper.getStream(location);){
                    result.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                this.exceptions.put(e, 2);
            }
            return this.substituteVars(result);
        }

        private Properties substituteVars(Properties result) {
            if (result == null) {
                return null;
            }
            Enumeration<Object> eKeys = result.keys();
            while (eKeys.hasMoreElements()) {
                String value;
                Object key = eKeys.nextElement();
                if (!(key instanceof String) || (value = result.getProperty((String)key)) == null) continue;
                result.put(key, this.substituteVars(value, true));
            }
            return result;
        }

        public String substituteVars(String path, boolean preserveDelimiters) {
            StringBuilder buf = new StringBuilder(path.length());
            StringTokenizer st = new StringTokenizer(path, EquinoxConfiguration.VARIABLE_DELIM_STRING, true);
            boolean varStarted = false;
            String var = null;
            while (st.hasMoreElements()) {
                String tok = st.nextToken();
                if (EquinoxConfiguration.VARIABLE_DELIM_STRING.equals(tok)) {
                    if (!varStarted) {
                        varStarted = true;
                        var = "";
                        continue;
                    }
                    String prop = null;
                    if (var != null && var.length() > 0) {
                        prop = this.getProperty(var);
                    }
                    if (prop == null) {
                        try {
                            Method getenv = System.class.getMethod("getenv", String.class);
                            prop = (String)getenv.invoke(null, var);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (prop != null) {
                        buf.append(prop);
                    } else {
                        if (preserveDelimiters) {
                            buf.append('$');
                        }
                        buf.append(var == null ? "" : var);
                        if (preserveDelimiters) {
                            buf.append('$');
                        }
                    }
                    varStarted = false;
                    var = null;
                    continue;
                }
                if (!varStarted) {
                    buf.append(tok);
                    continue;
                }
                var = tok;
            }
            if (var != null) {
                buf.append('$').append(var);
            }
            return buf.toString();
        }

        public String getProperty(String key) {
            String result = this.internalGet(key);
            if (result == NULL_CONFIG) {
                return null;
            }
            return result == null ? EquinoxContainer.secureAction.getProperty(key) : result;
        }

        public String setProperty(String key, String value) {
            if (value == null) {
                return this.clearConfiguration(key);
            }
            return this.setConfiguration(key, value);
        }

        public String getConfiguration(String key) {
            String result = this.internalGet(key);
            return result == NULL_CONFIG ? null : result;
        }

        private String internalGet(String key) {
            if (this.useSystemProperties) {
                return EquinoxContainer.secureAction.getProperty(key);
            }
            return this.localConfig.getProperty(key);
        }

        public String getConfiguration(String key, String defaultValue) {
            String result = this.getConfiguration(key);
            return result == null ? defaultValue : result;
        }

        public String setConfiguration(String key, String value) {
            Object result = this.internalPut(key, value);
            return result instanceof String && result != NULL_CONFIG ? (String)result : null;
        }

        public String clearConfiguration(String key) {
            Object result = this.internalRemove(key);
            if (!this.useSystemProperties) {
                this.internalPut(key, NULL_CONFIG);
            }
            return result instanceof String && result != NULL_CONFIG ? (String)result : null;
        }

        private Object internalPut(String key, String value) {
            if (this.useSystemProperties) {
                return EquinoxContainer.secureAction.getProperties().put(key, value);
            }
            return this.localConfig.put(key, value);
        }

        private Object internalRemove(String key) {
            if (this.useSystemProperties) {
                return EquinoxContainer.secureAction.getProperties().remove(key);
            }
            return this.localConfig.remove(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> getConfiguration() {
            Properties props;
            Properties properties = props = this.useSystemProperties ? EquinoxContainer.secureAction.getProperties() : this.localConfig;
            synchronized (properties) {
                HashMap<String, String> result = new HashMap<String, String>(props.size());
                for (Object key : props.keySet()) {
                    String skey;
                    String sValue;
                    if (!(key instanceof String) || (sValue = props.getProperty(skey = (String)key)) == NULL_CONFIG) continue;
                    result.put(skey, sValue);
                }
                return result;
            }
        }

        public Map<String, Object> getInitialConfig() {
            return Collections.unmodifiableMap(this.initialConfig);
        }
    }
}

