/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.container;

import java.security.Permission;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundlePermission;
import org.jboss.forge.roaster._shade.org.osgi.framework.CapabilityPermission;
import org.jboss.forge.roaster._shade.org.osgi.framework.PackagePermission;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleCapability;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleRequirement;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleRevision;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleWire;
import org.jboss.forge.roaster._shade.org.osgi.framework.wiring.BundleWiring;
import org.jboss.forge.roaster._shade.org.osgi.resource.Capability;
import org.jboss.forge.roaster._shade.org.osgi.resource.Requirement;
import org.jboss.forge.roaster._shade.org.osgi.resource.Resource;
import org.jboss.forge.roaster._shade.org.osgi.resource.Wire;

public class InternalUtils {
    public static <T> List<T> asCopy(List<T> list) {
        return new ArrayList<T>(list);
    }

    public static List<Capability> asListCapability(List<? extends Capability> l) {
        return l;
    }

    public static List<Requirement> asListRequirement(List<? extends Requirement> l) {
        return l;
    }

    public static List<BundleCapability> asListBundleCapability(List<? extends BundleCapability> l) {
        return l;
    }

    public static List<BundleRequirement> asListBundleRequirement(List<? extends BundleRequirement> l) {
        return l;
    }

    public static List<BundleWire> asListBundleWire(List<? extends BundleWire> l) {
        return l;
    }

    public static List<Wire> asListWire(List<? extends Wire> l) {
        return l;
    }

    public static List<BundleRevision> asListBundleRevision(List<? extends BundleRevision> l) {
        return l;
    }

    public static Collection<Resource> asCollectionResource(Collection<? extends Resource> c) {
        return c;
    }

    public static Collection<BundleWiring> asCollectionBundleWiring(Collection<? extends BundleWiring> c) {
        return c;
    }

    public static void filterCapabilityPermissions(Collection<? extends BundleCapability> capabilities) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Iterator<? extends BundleCapability> iCapabilities = capabilities.iterator();
        while (iCapabilities.hasNext()) {
            BundleCapability capability = iCapabilities.next();
            Permission permission = InternalUtils.getProvidePermission(capability);
            Bundle provider = capability.getRevision().getBundle();
            if (provider == null || provider.hasPermission(permission)) continue;
            iCapabilities.remove();
        }
    }

    public static Permission getRequirePermission(BundleCapability candidate) {
        String name = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), candidate.getRevision().getBundle(), "import");
        }
        if ("osgi.wiring.host".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "fragment");
        }
        if ("osgi.wiring.bundle".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "require");
        }
        return new CapabilityPermission(name, candidate.getAttributes(), candidate.getRevision().getBundle(), "require");
    }

    public static Permission getProvidePermission(BundleCapability candidate) {
        String name = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), "exportonly");
        }
        if ("osgi.wiring.host".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "host");
        }
        if ("osgi.wiring.bundle".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "provide");
        }
        return new CapabilityPermission(name, "provide");
    }

    private static String getPermisionName(BundleCapability candidate) {
        Object name = candidate.getAttributes().get(candidate.getNamespace());
        if (name instanceof String) {
            return (String)name;
        }
        if (name instanceof Collection) {
            Collection names = (Collection)name;
            return names.isEmpty() ? "unknown" : names.iterator().next().toString();
        }
        return "unknown";
    }

    public static String newUUID(EquinoxConfiguration config) {
        boolean useSecureRandom = "true".equals(config.getConfiguration("equinox.uuid.secure"));
        byte[] uuidBytes = new byte[16];
        if (useSecureRandom) {
            new SecureRandom().nextBytes(uuidBytes);
        } else {
            new Random().nextBytes(uuidBytes);
        }
        uuidBytes[6] = (byte)(uuidBytes[6] & 0xF);
        uuidBytes[6] = (byte)(uuidBytes[6] | 0x40);
        uuidBytes[8] = (byte)(uuidBytes[8] & 0x3F);
        uuidBytes[8] = (byte)(uuidBytes[8] | 0x80);
        long mostSignificantBits = 0L;
        long leastSignificantBits = 0L;
        int i = 0;
        while (i < 8) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(uuidBytes[i] & 0xFF);
            ++i;
        }
        i = 8;
        while (i < 16) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(uuidBytes[i] & 0xFF);
            ++i;
        }
        return new UUID(mostSignificantBits, leastSignificantBits).toString();
    }
}

