/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.util;

import java.util.Arrays;

public class CharArrayUtils {
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final char[] EMPTY = EMPTY_CHAR_ARRAY;
    public static final char[][] EMPTY_ARRAY_OF_CHAR_ARRAYS = new char[0][];

    private CharArrayUtils() {
    }

    public static final int hash(char[] str, int start, int length) {
        int h = 0;
        int end = start + length;
        int curr = start;
        while (curr < end) {
            h = 31 * h + str[curr];
            ++curr;
        }
        return h;
    }

    public static final int hash(char[] str) {
        return CharArrayUtils.hash(str, 0, str.length);
    }

    public static final boolean equals(char[] str1, char[] str2) {
        return Arrays.equals(str1, str2);
    }

    public static final boolean equals(char[][] strarr1, char[][] strarr2) {
        if (strarr1 == strarr2) {
            return true;
        }
        if (strarr1 == null || strarr2 == null) {
            return false;
        }
        if (strarr1.length != strarr2.length) {
            return false;
        }
        int i = 0;
        while (i < strarr2.length) {
            if (!Arrays.equals(strarr1[i], strarr2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(char[] str1, String str2) {
        int length = str1.length;
        if (str2.length() != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (str1[i] != str2.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean hasCharAt(char toLookFor, int position, char[] toSearch) {
        if (toSearch.length <= position) {
            return false;
        }
        return toSearch[position] == toLookFor;
    }

    public static final boolean equals(char[] str1, int start1, int length1, String str2) {
        if (length1 != str2.length() || str1.length < length1 + start1) {
            return false;
        }
        int i = 0;
        while (i < length1) {
            if (str1[start1++] != str2.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean startsWith(char[] str1, String str2) {
        int len = str2.length();
        if (str1.length < len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (str1[i] != str2.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int compare(char[] str1, char[] str2) {
        if (str1 == str2) {
            return 0;
        }
        int end = Math.min(str1.length, str2.length);
        int i = 0;
        while (i < end) {
            int diff = str1[i] - str2[i];
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return str1.length - str2.length;
    }

    public static final boolean equals(char[] str1, int start1, int length1, char[] str2) {
        if (length1 != str2.length || str1.length < length1 + start1) {
            return false;
        }
        if (str1 == str2 && start1 == 0) {
            return true;
        }
        int i = 0;
        while (i < length1) {
            if (str1[start1++] != str2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(char[] str1, int start1, int length1, char[] str2, boolean ignoreCase) {
        if (!ignoreCase) {
            return CharArrayUtils.equals(str1, start1, length1, str2);
        }
        if (length1 != str2.length || str1.length < start1 + length1) {
            return false;
        }
        int i = 0;
        while (i < length1) {
            if (Character.toLowerCase(str1[start1++]) != Character.toLowerCase(str2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final char[] extract(char[] str, int start, int length) {
        if (start == 0 && length == str.length) {
            return str;
        }
        char[] copy = new char[length];
        System.arraycopy(str, start, copy, 0, length);
        return copy;
    }

    public static final char[] concat(char[] first, char[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static final char[] concat(char[] first, char[] second, char[] third) {
        if (first == null) {
            return CharArrayUtils.concat(second, third);
        }
        if (second == null) {
            return CharArrayUtils.concat(first, third);
        }
        if (third == null) {
            return CharArrayUtils.concat(first, second);
        }
        int length1 = first.length;
        int length2 = second.length;
        int length3 = third.length;
        char[] result = new char[length1 + length2 + length3];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        System.arraycopy(third, 0, result, length1 + length2, length3);
        return result;
    }

    public static final char[] concat(char[] first, char[] second, char[] third, char[] fourth) {
        if (first == null) {
            return CharArrayUtils.concat(second, third, fourth);
        }
        if (second == null) {
            return CharArrayUtils.concat(first, third, fourth);
        }
        if (third == null) {
            return CharArrayUtils.concat(first, second, fourth);
        }
        if (fourth == null) {
            return CharArrayUtils.concat(first, second, third);
        }
        int length1 = first.length;
        int length2 = second.length;
        int length3 = third.length;
        int length4 = fourth.length;
        char[] result = new char[length1 + length2 + length3 + length4];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        System.arraycopy(third, 0, result, length1 + length2, length3);
        System.arraycopy(fourth, 0, result, length1 + length2 + length3, length4);
        return result;
    }

    public static char[] concat(char[] ... toCatenate) {
        int totalSize = 0;
        char[][] cArray = toCatenate;
        int n = toCatenate.length;
        int n2 = 0;
        while (n2 < n) {
            char[] next = cArray[n2];
            totalSize += next.length;
            ++n2;
        }
        char[] result = new char[totalSize];
        int writeIndex = 0;
        char[][] cArray2 = toCatenate;
        int n3 = toCatenate.length;
        int n4 = 0;
        while (n4 < n3) {
            char[] next = cArray2[n4];
            if (next != null) {
                System.arraycopy(next, 0, result, writeIndex, next.length);
                writeIndex += next.length;
            }
            ++n4;
        }
        return result;
    }

    public static final char[] replace(char[] array, char[] toBeReplaced, char[] replacementChars) {
        int max = array.length;
        int replacedLength = toBeReplaced.length;
        int replacementLength = replacementChars.length;
        int[] starts = new int[5];
        int occurrenceCount = 0;
        if (!CharArrayUtils.equals(toBeReplaced, replacementChars)) {
            int i = 0;
            while (i < max) {
                block7: {
                    int j = 0;
                    while (j < replacedLength) {
                        if (i + j != max && array[i + j] == toBeReplaced[j++]) {
                            continue;
                        }
                        break block7;
                    }
                    if (occurrenceCount == starts.length) {
                        int[] nArray = starts;
                        starts = new int[occurrenceCount * 2];
                        System.arraycopy(nArray, 0, starts, 0, occurrenceCount);
                    }
                    starts[occurrenceCount++] = i;
                }
                ++i;
            }
        }
        if (occurrenceCount == 0) {
            return array;
        }
        char[] result = new char[max + occurrenceCount * (replacementLength - replacedLength)];
        int inStart = 0;
        int outStart = 0;
        int i = 0;
        while (i < occurrenceCount) {
            int offset = starts[i] - inStart;
            System.arraycopy(array, inStart, result, outStart, offset);
            inStart += offset;
            System.arraycopy(replacementChars, 0, result, outStart += offset, replacementLength);
            inStart += replacedLength;
            outStart += replacementLength;
            ++i;
        }
        System.arraycopy(array, inStart, result, outStart, max - inStart);
        return result;
    }

    public static final char[][] subarray(char[][] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[][] result = new char[end - start][];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final int indexOf(char toBeFound, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char toBeFound, char[] buffer, int start, int end) {
        if (start < 0 || start > buffer.length || end > buffer.length) {
            return -1;
        }
        int i = start;
        while (i < end) {
            if (toBeFound == buffer[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(char[] toBeFound, char[] array) {
        if (toBeFound.length > array.length) {
            return -1;
        }
        int j = 0;
        int i = 0;
        while (i < array.length) {
            if (toBeFound[j] == array[i]) {
                if (++j == toBeFound.length) {
                    return i - j + 1;
                }
            } else {
                j = 0;
            }
            ++i;
        }
        return -1;
    }

    public static final int lastIndexOf(char[] toBeFound, char[] array) {
        return CharArrayUtils.lastIndexOf(toBeFound, array, 0);
    }

    public static int lastIndexOf(char toBeFound, char[] array) {
        return CharArrayUtils.lastIndexOf(toBeFound, array, 0);
    }

    public static int lastIndexOf(char toBeFound, char[] array, int fromIndex) {
        int i = array.length;
        while (--i >= fromIndex) {
            if (array[i] != toBeFound) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] toBeFound, char[] array, int fromIndex) {
        int i = array.length;
        int j = toBeFound.length;
        while (--j >= 0) {
            if (--i < fromIndex) {
                return -1;
            }
            if (toBeFound[j] == array[i]) continue;
            i += toBeFound.length - j - 1;
            j = toBeFound.length;
        }
        return i;
    }

    public static final char[] trim(char[] chars) {
        if (chars == null) {
            return null;
        }
        int length = chars.length;
        int start = 0;
        while (start < length && chars[start] == ' ') {
            ++start;
        }
        if (start == length) {
            return EMPTY_CHAR_ARRAY;
        }
        int end = length;
        while (--end > start && chars[end] == ' ') {
        }
        if (start == 0 && ++end == length) {
            return chars;
        }
        return CharArrayUtils.subarray(chars, start, end);
    }

    public static final char[] lastSegment(char[] array, char[] separator) {
        int pos = CharArrayUtils.lastIndexOf(separator, array);
        if (pos < 0) {
            return array;
        }
        return CharArrayUtils.subarray(array, pos + separator.length, array.length);
    }

    public static void overWrite(char[] buff, int i, char[] charImage) {
        if (buff.length < i + charImage.length) {
            return;
        }
        System.arraycopy(charImage, 0, buff, i, charImage.length);
    }

    public static int indexOf(char[] searchFor, char[][] searchIn) {
        int i = 0;
        while (i < searchIn.length) {
            if (CharArrayUtils.equals(searchIn[i], searchFor)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static char[] extractChars(StringBuilder buf) {
        int len = buf.length();
        if (len == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[len];
        buf.getChars(0, len, result, 0);
        return result;
    }

    public static char[] subarray(char[] inputString, int index) {
        if (inputString.length <= index) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[inputString.length - index];
        System.arraycopy(inputString, index, result, 0, result.length);
        return result;
    }

    public static boolean startsWith(char[] fieldDescriptor, char c) {
        return fieldDescriptor.length > 0 && fieldDescriptor[0] == c;
    }

    public static char[] notNull(char[] contents) {
        if (contents == null) {
            return EMPTY_CHAR_ARRAY;
        }
        return contents;
    }

    public static boolean endsWith(char[] fieldDescriptor, char c) {
        if (fieldDescriptor.length == 0) {
            return false;
        }
        return fieldDescriptor[fieldDescriptor.length - 1] == c;
    }
}

