/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IFile;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IResource;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IPath;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Path;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IClassFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IJavaElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IOrdinaryClassFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaModelException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.CharOperation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClassFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelManager;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.PackageFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeDescriptor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.Util;

public class BinaryTypeFactory {
    private static BinaryTypeDescriptor createDescriptor(PackageFragment pkg, ClassFile classFile) {
        String indexPath;
        PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
        IPath location = BinaryTypeFactory.getLocationForElement(root);
        if (location == null) {
            return null;
        }
        String entryName = Util.concatWith(pkg.names, classFile.getElementName(), '/');
        String name = Util.concatWith(pkg.names, classFile.getName(), '/');
        String overridePath = root.getClassFilePath(entryName);
        if (overridePath != entryName) {
            entryName = overridePath;
            String versionPath = overridePath.substring(0, overridePath.indexOf(entryName));
            name = String.valueOf(versionPath) + name;
        }
        char[] fieldDescriptor = CharArrayUtils.concat(new char[]{'L'}, name.toCharArray(), new char[]{';'});
        IPath workspacePath = root.getPath();
        if (root instanceof JarPackageFragmentRoot) {
            indexPath = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
        } else {
            location = location.append(entryName);
            indexPath = workspacePath.append(entryName).toString();
            workspacePath = classFile.resource().getFullPath();
        }
        return new BinaryTypeDescriptor(location.toString().toCharArray(), fieldDescriptor, workspacePath.toString().toCharArray(), indexPath.toCharArray());
    }

    public static BinaryTypeDescriptor createDescriptor(IClassFile classFile) {
        ClassFile concreteClass = (ClassFile)classFile;
        PackageFragment parent = (PackageFragment)classFile.getParent();
        return BinaryTypeFactory.createDescriptor(parent, concreteClass);
    }

    public static IBinaryType create(IOrdinaryClassFile classFile, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        BinaryTypeDescriptor descriptor = BinaryTypeFactory.createDescriptor(classFile);
        return BinaryTypeFactory.readType(descriptor, monitor);
    }

    public static IBinaryType readType(BinaryTypeDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        return BinaryTypeFactory.rawReadType(descriptor, true);
    }

    public static ClassFileReader rawReadType(BinaryTypeDescriptor descriptor, boolean fullyInitialize) throws JavaModelException, ClassFormatException {
        try {
            return BinaryTypeFactory.rawReadTypeTestForExists(descriptor, fullyInitialize, true);
        }
        catch (FileNotFoundException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public static ClassFileReader rawReadTypeTestForExists(BinaryTypeDescriptor descriptor, boolean fullyInitialize, boolean useInvalidArchiveCache) throws JavaModelException, ClassFormatException, FileNotFoundException {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.isInJarFile()) {
            if (CharOperation.indexOf("jrt-fs.jar".toCharArray(), descriptor.location, false) == -1) {
                ZipFile zip;
                block23: {
                    zip = null;
                    try {
                        byte[] contents;
                        zip = JavaModelManager.getJavaModelManager().getZipFile(new Path(new String(descriptor.workspacePath)), useInvalidArchiveCache);
                        char[] entryNameCharArray = CharArrayUtils.concat(BinaryTypeFactory.fieldDescriptorToBinaryName(descriptor.fieldDescriptor), SuffixConstants.SUFFIX_class);
                        String entryName = new String(entryNameCharArray);
                        ZipEntry ze22 = zip.getEntry(entryName);
                        if (ze22 == null) break block23;
                        try {
                            contents = org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(ze22, zip);
                        }
                        catch (IOException ioe) {
                            throw new JavaModelException(ioe, 985);
                        }
                        ClassFileReader classFileReader = new ClassFileReader(contents, descriptor.indexPath, fullyInitialize);
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        return classFileReader;
                    }
                    catch (CoreException e) {
                        try {
                            throw new JavaModelException(e);
                        }
                        catch (Throwable throwable) {
                            JavaModelManager.getJavaModelManager().closeZipFile(zip);
                            throw throwable;
                        }
                    }
                }
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
            }
        } else {
            byte[] contents;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(new String(descriptor.workspacePath)));
            try {
                Throwable entryName = null;
                Object ze22 = null;
                try (InputStream stream = file.getContents(true);){
                    contents = org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.Util.getInputStreamAsByteArray(stream);
                }
                catch (Throwable ze22) {
                    if (entryName == null) {
                        entryName = ze22;
                    } else if (entryName != ze22) {
                        entryName.addSuppressed(ze22);
                    }
                    throw entryName;
                }
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status.getCode() == 368) {
                    throw new FileNotFoundException();
                }
                throw new JavaModelException(e);
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            return new ClassFileReader(contents, file.getFullPath().toString().toCharArray(), fullyInitialize);
        }
        return null;
    }

    public static IPath getLocationForElement(IJavaElement next) {
        IResource resource = next.getResource();
        if (resource != null) {
            return resource.getLocation() == null ? Path.EMPTY : resource.getLocation();
        }
        return next.getPath();
    }

    public static char[] fieldDescriptorToBinaryName(char[] fieldDescriptor) {
        if (CharArrayUtils.startsWith(fieldDescriptor, 'L')) {
            int end = fieldDescriptor.length - 1;
            return CharArrayUtils.subarray(fieldDescriptor, 1, end);
        }
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    public static final class NotInIndexException
    extends Exception {
        private static final long serialVersionUID = 2859848007651528256L;
    }
}

