/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.Container;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.Resource;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.ResourceException;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.ResourceInfo;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.ResourceStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.SyncInfoReader;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.SyncInfoSnapReader;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.SyncInfoWriter;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources.Workspace;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.utils.Messages;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.utils.Policy;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.watson.IPathRequestor;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IContainer;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IResource;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IResourceVisitor;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.ISynchronizer;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Assert;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.ICoreRunnable;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IPath;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.MultiStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;

public class Synchronizer
implements ISynchronizer {
    protected Workspace workspace;
    protected SyncInfoWriter writer;
    protected Set<QualifiedName> registry = new HashSet<QualifiedName>(5);

    public Synchronizer(Workspace workspace) {
        this.workspace = workspace;
        this.writer = new SyncInfoWriter(workspace, this);
    }

    @Override
    public void accept(QualifiedName partner, IResource resource, IResourceVisitor visitor, int depth) throws CoreException {
        IResource[] children;
        Assert.isLegal(partner != null);
        Assert.isLegal(resource != null);
        Assert.isLegal(visitor != null);
        if (this.getSyncInfo(partner, resource) != null && !visitor.visit(resource)) {
            return;
        }
        if (depth == 0 || resource.getType() == 1) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] iResourceArray = children = ((IContainer)resource).members();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            this.accept(partner, element, visitor, depth);
            ++n2;
        }
    }

    @Override
    public void add(QualifiedName partner) {
        Assert.isLegal(partner != null);
        this.registry.add(partner);
    }

    @Override
    public void flushSyncInfo(QualifiedName partner, IResource root, int depth) throws CoreException {
        Assert.isLegal(partner != null);
        Assert.isLegal(root != null);
        ICoreRunnable body = monitor -> {
            IResourceVisitor visitor = resource -> {
                if (this.getSyncInfo(partner, resource) != null) {
                    this.setSyncInfo(partner, resource, null);
                }
                return true;
            };
            root.accept(visitor, depth, true);
        };
        this.workspace.run(body, (ISchedulingRule)root, 0, null);
    }

    @Override
    public QualifiedName[] getPartners() {
        return this.registry.toArray(new QualifiedName[this.registry.size()]);
    }

    protected Set<QualifiedName> getRegistry() {
        return this.registry;
    }

    @Override
    public byte[] getSyncInfo(QualifiedName partner, IResource resource) throws CoreException {
        Assert.isLegal(partner != null);
        Assert.isLegal(resource != null);
        if (!this.isRegistered(partner)) {
            String message = NLS.bind(Messages.synchronizer_partnerNotRegistered, partner);
            throw new ResourceException(new ResourceStatus(375, message));
        }
        ResourceInfo info = this.workspace.getResourceInfo(resource.getFullPath(), true, false);
        return info == null ? null : info.getSyncInfo(partner, true);
    }

    protected boolean isRegistered(QualifiedName partner) {
        Assert.isLegal(partner != null);
        return this.registry.contains(partner);
    }

    public void readPartners(DataInputStream input) throws CoreException {
        SyncInfoReader reader = new SyncInfoReader(this.workspace, this);
        reader.readPartners(input);
    }

    public void restore(IResource resource, IProgressMonitor monitor) throws CoreException {
        this.restoreFromSave(resource);
        this.restoreFromSnap(resource);
    }

    protected void restoreFromSave(IResource resource) throws CoreException {
        IPath sourceLocation = this.workspace.getMetaArea().getSyncInfoLocationFor(resource);
        IPath tempLocation = this.workspace.getMetaArea().getBackupLocationFor(sourceLocation);
        if (!sourceLocation.toFile().exists() && !tempLocation.toFile().exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DataInputStream input = new DataInputStream(new SafeFileInputStream(sourceLocation.toOSString(), tempLocation.toOSString()));){
                SyncInfoReader reader = new SyncInfoReader(this.workspace, this);
                reader.readSyncInfo(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String msg = NLS.bind(Messages.resources_readMeta, sourceLocation);
            throw new ResourceException(567, sourceLocation, msg, e);
        }
    }

    protected void restoreFromSnap(IResource resource) {
        IPath sourceLocation = this.workspace.getMetaArea().getSyncInfoSnapshotLocationFor(resource);
        if (!sourceLocation.toFile().exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                DataInputStream input = new DataInputStream(new SafeChunkyInputStream(sourceLocation.toFile()));
                try {
                    SyncInfoSnapReader reader = new SyncInfoSnapReader(this.workspace, this);
                    while (true) {
                        reader.readSyncInfo(input);
                    }
                }
                catch (Throwable throwable2) {
                    if (input != null) {
                        input.close();
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception e) {
            String msg = NLS.bind(Messages.resources_readMeta, sourceLocation);
            Policy.log(new ResourceStatus(567, sourceLocation, msg, (Throwable)e));
        }
    }

    @Override
    public void remove(QualifiedName partner) {
        Assert.isLegal(partner != null);
        if (this.isRegistered(partner)) {
            try {
                this.flushSyncInfo(partner, this.workspace.getRoot(), 2);
                this.registry.remove(partner);
            }
            catch (CoreException e) {
                Policy.log(e);
            }
        }
    }

    public void savePartners(DataOutputStream output) throws IOException {
        this.writer.savePartners(output);
    }

    public void saveSyncInfo(ResourceInfo info, IPathRequestor requestor, DataOutputStream output, List<QualifiedName> writtenPartners) throws IOException {
        this.writer.saveSyncInfo(info, requestor, output, writtenPartners);
    }

    protected void setRegistry(Set<QualifiedName> registry) {
        this.registry = registry;
    }

    @Override
    public void setSyncInfo(QualifiedName partner, IResource resource, byte[] info) throws CoreException {
        Assert.isLegal(partner != null);
        Assert.isLegal(resource != null);
        try {
            this.workspace.prepareOperation(resource, null);
            this.workspace.beginOperation(true);
            if (!this.isRegistered(partner)) {
                String message = NLS.bind(Messages.synchronizer_partnerNotRegistered, partner);
                throw new ResourceException(new ResourceStatus(375, message));
            }
            if (resource.getType() == 8) {
                return;
            }
            Resource target = (Resource)resource;
            ResourceInfo resourceInfo = this.workspace.getResourceInfo(target.getFullPath(), true, false);
            int flags = target.getFlags(resourceInfo);
            if (!target.exists(flags, false)) {
                if (info == null) {
                    return;
                }
                target.checkValidPath(target.getFullPath(), target.getType(), false);
                Container parent = (Container)target.getParent();
                parent.checkAccessible(parent.getFlags(parent.getResourceInfo(true, false)));
                this.workspace.createResource((IResource)target, true);
            }
            resourceInfo = target.getResourceInfo(true, true);
            resourceInfo.setSyncInfo(partner, info);
            resourceInfo.incrementSyncInfoGenerationCount();
            resourceInfo.set(8192);
            flags = target.getFlags(resourceInfo);
            if (target.isPhantom(flags) && resourceInfo.getSyncInfo(false) == null) {
                MultiStatus status = new MultiStatus("org.jboss.forge.roaster._shade.org.eclipse.core.resources", 566, Messages.resources_deleteProblem, null);
                ((Resource)resource).deleteResource(false, status);
                if (!status.isOK()) {
                    throw new ResourceException(status);
                }
            }
        }
        finally {
            this.workspace.endOperation(resource, false);
        }
    }

    public void snapSyncInfo(ResourceInfo info, IPathRequestor requestor, DataOutputStream output) throws IOException {
        this.writer.snapSyncInfo(info, requestor, output);
    }
}

