/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.internal.resources;

import java.util.Arrays;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Platform;

public abstract class OS {
    private static final String INSTALLED_PLATFORM = Platform.getOS();
    public static final char[] INVALID_RESOURCE_CHARACTERS;
    private static final String[] INVALID_RESOURCE_BASENAMES;
    private static final String[] INVALID_RESOURCE_FULLNAMES;

    static {
        if (INSTALLED_PLATFORM.equals("win32")) {
            char[] cArray = new char[41];
            cArray[0] = 92;
            cArray[1] = 47;
            cArray[2] = 58;
            cArray[3] = 42;
            cArray[4] = 63;
            cArray[5] = 34;
            cArray[6] = 60;
            cArray[7] = 62;
            cArray[8] = 124;
            cArray[10] = '\u0001';
            cArray[11] = 2;
            cArray[12] = 3;
            cArray[13] = 4;
            cArray[14] = 5;
            cArray[15] = 6;
            cArray[16] = 7;
            cArray[17] = 8;
            cArray[18] = 9;
            cArray[19] = 10;
            cArray[20] = 11;
            cArray[21] = 12;
            cArray[22] = 13;
            cArray[23] = 14;
            cArray[24] = 15;
            cArray[25] = 16;
            cArray[26] = 17;
            cArray[27] = 18;
            cArray[28] = 19;
            cArray[29] = 20;
            cArray[30] = 21;
            cArray[31] = 22;
            cArray[32] = 23;
            cArray[33] = 24;
            cArray[34] = 25;
            cArray[35] = 26;
            cArray[36] = 27;
            cArray[37] = 28;
            cArray[38] = 29;
            cArray[39] = 30;
            cArray[40] = 31;
            INVALID_RESOURCE_CHARACTERS = cArray;
            INVALID_RESOURCE_BASENAMES = new String[]{"aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
            Arrays.sort(INVALID_RESOURCE_BASENAMES);
            INVALID_RESOURCE_FULLNAMES = new String[]{"clock$"};
        } else {
            char[] cArray = new char[2];
            cArray[0] = 47;
            INVALID_RESOURCE_CHARACTERS = cArray;
            INVALID_RESOURCE_BASENAMES = null;
            INVALID_RESOURCE_FULLNAMES = null;
        }
    }

    public static boolean isNameValid(String name) {
        if (name.equals(".") || name.equals("..")) {
            return false;
        }
        if (INSTALLED_PLATFORM.equals("win32")) {
            String basename;
            int length = name.length();
            if (length == 0) {
                return false;
            }
            char lastChar = name.charAt(length - 1);
            if (lastChar == '.') {
                return false;
            }
            if (Character.isWhitespace(lastChar)) {
                return false;
            }
            int dot = name.indexOf(46);
            String string = basename = dot == -1 ? name : name.substring(0, dot);
            if (Arrays.binarySearch(INVALID_RESOURCE_BASENAMES, basename.toLowerCase()) >= 0) {
                return false;
            }
            return Arrays.binarySearch(INVALID_RESOURCE_FULLNAMES, name.toLowerCase()) < 0;
        }
        return true;
    }
}

