/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.source;

import java.util.Arrays;
import java.util.List;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.MethodHolder;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MemberHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.util.Types;

public interface MethodHolderSource<O extends JavaSource<O>>
extends MethodHolder<O>,
MemberHolderSource<O> {
    default public MethodSource<O> getMethod(String name) {
        for (MethodSource<O> method : this.getMethods()) {
            if (!method.getName().equals(name) || method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    default public MethodSource<O> getMethod(String name, String ... paramTypes) {
        for (MethodSource<O> local : this.getMethods()) {
            if (!local.getName().equals(name)) continue;
            List<ParameterSource<O>> localParams = local.getParameters();
            if (paramTypes == null || localParams.size() != paramTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < localParams.size(); ++i) {
                ParameterSource<O> localParam = localParams.get(i);
                String type = paramTypes[i];
                if (Types.areEquivalent(localParam.getType().getName(), type)) continue;
                matches = false;
            }
            if (!matches) continue;
            return local;
        }
        return null;
    }

    default public MethodSource<O> getMethod(String name, Class<?> ... paramTypes) {
        String[] types = paramTypes == null ? new String[]{} : (String[])Arrays.stream(paramTypes).map(Class::getName).toArray(String[]::new);
        return this.getMethod(name, types);
    }

    @Override
    public List<MethodSource<O>> getMethods();

    public MethodSource<O> addMethod();

    public MethodSource<O> addMethod(String var1);

    public MethodSource<O> addMethod(java.lang.reflect.Method var1);

    public MethodSource<O> addMethod(Method<?, ?> var1);

    public O removeMethod(Method<O, ?> var1);
}

