/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.visit;

import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;

public class ResourceVisit {
    private final Resource<?> root;
    private final VisitContextImpl context = new VisitContextImpl();
    private final ResourceFilter acceptAll = new ResourceFilter(){

        public boolean accept(Resource<?> resource) {
            return true;
        }
    };

    public ResourceVisit(Resource<?> root) {
        this.root = root;
    }

    public void perform(ResourceVisitor visitor) {
        this.perform(this.root, visitor, this.acceptAll, this.acceptAll);
    }

    public void perform(ResourceVisitor visitor, ResourceFilter filter) {
        this.perform(this.root, visitor, this.acceptAll, filter);
    }

    public void perform(ResourceVisitor visitor, ResourceFilter recurseFilter, ResourceFilter visitFilter) {
        this.perform(this.root, visitor, recurseFilter, visitFilter);
    }

    private void perform(Resource<?> root, ResourceVisitor visitor, ResourceFilter recurseFilter, ResourceFilter visitFilter) {
        this.perform(root, this.context, visitor, recurseFilter, visitFilter);
    }

    private void perform(Resource<?> root, VisitContextImpl context, ResourceVisitor visitor, ResourceFilter recurseFilter, ResourceFilter visitFilter) {
        if (!context.isTerminated()) {
            if (visitFilter.accept(root)) {
                visitor.visit(context, root);
            }
            if (recurseFilter.accept(root)) {
                for (Resource<?> child : root.listResources()) {
                    this.perform(child, visitor, recurseFilter, visitFilter);
                    if (!context.isTerminated()) continue;
                    break;
                }
            }
        }
    }

    public boolean isTerminated() {
        return this.context.isTerminated();
    }

    private static class VisitContextImpl
    implements VisitContext {
        private boolean terminated;

        private VisitContextImpl() {
        }

        @Override
        public void terminate() {
            this.terminated = true;
        }

        boolean isTerminated() {
            return this.terminated;
        }
    }
}

