/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;

import java.lang.reflect.Method;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.util.Classes;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.MapEntry;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtUtil;

public class RtCharactersHandler
extends CharactersHandler {
    public static final RtCharactersHandler INSTANCE = new RtCharactersHandler();

    public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
        Object unmarshalled = null;
        if (valueMetaData != null) {
            Object[] objectArray;
            Method unmarshalMethod = RtUtil.getUnmarshalMethod(qName, valueMetaData);
            if (unmarshalMethod.getParameterTypes().length == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = value;
                objectArray = objectArray3;
                objectArray3[1] = nsCtx;
            }
            Object[] args = objectArray;
            unmarshalled = RtUtil.invokeUnmarshalMethod(unmarshalMethod, args, qName);
        } else {
            unmarshalled = super.unmarshal(qName, typeBinding, nsCtx, valueMetaData, value);
            if (typeBinding.isSimple()) {
                Class cls;
                String clsName = null;
                boolean failIfNotFound = false;
                if (typeBinding.getClassMetaData() != null) {
                    clsName = typeBinding.getClassMetaData().getImpl();
                    failIfNotFound = true;
                } else {
                    QName typeName = typeBinding.getQName();
                    if (typeName != null && !"http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI())) {
                        boolean ignoreLowLine = typeBinding.getSchemaBinding() != null ? typeBinding.getSchemaBinding().isIgnoreLowLine() : true;
                        clsName = Util.xmlNameToClassName(typeName.getNamespaceURI(), typeName.getLocalPart(), ignoreLowLine);
                    }
                }
                Class clazz = cls = clsName == null ? null : RtUtil.loadClass(clsName, failIfNotFound);
                if (cls != null && !cls.isPrimitive()) {
                    if (cls.getConstructors().length == 0) {
                        Class valueType = unmarshalled.getClass();
                        if (Classes.isPrimitiveWrapper(valueType)) {
                            valueType = Classes.getPrimitive(valueType);
                        }
                        unmarshalled = unmarshalled == null ? null : RtUtil.invokeUnmarshalMethod(cls, "fromValue", unmarshalled, valueType, nsCtx, qName);
                    } else {
                        throw new JBossXBRuntimeException("This case is not yet supported (create a feature request): simple type (" + typeBinding.getQName() + ") is bound to a class (" + cls + ") with optional property metadata with " + "default value for the property name 'value'.");
                    }
                }
            }
        }
        return unmarshalled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(QName qName, ElementBinding element, Object owner, Object value) {
        if (owner == null) {
            return;
        }
        if (owner instanceof MapEntry) {
            TypeBinding type = element.getType();
            CharactersMetaData characters = type.getCharactersMetaData();
            if (characters == null) throw new JBossXBRuntimeException("Parent object is a map entry but characters of element " + qName + " of type " + type.getQName() + " were bound to niether key nor value in a map entry.");
            if (characters.isMapEntryKey()) {
                ((MapEntry)owner).setKey(value);
                return;
            } else {
                if (!characters.isMapEntryValue()) throw new JBossXBRuntimeException("Parent object is a map entry but characters of element " + qName + " of type " + type.getQName() + " were bound to niether key nor value in a map entry.");
                ((MapEntry)owner).setValue(value);
            }
            return;
        } else {
            String propName = null;
            String colType = null;
            TypeBinding type = element.getType();
            if (type != null && !type.isSimple()) {
                PropertyMetaData propertyMetaData = type.getPropertyMetaData();
                if (propertyMetaData == null) {
                    CharactersMetaData charactersMetaData = type.getCharactersMetaData();
                    PropertyMetaData propertyMetaData2 = propertyMetaData = charactersMetaData == null ? null : charactersMetaData.getProperty();
                }
                if (propertyMetaData != null) {
                    propName = propertyMetaData.getName();
                    colType = propertyMetaData.getCollectionType();
                }
                if (propName == null) {
                    propName = type.getSchemaBinding().getSimpleContentProperty();
                }
            } else {
                PropertyMetaData PropertyMetaData2 = element.getPropertyMetaData();
                if (PropertyMetaData2 != null) {
                    propName = PropertyMetaData2.getName();
                    colType = PropertyMetaData2.getCollectionType();
                }
                if (propName == null) {
                    propName = Util.xmlNameToFieldName(qName.getLocalPart(), element.getSchema().isIgnoreLowLine());
                }
            }
            RtUtil.set(owner, value, propName, colType, element.getSchema().isIgnoreUnresolvedFieldOrClass(), element.getValueAdapter());
        }
    }
}

