/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class NamespaceRegistry
implements NamespaceContext,
Serializable {
    private static final long serialVersionUID = 8435680858785550261L;
    private int namespaceIndex;
    private final Map prefixByUri = new HashMap();
    private final Map uriByPrefix = new HashMap();

    public QName registerQName(QName qname) {
        if (qname == null) {
            return null;
        }
        String nsURI = qname.getNamespaceURI();
        String prefix = this.getPrefix(nsURI);
        if (prefix == null) {
            prefix = qname.getPrefix();
            prefix = prefix.length() == 0 ? this.registerURI(nsURI, null) : this.registerURI(nsURI, prefix);
        }
        qname = new QName(nsURI, qname.getLocalPart(), prefix);
        return qname;
    }

    public String registerURI(String nsURI, String prefix) {
        if (prefix == null) {
            prefix = "ns" + ++this.namespaceIndex;
        }
        this.addPrefixMapping(prefix, nsURI);
        return prefix;
    }

    public void addPrefixMapping(String prefix, String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("Cannot add mapping for null namespace URI");
        }
        Object obj = this.uriByPrefix.get(prefix);
        if (!nsURI.equals(obj)) {
            ArrayList<Object> list2;
            if (obj == null) {
                this.uriByPrefix.put(prefix, nsURI);
            } else if (obj instanceof String) {
                list2 = new ArrayList<Object>();
                list2.add(obj);
                list2.add(nsURI);
                this.uriByPrefix.put(prefix, list2);
            } else if (obj instanceof List) {
                ((List)obj).add(nsURI);
            } else {
                this.throwUnexpectedEntryException(obj);
            }
            obj = this.prefixByUri.get(nsURI);
            if (obj == null) {
                this.prefixByUri.put(nsURI, prefix);
            } else if (obj instanceof String) {
                list2 = new ArrayList();
                list2.add(obj);
                list2.add(prefix);
                this.prefixByUri.put(nsURI, list2);
            } else if (obj instanceof List) {
                ((List)obj).add(prefix);
            } else {
                this.throwUnexpectedEntryException(obj);
            }
        }
    }

    public void removePrefixMapping(String prefix) {
        Object obj = this.uriByPrefix.get(prefix);
        if (obj != null) {
            List list2;
            String uri = null;
            if (obj instanceof String) {
                uri = (String)obj;
                this.uriByPrefix.remove(prefix);
            } else if (obj instanceof List) {
                list2 = (List)obj;
                uri = (String)list2.remove(list2.size() - 1);
                if (list2.isEmpty()) {
                    this.uriByPrefix.remove(prefix);
                }
            } else {
                this.throwUnexpectedEntryException(obj);
            }
            if (uri != null) {
                obj = this.prefixByUri.get(uri);
                if (obj instanceof String) {
                    if (!prefix.equals(obj)) {
                        throw new IllegalStateException("Inconsistent mapping: prefix=" + prefix + ", found=" + obj);
                    }
                    this.prefixByUri.remove(uri);
                } else if (obj instanceof List) {
                    list2 = (ArrayList)obj;
                    list2.remove(prefix);
                    if (list2.isEmpty()) {
                        this.prefixByUri.remove(uri);
                    }
                } else {
                    this.throwUnexpectedEntryException(obj);
                }
            }
        }
    }

    public void unregisterURI(String nsURI) {
        Object obj = this.prefixByUri.get(nsURI);
        if (obj != null) {
            String prefix = null;
            if (obj instanceof String) {
                prefix = (String)obj;
                this.prefixByUri.remove(nsURI);
                this.removePrefixMappingOnly(prefix, nsURI);
            } else if (obj instanceof List) {
                List list2 = (List)obj;
                int i = 0;
                while (i < list2.size()) {
                    this.removePrefixMappingOnly((String)list2.get(i), nsURI);
                    ++i;
                }
                this.prefixByUri.remove(nsURI);
            } else {
                this.throwUnexpectedEntryException(obj);
            }
        }
    }

    public boolean isRegistered(String nsURI) {
        return this.prefixByUri.containsKey(nsURI);
    }

    public Iterator getRegisteredURIs() {
        return this.prefixByUri.keySet().iterator();
    }

    public Iterator getRegisteredPrefixes() {
        return this.uriByPrefix.keySet().iterator();
    }

    public int size() {
        return this.prefixByUri.size();
    }

    public String getPrefix(String nsURI) {
        Object obj = this.prefixByUri.get(nsURI);
        String prefix = null;
        if (obj != null) {
            if (obj instanceof String) {
                prefix = (String)obj;
            } else if (obj instanceof List) {
                List list2 = (List)obj;
                prefix = (String)list2.get(list2.size() - 1);
            } else {
                this.throwUnexpectedEntryException(obj);
            }
        }
        return prefix;
    }

    public Iterator getPrefixes(String namespaceURI) {
        Object obj = this.prefixByUri.get(namespaceURI);
        Iterator<Object> result = null;
        if (obj == null) {
            result = Collections.EMPTY_LIST.iterator();
        } else if (obj instanceof String) {
            result = Collections.singletonList(obj).iterator();
        } else if (obj instanceof List) {
            result = ((List)obj).iterator();
        } else {
            this.throwUnexpectedEntryException(obj);
        }
        return result;
    }

    public String getNamespaceURI(String prefix) {
        Object obj = this.uriByPrefix.get(prefix);
        String uri = null;
        if (obj != null) {
            if (obj instanceof String) {
                uri = (String)obj;
            } else if (obj instanceof List) {
                List list2 = (List)obj;
                uri = (String)list2.get(list2.size() - 1);
            } else {
                this.throwUnexpectedEntryException(obj);
            }
        }
        return uri;
    }

    private void removePrefixMappingOnly(String prefix, String nsURI) {
        Object obj = this.uriByPrefix.get(prefix);
        if (obj instanceof String) {
            if (!obj.equals(nsURI)) {
                throw new IllegalStateException("Inconsistent mapping: uri=" + nsURI + ", found=" + obj);
            }
            this.uriByPrefix.remove(prefix);
        } else if (obj instanceof List) {
            List list2 = (List)obj;
            list2.remove(prefix);
            if (list2.isEmpty()) {
                this.uriByPrefix.remove(prefix);
            }
        }
    }

    private void throwUnexpectedEntryException(Object entry) {
        throw new IllegalStateException("Unexpected entry type: expected java.lang.String or java.util.List but got " + entry.getClass());
    }
}

