/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import javax.ejb.Stateless;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.integration.ResourceLoaderAdapter;
import org.jboss.ws.metadata.builder.jaxws.JAXWSWebServiceMetaDataBuilder;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.tools.jaxws.api.WSContractProvider;
import org.jboss.ws.tools.jaxws.impl.BytecodeWrapperGenerator;
import org.jboss.ws.tools.jaxws.impl.ChainedWritableWrapperGenerator;
import org.jboss.ws.tools.jaxws.impl.NullPrintStream;
import org.jboss.ws.tools.jaxws.impl.SourceWrapperGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WSContractProviderImpl
extends WSContractProvider {
    private ClassLoader loader;
    private boolean generateWsdl = false;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File resourceDir = null;
    private File sourceDir = null;
    private PrintStream messageStream = new NullPrintStream();

    WSContractProviderImpl() {
    }

    private void createDirectories(File resourceDir, File sourceDir) {
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new WSException("Could not create directory: " + this.outputDir);
        }
        if (this.generateWsdl && !resourceDir.exists() && !resourceDir.mkdirs()) {
            throw new WSException("Could not create directory: " + resourceDir);
        }
        if (this.generateSource && !sourceDir.exists() && !sourceDir.mkdirs()) {
            throw new WSException("Could not create directory: " + sourceDir);
        }
    }

    private UnifiedDeploymentInfo createUDI(Class<?> endpointClass, ClassLoader loader) {
        UnifiedDeploymentInfo.DeploymentType type = endpointClass.isAnnotationPresent(Stateless.class) ? UnifiedDeploymentInfo.DeploymentType.JAXWS_EJB3 : UnifiedDeploymentInfo.DeploymentType.JAXWS_JSE;
        UnifiedDeploymentInfo udi = new UnifiedDeploymentInfo(type){

            public URL getMetaDataFileURL(String resourcePath) throws IOException {
                return null;
            }
        };
        udi.classLoader = loader;
        return udi;
    }

    @Override
    public void provide(Class<?> endpointClass) {
        File resourceDir = this.resourceDir != null ? this.resourceDir : this.outputDir;
        File sourceDir = this.sourceDir != null ? this.sourceDir : this.outputDir;
        this.createDirectories(resourceDir, sourceDir);
        URLClassLoader loader = new URLClassLoader(new URL[0], this.loader);
        UnifiedMetaData umd = new UnifiedMetaData(new ResourceLoaderAdapter(loader));
        umd.setClassLoader(loader);
        ChainedWritableWrapperGenerator generator = new ChainedWritableWrapperGenerator();
        if (this.generateSource) {
            generator.add(new SourceWrapperGenerator(loader, this.messageStream), sourceDir);
        }
        generator.add(new BytecodeWrapperGenerator(loader, this.messageStream), this.outputDir);
        JAXWSWebServiceMetaDataBuilder builder = new JAXWSWebServiceMetaDataBuilder();
        builder.setWrapperGenerator(generator);
        builder.setGenerateWsdl(this.generateWsdl);
        builder.setToolMode(true);
        builder.setWsdlDirectory(resourceDir);
        builder.setMessageStream(this.messageStream);
        if (this.generateWsdl) {
            this.messageStream.println("Generating WSDL:");
        }
        UnifiedDeploymentInfo udi = this.createUDI(endpointClass, loader);
        builder.buildWebServiceMetaData(umd, udi, endpointClass, null);
        try {
            generator.write();
        }
        catch (IOException io) {
            throw new WSException("Could not write output files:", io);
        }
    }

    @Override
    public void provide(String endpointClass) {
        try {
            this.provide(this.loader.loadClass(endpointClass));
        }
        catch (ClassNotFoundException e) {
            throw new WSException("Class not found: " + endpointClass);
        }
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void setGenerateWsdl(boolean generateWsdl) {
        this.generateWsdl = generateWsdl;
    }

    @Override
    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    @Override
    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    @Override
    public void setResourceDirectory(File directory) {
        this.resourceDir = directory;
    }

    @Override
    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    @Override
    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }
}

