/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.ws.tools.jaxws.api.WSContractProvider;

public class wsprovide
extends Task {
    private Path classpath = new Path(this.getProject());
    private CommandlineJava command = new CommandlineJava();
    private String sei = null;
    private File destdir = null;
    private File resourcedestdir = null;
    private File sourcedestdir = null;
    private boolean keep = false;
    private boolean genwsdl = false;
    private boolean verbose = false;
    private boolean fork = false;
    private boolean debug = false;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Commandline.Argument createJvmarg() {
        return this.command.createVmArgument();
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public Path createClasspath() {
        return this.classpath;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public void setSei(String sei) {
        this.sei = sei;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setResourcedestdir(File resourcedestdir) {
        this.resourcedestdir = resourcedestdir;
    }

    public void setSourcedestdir(File sourcedestdir) {
        this.sourcedestdir = sourcedestdir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setGenwsdl(boolean genwsdl) {
        this.genwsdl = genwsdl;
    }

    private ClassLoader getClasspathLoader(ClassLoader parent) {
        return new AntClassLoader(parent, this.getProject(), this.classpath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNonForked() {
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        ClassLoader antLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(antLoader);
        try {
            WSContractProvider gen = WSContractProvider.newInstance();
            gen.setClassLoader(this.getClasspathLoader(antLoader));
            if (this.verbose) {
                gen.setMessageStream(new PrintStream((OutputStream)new LogOutputStream((Task)this, 2)));
            }
            gen.setGenerateSource(this.keep);
            gen.setGenerateWsdl(this.genwsdl);
            if (this.destdir != null) {
                gen.setOutputDirectory(this.destdir);
            }
            if (this.resourcedestdir != null) {
                gen.setResourceDirectory(this.resourcedestdir);
            }
            if (this.sourcedestdir != null) {
                gen.setSourceDirectory(this.sourcedestdir);
            }
            if (this.verbose) {
                this.log("Generating from endpoint: " + this.sei, 2);
            }
            gen.provide(this.sei);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCL);
        }
    }

    public void execute() throws BuildException {
        if (this.sei == null) {
            throw new BuildException("The sei attribute must be specified!", this.getLocation());
        }
        if (this.fork) {
            this.executeForked();
        } else {
            this.executeNonForked();
        }
    }

    private Path getTaskClassPath() {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl instanceof AntClassLoader) {
            return new Path(this.getProject(), ((AntClassLoader)cl).getClasspath());
        }
        return new Path(this.getProject());
    }

    private void executeForked() throws BuildException {
        this.command.setClassname(org.jboss.ws.tools.jaxws.command.wsprovide.class.getName());
        Path path = this.command.createClasspath(this.getProject());
        path.append(this.getTaskClassPath());
        path.append(this.classpath);
        if (this.keep) {
            this.command.createArgument().setValue("-k");
        }
        if (this.genwsdl) {
            this.command.createArgument().setValue("-w");
        }
        if (this.destdir != null) {
            this.command.createArgument().setValue("-o");
            this.command.createArgument().setFile(this.destdir);
        }
        if (this.resourcedestdir != null) {
            this.command.createArgument().setValue("-r");
            this.command.createArgument().setFile(this.resourcedestdir);
        }
        if (this.sourcedestdir != null) {
            this.command.createArgument().setValue("-s");
            this.command.createArgument().setFile(this.sourcedestdir);
        }
        if (!this.verbose) {
            this.command.createArgument().setValue("-q");
        }
        this.command.createArgument().setValue("-t");
        this.command.createArgument().setValue(this.sei);
        if (this.verbose) {
            this.log("Command invoked: " + this.command.getJavaCommand().toString());
        }
        ExecuteJava execute = new ExecuteJava();
        execute.setClasspath(path);
        execute.setJavaCommand(this.command.getJavaCommand());
        if (execute.fork((ProjectComponent)this) != 0) {
            throw new BuildException("Could not invoke wsprovide", this.getLocation());
        }
    }
}

