/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.util.Iterator;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;

public class JAXWSMetaDataBuilderEJB3 {
    private final Logger log = Logger.getLogger(JAXWSMetaDataBuilderEJB3.class);
    protected Class annotatedClass;

    public UnifiedMetaData buildMetaData(UnifiedDeploymentInfo udi) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("START buildMetaData: [name=" + udi.getCanonicalName() + "]");
        }
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData(udi.vfRoot);
            wsMetaData.setDeploymentName(udi.getCanonicalName());
            wsMetaData.setClassLoader(udi.classLoader);
            if (udi.classLoader == null) {
                throw new WSException("Deployment class loader not initialized");
            }
            UnifiedApplicationMetaData appMetaData = (UnifiedApplicationMetaData)udi.metaData;
            Iterator<UnifiedBeanMetaData> it = appMetaData.getEnterpriseBeans();
            while (it.hasNext()) {
                UnifiedBeanMetaData beanMetaData = it.next();
                String ejbClassName = beanMetaData.getEjbClass();
                Class<?> beanClass = udi.classLoader.loadClass(ejbClassName);
                if (!beanClass.isAnnotationPresent(WebService.class) && !beanClass.isAnnotationPresent(WebServiceProvider.class)) continue;
                String ejbLink = beanMetaData.getEjbName();
                JAXWSServerMetaDataBuilder.setupProviderOrWebService(wsMetaData, udi, beanClass, ejbLink);
                if (!beanClass.isAnnotationPresent(SecurityDomain.class)) continue;
                SecurityDomain anSecurityDomain = beanClass.getAnnotation(SecurityDomain.class);
                String lastDomain = wsMetaData.getSecurityDomain();
                String securityDomain = anSecurityDomain.value();
                if (lastDomain != null && !lastDomain.equals(securityDomain)) {
                    throw new IllegalStateException("Multiple security domains not supported: " + securityDomain);
                }
                wsMetaData.setSecurityDomain(securityDomain);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("END buildMetaData: " + wsMetaData);
            }
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

