/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.xop.jaxrpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
import org.jboss.ws.core.soap.attachment.SwapableMemoryDataSource;
import org.jboss.ws.core.utils.IOUtils;
import org.jboss.ws.core.utils.MimeUtils;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.sunday.marshalling.MarshallingContext;
import org.jboss.xb.binding.sunday.marshalling.TermBeforeMarshallingCallback;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.UnmarshallingContext;

public class JBossXBContentAdapter
implements TermBeforeMarshallingCallback,
TermBeforeSetParentCallback {
    private static final Logger log = Logger.getLogger(JBossXBContentAdapter.class);
    private static final QName XMIME_BASE_64 = new QName("http://www.w3.org/2005/05/xmlmime", "base64Binary");
    private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");

    public Object beforeMarshalling(Object object, MarshallingContext marshallingContext) {
        boolean convertableType;
        boolean mtomDisabled = !XOPContext.isMTOMEnabled();
        boolean bl = convertableType = object != null && !(object instanceof byte[]);
        if (mtomDisabled && convertableType) {
            String contentType = MimeUtils.resolveMimeType(object);
            if (log.isDebugEnabled()) {
                log.debug("Adopt " + object.getClass() + " to byte[], contentType " + contentType);
            }
            DataHandler dh = new DataHandler(object, contentType);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                IOUtils.copyStream(bout, dh.getInputStream());
                object = bout.toByteArray();
            }
            catch (IOException e) {
                throw new WSException("Failed to adopt XOP content type", e);
            }
        }
        return object;
    }

    public Object beforeSetParent(Object object, UnmarshallingContext ctx) {
        if (null == object) {
            return object;
        }
        Class targetClass = ctx.resolvePropertyType();
        if (null == targetClass) {
            throw new WSException("Failed to resolve target property type on " + ctx.getParticle());
        }
        boolean isRegularMessage = !XOPContext.isXOPMessage();
        boolean isSimpleType = object instanceof byte[];
        boolean doTypesMatch = targetClass.equals(object.getClass());
        if (isRegularMessage && isSimpleType && !doTypesMatch) {
            String contentType = MimeUtils.resolveMimeType(targetClass);
            if (log.isDebugEnabled()) {
                log.debug("Adopt byte[] to " + targetClass + ", contentType " + contentType);
            }
            try {
                DataHandler dh = new DataHandler(this.wrapAsDataSource(object, contentType));
                if (targetClass.equals(DataHandler.class)) {
                    object = dh;
                }
                object = dh.getContent();
            }
            catch (IOException e) {
                throw new WSException("Failed to adopt XOP content type", e);
            }
        } else if (XOPContext.isXOPMessage() && object instanceof DataHandler && !doTypesMatch) {
            try {
                DataHandler dh;
                String contentType = MimeUtils.resolveMimeType(targetClass);
                if (log.isDebugEnabled()) {
                    log.debug("Adopt DataHandler to " + targetClass + ", contentType " + contentType);
                }
                if ((object = (dh = new DataHandler(this.wrapAsDataSource(object, contentType))).getContent()) instanceof InputStream) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    dh.writeTo((OutputStream)bout);
                    object = bout.toByteArray();
                }
            }
            catch (IOException e) {
                throw new WSException("Failed to adopt XOP content type", e);
            }
        }
        return object;
    }

    private DataSource wrapAsDataSource(Object object, String contentType) throws IOException {
        SwapableMemoryDataSource ds;
        if (object instanceof byte[]) {
            ds = new SwapableMemoryDataSource(new ByteArrayInputStream((byte[])object), contentType);
        } else if (object instanceof DataHandler) {
            ds = new SwapableMemoryDataSource(((DataHandler)object).getInputStream(), contentType);
        } else {
            throw new IllegalArgumentException("Failed to wrap as data source: " + object.getClass());
        }
        return ds;
    }

    public static void register(SchemaBinding schemaBinding) {
        JBossXBContentAdapter contentAdapter = new JBossXBContentAdapter();
        TypeBinding base64Type = schemaBinding.getType(Constants.QNAME_BASE64BINARY);
        base64Type.setBeforeMarshallingCallback(contentAdapter);
        base64Type.setBeforeSetParentCallback(contentAdapter);
        TypeBinding xmimeBase64Type = schemaBinding.getType(XMIME_BASE_64);
        if (xmimeBase64Type != null) {
            xmimeBase64Type.setBeforeMarshallingCallback(contentAdapter);
            xmimeBase64Type.setBeforeSetParentCallback(contentAdapter);
        }
    }

    static {
        ContentHandlerRegistry.register();
    }
}

