/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.Metadata;
import javax.xml.ws.addressing.ReferenceParameters;
import org.jboss.ws.WSException;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.AttributeElementExtensibleImpl;
import org.jboss.ws.extensions.addressing.AttributedURIImpl;
import org.jboss.ws.extensions.addressing.MetadataImpl;
import org.jboss.ws.extensions.addressing.ReferenceParametersImpl;
import org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReferenceImpl
extends AttributeElementExtensibleImpl
implements EndpointReference {
    private static AddressingConstants ADDR = new AddressingConstantsImpl();
    private QName rootQName = new QName(ADDR.getNamespaceURI(), "EndpointReference", ADDR.getNamespacePrefix());
    private AttributedURIImpl address = new AttributedURIImpl(ADDR.getAnonymousURI());
    private ReferenceParametersImpl refParams = new ReferenceParametersImpl();
    private MetadataImpl metadata = new MetadataImpl();

    public EndpointReferenceImpl(URI uri) {
        this.address = new AttributedURIImpl(uri);
    }

    public EndpointReferenceImpl(Element elRoot) {
        this.initFromElement(elRoot);
    }

    public QName getRootQName() {
        return this.rootQName;
    }

    public void setRootQName(QName rootElementName) {
        this.rootQName = rootElementName;
    }

    @Override
    public AttributedURI getAddress() {
        return this.address;
    }

    @Override
    public ReferenceParameters getReferenceParameters() {
        return this.refParams;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    private void initFromElement(Element elRoot) {
        if (elRoot == null) {
            throw new IllegalArgumentException("Cannot initialize from null element");
        }
        try {
            Map attributes = DOMUtils.getAttributes(elRoot);
            for (QName attqname : attributes.keySet()) {
                String value = (String)attributes.get(attqname);
                this.addAttribute(attqname, value);
            }
            Iterator it = DOMUtils.getChildElements(elRoot);
            while (it.hasNext()) {
                Element child;
                Iterator itel;
                String value;
                Element el = (Element)it.next();
                QName qname = DOMUtils.getElementQName(el);
                if (qname.equals(ADDR.getAddressQName())) {
                    this.address = new AttributedURIImpl(DOMUtils.getTextContent(el));
                    attributes = DOMUtils.getAttributes(el);
                    for (QName attqname : attributes.keySet()) {
                        value = (String)attributes.get(attqname);
                        this.address.addAttribute(attqname, value);
                    }
                    continue;
                }
                if (qname.equals(ADDR.getReferenceParametersQName())) {
                    attributes = DOMUtils.getAttributes(el);
                    for (QName attqname : attributes.keySet()) {
                        value = (String)attributes.get(attqname);
                        this.refParams.addAttribute(attqname, value);
                    }
                    itel = DOMUtils.getChildElements(el);
                    while (itel.hasNext()) {
                        child = (Element)itel.next();
                        this.refParams.addElement(child);
                    }
                    continue;
                }
                if (qname.equals(ADDR.getMetadataQName())) {
                    attributes = DOMUtils.getAttributes(el);
                    for (QName attqname : attributes.keySet()) {
                        value = (String)attributes.get(attqname);
                        this.metadata.addAttribute(attqname, value);
                    }
                    itel = DOMUtils.getChildElements(el);
                    while (itel.hasNext()) {
                        child = (Element)itel.next();
                        this.metadata.addElement(child);
                    }
                    continue;
                }
                this.addElement(el);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new AddressingException("Cannot init EPR from element", ex);
        }
    }

    public Element toElement() {
        String xmlString = this.toXMLString(false);
        try {
            return DOMUtils.parse(xmlString);
        }
        catch (IOException ex) {
            throw new WSException("Cannot parse: " + xmlString, ex);
        }
    }

    public String toXMLString(boolean pretty) {
        if (pretty) {
            Element epRef = this.toElement();
            return DOMWriter.printNode(epRef, true);
        }
        SOAPAddressingBuilderImpl builder = new SOAPAddressingBuilderImpl();
        AddressingConstants ADDR = ((AddressingBuilder)builder).newAddressingConstants();
        String rootname = this.getPrefixedName(this.rootQName);
        StringBuilder xmlBuffer = new StringBuilder("<" + rootname);
        this.appendAttributes(xmlBuffer, this.getAttributes());
        xmlBuffer.append(">");
        String wsaURI = ADDR.getNamespaceURI();
        String wsaPrefix = ADDR.getNamespacePrefix();
        String wsaDeclaration = " xmlns:" + wsaPrefix + "='" + wsaURI + "'";
        if (xmlBuffer.indexOf(wsaDeclaration) < 0) {
            xmlBuffer.insert(rootname.length() + 1, wsaDeclaration);
        }
        xmlBuffer.append("<" + this.getPrefixedName(ADDR.getAddressQName()));
        this.appendAttributes(xmlBuffer, this.address.getAttributes());
        xmlBuffer.append(">");
        xmlBuffer.append(this.address.getURI() + "</" + this.getPrefixedName(ADDR.getAddressQName()) + ">");
        if (this.refParams.getElements().size() > 0 || this.refParams.getAttributes().size() > 0) {
            xmlBuffer.append("<" + this.getPrefixedName(ADDR.getReferenceParametersQName()));
            this.appendAttributes(xmlBuffer, this.refParams.getAttributes());
            xmlBuffer.append(">");
            this.appendElements(xmlBuffer, this.refParams.getElements());
            xmlBuffer.append("</" + this.getPrefixedName(ADDR.getReferenceParametersQName()) + ">");
        }
        if (this.metadata.getElements().size() > 0 || this.metadata.getAttributes().size() > 0) {
            xmlBuffer.append("<" + this.getPrefixedName(ADDR.getMetadataQName()));
            this.appendAttributes(xmlBuffer, this.metadata.getAttributes());
            xmlBuffer.append(">");
            this.appendElements(xmlBuffer, this.metadata.getElements());
            xmlBuffer.append("</" + this.getPrefixedName(ADDR.getMetadataQName()) + ">");
        }
        this.appendElements(xmlBuffer, this.getElements());
        xmlBuffer.append("</" + rootname + ">");
        String xmlString = xmlBuffer.toString();
        return xmlString;
    }

    private void appendAttributes(StringBuilder xmlBuffer, Map<QName, String> attributes) {
        for (QName qname : attributes.keySet()) {
            String qualname = this.getPrefixedName(qname);
            String value = attributes.get(qname);
            xmlBuffer.append(" " + qualname + "='" + value + "'");
        }
    }

    private void appendElements(StringBuilder xmlBuffer, List<Object> elements) {
        for (Object obj : elements) {
            if (obj instanceof Element) {
                StringWriter strwr = new StringWriter();
                DOMWriter domWriter = new DOMWriter(strwr).setCompleteNamespaces(false);
                domWriter.print((Element)obj);
                String xmlFragment = strwr.toString();
                xmlBuffer.append(xmlFragment);
                continue;
            }
            if (obj instanceof String) {
                xmlBuffer.append(obj);
                continue;
            }
            throw new AddressingException("Unsupported element: " + obj.getClass().getName());
        }
    }

    private String getPrefixedName(QName qname) {
        String prefix = qname.getPrefix();
        String localPart = qname.getLocalPart();
        String qualname = prefix != null && prefix.length() > 0 ? prefix + ":" + localPart : localPart;
        return qualname;
    }

    public String toString() {
        return this.toXMLString(true);
    }
}

