/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.ServiceEndpointInfo;
import org.jboss.ws.core.server.ServiceEndpointManager;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.core.server.WSDLFilePublisher;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCDeployment;
import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCServerMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderEJB3;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilderJSE;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;

public class ServiceEndpointDeployer {
    private static Logger log = Logger.getLogger(ServiceEndpointDeployer.class);
    public static final String BEAN_NAME = "ServiceEndpointDeployer";
    private ServiceEndpointManager epManager;
    private Map<String, UnifiedMetaData> metaDataMap = new ConcurrentHashMap<String, UnifiedMetaData>();

    public void setServiceEndpointManager(ServiceEndpointManager epManager) {
        this.epManager = epManager;
    }

    public void create(UnifiedDeploymentInfo udi) {
        if (log.isDebugEnabled()) {
            log.debug("create: " + udi.name);
        }
        try {
            UnifiedMetaData wsMetaData;
            Object builder;
            if (udi.type == UnifiedDeploymentInfo.DeploymentType.JAXRPC_JSE) {
                builder = new JAXRPCServerMetaDataBuilder();
                wsMetaData = ((JAXRPCServerMetaDataBuilder)builder).buildMetaData((JAXRPCDeployment)udi);
            } else if (udi.type == UnifiedDeploymentInfo.DeploymentType.JAXRPC_EJB21) {
                builder = new JAXRPCServerMetaDataBuilder();
                wsMetaData = ((JAXRPCServerMetaDataBuilder)builder).buildMetaData((JAXRPCDeployment)udi);
            } else if (udi.type == UnifiedDeploymentInfo.DeploymentType.JAXWS_JSE) {
                builder = new JAXWSMetaDataBuilderJSE();
                wsMetaData = ((JAXWSMetaDataBuilderJSE)builder).buildMetaData(udi);
            } else if (udi.type == UnifiedDeploymentInfo.DeploymentType.JAXWS_EJB3) {
                builder = new JAXWSMetaDataBuilderEJB3();
                wsMetaData = ((JAXWSMetaDataBuilderEJB3)builder).buildMetaData(udi);
            } else {
                throw new IllegalStateException("Invalid type:  " + (Object)((Object)udi.type));
            }
            this.metaDataMap.put(udi.name, wsMetaData);
            for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
                for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                    ServiceEndpointInfo seInfo = new ServiceEndpointInfo(udi, (ServerEndpointMetaData)epMetaData);
                    this.epManager.createServiceEndpoint(seInfo);
                }
            }
        }
        catch (Exception ex) {
            log.error("Cannot create service endpoint", ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new WSException(ex);
        }
    }

    public void start(UnifiedDeploymentInfo udi) {
        if (log.isDebugEnabled()) {
            log.debug("start: " + udi.name);
        }
        try {
            UnifiedMetaData wsMetaData = this.getUnifiedMetaData(udi);
            if (wsMetaData != null) {
                if (wsMetaData.getClassLoader() != udi.classLoader) {
                    wsMetaData.setClassLoader(udi.classLoader);
                }
                WSDLFilePublisher wsdlfp = new WSDLFilePublisher(udi);
                wsdlfp.publishWsdlFiles(wsMetaData);
                for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
                    for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                        ObjectName sepID = ((ServerEndpointMetaData)epMetaData).getServiceEndpointID();
                        this.epManager.startServiceEndpoint(sepID);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("Cannot start service endpoint", ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new WSException(ex);
        }
    }

    public void stop(UnifiedDeploymentInfo udi) {
        if (log.isDebugEnabled()) {
            log.debug("stop: " + udi.name);
        }
        try {
            UnifiedMetaData wsMetaData = this.getUnifiedMetaData(udi);
            if (wsMetaData != null) {
                for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
                    for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                        ObjectName sepID = ((ServerEndpointMetaData)epMetaData).getServiceEndpointID();
                        this.epManager.stopServiceEndpoint(sepID);
                    }
                }
                WSDLFilePublisher wsdlfp = new WSDLFilePublisher(udi);
                wsdlfp.unpublishWsdlFiles();
            }
        }
        catch (Exception ex) {
            log.error("Cannot stop service endpoint", ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new WSException(ex);
        }
    }

    public void destroy(UnifiedDeploymentInfo udi) {
        if (log.isDebugEnabled()) {
            log.debug("destroy: " + udi.name);
        }
        try {
            UnifiedMetaData wsMetaData = this.getUnifiedMetaData(udi);
            if (wsMetaData != null) {
                for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
                    for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                        ObjectName sepID = ((ServerEndpointMetaData)epMetaData).getServiceEndpointID();
                        this.epManager.destroyServiceEndpoint(sepID);
                    }
                }
                this.removeUnifiedMetaData(udi);
            }
        }
        catch (Exception ex) {
            log.error("Cannot destroy service endpoint", ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new WSException(ex);
        }
    }

    public UnifiedMetaData getUnifiedMetaData(UnifiedDeploymentInfo udi) {
        UnifiedMetaData wsMetaData = this.metaDataMap.get(udi.name);
        return wsMetaData;
    }

    public void removeUnifiedMetaData(UnifiedDeploymentInfo udi) {
        this.metaDataMap.remove(udi.name);
    }
}

